/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.JSONDataGuideObserver;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONFilterObject;
import oracle.dmt.dataminer.controls.JSONSearchListener;
import oracle.dmt.dataminer.controls.JSONSelectionChangeListener;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructureFilterObserver;
import oracle.dmt.dataminer.controls.JSONStructureTreeTable;
import oracle.dmt.dataminer.controls.JSONStructureUnnestObserver;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideGenEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONFilterType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class JSONStructurePanel
extends AbstractPanel<AbstractDataNode>
implements JSONSelectionChangeListener,
JSONStructureUnnestObserver,
JSONStructureFilterObserver {
    protected static String JSON_SCHEMA_TITLE = ControlsLrb.get("JSON_GUIDE_STRUCTURE_PANEL_TITLE");
    protected List<NameValuePair> dataGuideInfo;
    protected static String titleTemplate = ControlsLrb.get("JSON_QUERY_AGGREGATION_ADD_GTROUP_BY_INCLUDED_TITLE");
    protected Exception _ex = null;
    protected boolean _success = false;
    protected AttributeType selJSONAttribute;
    protected DataGuideProvider dataGuideProvider;
    protected List<JSONAttributeType> editedJSONColumns;
    protected List<JSONAttributeType> previousJSONColumns;
    protected List<JSONFilterType.FilterElement> filters;
    protected JSONColumnsType.Attribute editedJSONColumn;
    protected JScrollPane jsonScrollPane;
    protected JSONStructureTreeTable jsonTree;
    protected JSONDataGuideObserver dataGuideObserver;
    protected boolean showSearchControl = false;
    protected JSONSearchListener listener;
    protected boolean withFiltersOnly = false;
    protected boolean selectedAttrsOnly = false;
    protected ComponentWithTitlebar containerPanel;
    protected ControlBar controlBar;
    protected JSeparator jSeparator;
    protected SearchField searchField;
    protected JLabel titleLabel;

    public JSONStructureTreeTable getJsonTree() {
        return this.jsonTree;
    }

    public JSONStructurePanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, List<JSONAttributeType> list, List<JSONAttributeType> list2, List<JSONFilterType.FilterElement> list3, DataGuideProvider dataGuideProvider, boolean bl) {
        super(context, abstractDataNode);
        this.selJSONAttribute = attributeType;
        this.editedJSONColumns = list;
        this.previousJSONColumns = list2;
        this.filters = list3;
        this.dataGuideProvider = dataGuideProvider;
        this.showSearchControl = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public JSONStructurePanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, JSONColumnsType.Attribute attribute, boolean bl) {
        super(context, abstractDataNode);
        this.selJSONAttribute = attributeType;
        this.editedJSONColumn = attribute;
        this.showSearchControl = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.searchField = new SearchField();
        this.controlBar = new ControlBar();
        this.titleLabel = new JLabel();
        this.jSeparator = new JSeparator();
        this.containerPanel = new ComponentWithTitlebar();
        this.searchField.setPreferredSize(new Dimension(150, 21));
        this.controlBar.setMaximumSize(new Dimension(550, 21));
        this.titleLabel.setText("Title");
        this.containerPanel.setControlBar(this.controlBar);
        this.containerPanel.setLabel(this.titleLabel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.containerPanel, GroupLayout.Alignment.TRAILING, -1, 452, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.containerPanel, -1, 427, Short.MAX_VALUE));
    }

    @Override
    public void initUI() {
        this.jsonScrollPane = new JScrollPane();
        this.createJSONTree();
        this.jsonScrollPane.setVerticalScrollBarPolicy(20);
        this.jsonScrollPane.setHorizontalScrollBarPolicy(30);
        this.jsonScrollPane.setViewportView((Component)((Object)this.jsonTree));
        this.containerPanel.setComponent((JComponent)this.jsonScrollPane);
        this.setupControlBar();
        this.setPanelTitle();
        this.jsonTree.setRootInvisible();
        this.jsonTree.getTree().setRootVisible(false);
        this.jsonTree.setShowGrid(false);
        this.setPreferredColumnWidth();
        this.reload();
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureDefaultTreeTableModel.registerStructureUnnestObserver(this);
        jSONStructureDefaultTreeTableModel.registerStructureFilterObserver(this);
        jSONStructureDefaultTreeTableModel.addJSONSelectionChangeListener(this);
    }

    protected void updatePanelTitle() {
    }

    protected void setupControlBar() {
        if (this.showSearchControl) {
            this.listener = new JSONSearchListener(this);
            this.searchField.addSearchListener((SearchListener)this.listener);
            this.controlBar.add((Component)this.searchField);
            this.searchField.setEnabled(false);
        } else {
            this.searchField.setVisible(false);
        }
    }

    protected void setPanelTitle() {
        this.titleLabel.setText(JSON_SCHEMA_TITLE);
    }

    protected void setPreferredColumnWidth() {
    }

    public void importDataGuide(String string) {
    }

    public void reload() {
        if (this.selJSONAttribute != null) {
            this.enableComponents(false);
            LoadUIData loadUIData = new LoadUIData();
            loadUIData.execute();
        }
    }

    public void reload(String string) {
        LoadUIImport loadUIImport = new LoadUIImport(string);
        loadUIImport.execute();
    }

    public void reload2(AttributeType attributeType, List<JSONAttributeType> list, DataGuideType dataGuideType, List<JSONAttributeType> list2, List<JSONFilterType.FilterElement> list3, boolean bl, boolean bl2) {
        this.selJSONAttribute = attributeType;
        this.editedJSONColumns = list;
        this.previousJSONColumns = list2;
        this.filters = list3;
        this.withFiltersOnly = bl;
        this.selectedAttrsOnly = bl2;
        if (attributeType != null) {
            LoadUI loadUI = new LoadUI(dataGuideType);
            loadUI.execute();
        }
    }

    protected void createJSONTree() {
        this.jsonTree = new JSONStructureTreeTable();
    }

    @Override
    public void initRes() {
    }

    protected int getMaxNumberOfDocuments() {
        return 2000;
    }

    protected int getMaxNumberOfValuesPerDocument() {
        return 10000;
    }

    public int updateTreeSize() {
        return this.updateTreeSize(null);
    }

    protected JSONStructureDefaultTreeTableModel loadJSONPanel(String string) {
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureDefaultTreeTableModel.loadJSONPanel(this.selJSONAttribute, this.dataGuideInfo, this.editedJSONColumns, this.previousJSONColumns, this.filters, string, this.withFiltersOnly, this.selectedAttrsOnly);
        return jSONStructureDefaultTreeTableModel;
    }

    public int updateTreeSize(String string) {
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = this.loadJSONPanel(string);
        int n = jSONStructureDefaultTreeTableModel.getMaxStrLength();
        Dimension dimension = this.jsonTree.getPreferredSize();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            Font font = this.jsonTree.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth("W") * n;
            int n3 = (fontMetrics.getHeight() + 3) * jSONStructureDefaultTreeTableModel.getNodeCount();
            dimension.width = Math.max(n2, dimension.width);
            dimension.height = n3;
            this.jsonTree.setPreferredSize(dimension);
        }
        this.enableComponents(true);
        return dimension.width;
    }

    public void clearTree() {
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureDefaultTreeTableModel.clearTree();
        if (null != this.jsonTree.getTree()) {
            this.jsonTree.getTree().setRootVisible(false);
            this.jsonTree.getTree().setShowsRootHandles(false);
            this.jsonTree.getTree().updateUI();
        }
        this.enableComponents(false);
    }

    public void updateTreeWithNewDataGuide() {
        this.dataGuideInfo.clear();
        DataGuideInfoType dataGuideInfoType = this.editedJSONColumn.getDataGuideInfo();
        if (null != dataGuideInfoType.getCustom()) {
            for (DataGuideType.Item item : dataGuideInfoType.getCustom().getDataGuide().getItem()) {
                String string = item.getPath();
                String string2 = item.getType();
                String string3 = null;
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    string3 = string.substring(n + 1, string.length() - 1);
                }
                NameValuePair nameValuePair = new NameValuePair(string3, (Object)string2);
                NameValuePair nameValuePair2 = new NameValuePair(string, (Object)nameValuePair);
                this.dataGuideInfo.add(nameValuePair2);
            }
        }
        this.updateTreeSize();
        if (null == this.dataGuideInfo || this.dataGuideInfo.isEmpty()) {
            this.jsonTree.getTree().setRootVisible(false);
        }
        this.jsonTree.expandAll(true);
        Iterator iterator = null;
        if (this.dataGuideObserver != null) {
            this.dataGuideObserver.dataGuideAvailable(this.dataGuideInfo, (String)((Object)iterator));
        }
    }

    protected void enableComponents(boolean bl) {
    }

    @Override
    public void treeNodeFilterChanged(JSONElement jSONElement, JSONFilterObject jSONFilterObject) {
        HashMap<String, JSONFilterObject> hashMap = new HashMap<String, JSONFilterObject>();
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        hashMap.put(jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID()), jSONFilterObject);
        this.jsonAttrFilterChanged(hashMap);
    }

    @Override
    public void treeNodeUnnested(JSONElement jSONElement, boolean bl) {
        int[] nArray = this.jsonTree.getSelectedRows();
        this.updateUI();
        for (int i = 0; i < nArray.length; ++i) {
            this.jsonTree.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
        }
        CustomRunnable customRunnable = new CustomRunnable(jSONElement, bl);
        SwingUtilities.invokeLater(customRunnable);
    }

    public void processUnnestEvent(JSONElement jSONElement, boolean bl) {
        JTree jTree = this.jsonTree.getTree();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        if (treeNode.equals((Object)jSONElement)) {
            return;
        }
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        int n = jSONElement.getChildCount();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        JSONElement jSONElement2 = jSONElement;
        if (jSONElement2.getValue(JSONElement.JSON_DATA_COLUMN).equals("ARRAY")) {
            hashMap.put(jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement2.getElementID()), (Boolean)jSONElement2.getValue(JSONElement.JSON_UNNESTED_COLUMN));
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    jSONElement2 = (JSONElement)((Object)jSONElement.getChildAt(i));
                    if (!jSONElement2.getValue(JSONElement.JSON_DATA_COLUMN).equals("ARRAY")) continue;
                    hashMap.put(jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement2.getElementID()), (Boolean)jSONElement2.getValue(JSONElement.JSON_UNNESTED_COLUMN));
                }
            }
        }
        if (!hashMap.isEmpty()) {
            this.jsonAttrUnnestedChanged(hashMap);
        }
    }

    public TreePath findNodePath(TreeNode treeNode) {
        JTree jTree = this.jsonTree.getTree();
        TreeNode treeNode2 = (TreeNode)jTree.getModel().getRoot();
        TreePath treePath = this.findNodePath(jTree, new TreePath(treeNode2), treeNode);
        return treePath;
    }

    public TreePath findNodePath(JTree jTree, TreePath treePath, TreeNode treeNode) {
        TreePath treePath2 = null;
        TreeNode treeNode2 = (TreeNode)treePath.getLastPathComponent();
        if (treeNode2.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode2.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode3 = enumeration.nextElement();
                TreePath treePath3 = treePath.pathByAddingChild(treeNode3);
                if (treeNode.equals(treeNode3)) {
                    treePath2 = treePath3;
                    return treePath2;
                }
                treePath2 = this.findNodePath(jTree, treePath3, treeNode);
                if (treePath2 == null) continue;
                break;
            }
        }
        return treePath2;
    }

    @Override
    public void jsonAttrSelectionChanged(Map<String, Boolean> map) {
        this.updatePanelTitle();
    }

    @Override
    public void jsonAttrSelectionChanged2(Map<JSONElement, Boolean> map) {
        this.updatePanelTitle();
    }

    @Override
    public void jsonAttrUnnestedChanged(Map<String, Boolean> map) {
    }

    public void jsonAttrFilterChanged(Map<String, JSONFilterObject> map) {
    }

    public void registerDataGuideObserver(JSONDataGuideObserver jSONDataGuideObserver) {
        this.dataGuideObserver = jSONDataGuideObserver;
    }

    public void setComboSelectionFromPeer(String string) {
    }

    public void resetMenuSelection() {
    }

    public void savePreviousMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
    }

    public void setMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
    }

    class CustomRunnable
    implements Runnable {
        JSONElement last;
        boolean unnested;

        CustomRunnable(JSONElement jSONElement, boolean bl) {
            this.last = jSONElement;
            this.unnested = bl;
        }

        @Override
        public void run() {
            JSONStructurePanel.this.processUnnestEvent(this.last, this.unnested);
        }
    }

    protected class LoadUIData
    extends LoadUI {
        protected LoadUIData() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            Boolean bl = Boolean.TRUE;
            this.showTree();
            try {
                DataGuideInfoType dataGuideInfoType = JSONStructurePanel.this.editedJSONColumn.getDataGuideInfo();
                if (null != dataGuideInfoType) {
                    if (null != dataGuideInfoType.getSystem()) {
                        String string = dataGuideInfoType.getSystem().getDataGuideTable();
                        JSONStructurePanel.this.dataGuideInfo = new ArrayList<NameValuePair>();
                        if (null == dataGuideInfoType.getSystem().getDataGuide() && null != string) {
                            DataGuideType dataGuideType = DatabaseMetadataUtils.loadDataGuide(JSONStructurePanel.this.getContext(), JSONStructurePanel.this.dataGuideInfo, string);
                            dataGuideInfoType.getSystem().setDataGuide(dataGuideType);
                        } else if (null != dataGuideInfoType.getSystem().getDataGuide()) {
                            for (DataGuideType.Item item : dataGuideInfoType.getSystem().getDataGuide().getItem()) {
                                String string2 = item.getPath();
                                String string3 = item.getType();
                                String string4 = null;
                                int n = string2.lastIndexOf(".");
                                if (n != -1) {
                                    string4 = string2.substring(n + 1, string2.length() - 1);
                                }
                                NameValuePair nameValuePair = new NameValuePair(string4, (Object)string3);
                                NameValuePair nameValuePair2 = new NameValuePair(string2, (Object)nameValuePair);
                                JSONStructurePanel.this.dataGuideInfo.add(nameValuePair2);
                            }
                        }
                    } else if (null != dataGuideInfoType.getCustom() && null != dataGuideInfoType.getCustom().getDataGuide()) {
                        JSONStructurePanel.this.dataGuideInfo = new ArrayList<NameValuePair>();
                        for (DataGuideType.Item item : dataGuideInfoType.getCustom().getDataGuide().getItem()) {
                            String string = item.getPath();
                            String string5 = item.getType();
                            String string6 = null;
                            int n = string.lastIndexOf(".");
                            if (n != -1) {
                                string6 = string.substring(n + 1, string.length() - 1);
                            }
                            NameValuePair nameValuePair = new NameValuePair(string6, (Object)string5);
                            NameValuePair nameValuePair3 = new NameValuePair(string, (Object)nameValuePair);
                            JSONStructurePanel.this.dataGuideInfo.add(nameValuePair3);
                        }
                    }
                } else assert (false) : "Incorrect invocation: Data guide has to be available!";
                JSONStructurePanel.this._success = true;
            }
            catch (Exception exception) {
                JSONStructurePanel.this._ex = exception;
                JSONStructurePanel.this._success = false;
            }
            return bl;
        }
    }

    protected class LoadUIImport
    extends LoadUI {
        String dataguideTableName;

        protected LoadUIImport(String string) {
            this.dataguideTableName = string;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            Boolean bl = Boolean.TRUE;
            this.showTree();
            try {
                if (null != this.dataguideTableName) {
                    JSONStructurePanel.this.dataGuideInfo = new ArrayList<NameValuePair>();
                    DataGuideType dataGuideType = DatabaseMetadataUtils.loadDataGuide(JSONStructurePanel.this.getContext(), JSONStructurePanel.this.dataGuideInfo, this.dataguideTableName);
                    DataGuideInfoType dataGuideInfoType = new DataGuideInfoType();
                    DataGuideInfoType.Custom custom = new DataGuideInfoType.Custom();
                    custom.setDataGuide(dataGuideType);
                    dataGuideInfoType.setCustom(custom);
                    dataGuideInfoType.setStatus(ModelStatusType.COMPLETE);
                    dataGuideInfoType.setGenerate(DataGuideGenEnumType.OFF);
                    JSONStructurePanel.this.editedJSONColumn.setDataGuideInfo(dataGuideInfoType);
                }
                JSONStructurePanel.this._success = true;
            }
            catch (Exception exception) {
                JSONStructurePanel.this._ex = exception;
                JSONStructurePanel.this._success = false;
            }
            return bl;
        }
    }

    protected class LoadUI
    extends SwingWorker<Boolean, Void> {
        protected String result = JSONElement.EMPTY_STRING;
        protected DataGuideType dataGuide;
        private Integer numOfValues;
        private boolean loadDataGuide;

        LoadUI(DataGuideType dataGuideType) {
            this.dataGuide = dataGuideType;
            this.loadDataGuide = false;
            this.numOfValues = 0;
        }

        LoadUI() {
            this.loadDataGuide = true;
            this.numOfValues = 0;
        }

        protected void showTree() {
            JSONStructurePanel.this.jsonTree.getTree().setRootVisible(true);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            this.showTree();
            try {
                if (this.loadDataGuide) {
                    this.dataGuide = JSONStructurePanel.this.dataGuideProvider.getJSONAttrDataGuide(JSONStructurePanel.this.selJSONAttribute, this.numOfValues);
                }
                JSONStructurePanel.this.dataGuideInfo = new ArrayList<NameValuePair>();
                if (this.dataGuide != null) {
                    for (DataGuideType.Item item : this.dataGuide.getItem()) {
                        String string = item.getPath();
                        String string2 = item.getType();
                        String string3 = null;
                        int n = string.lastIndexOf(".");
                        if (n != -1) {
                            string3 = string.substring(n + 1, string.length() - 1);
                        }
                        NameValuePair nameValuePair = new NameValuePair(string3, (Object)string2);
                        NameValuePair nameValuePair2 = new NameValuePair(string, (Object)nameValuePair);
                        JSONStructurePanel.this.dataGuideInfo.add(nameValuePair2);
                    }
                } else {
                    JSONStructurePanel.this.dataGuideInfo.clear();
                    throw new Exception(ControlsLrb.get("JSON_GUIDE_MISSING_MESSAGE"));
                }
                JSONStructurePanel.this._success = true;
            }
            catch (Exception exception) {
                JSONStructurePanel.this._ex = exception;
                JSONStructurePanel.this._success = false;
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            if (null == JSONStructurePanel.this.dataGuideInfo || JSONStructurePanel.this.dataGuideInfo.isEmpty()) {
                JSONStructurePanel.this.jsonTree.getTree().setRootVisible(false);
            } else if (JSONStructurePanel.this.selJSONAttribute != null) {
                JTree jTree = JSONStructurePanel.this.jsonTree.getTree();
                JSONElement jSONElement = (JSONElement)((Object)jTree.getModel().getRoot());
                jSONElement.setRootValue(JSONStructurePanel.this.selJSONAttribute.getAlias() != null ? JSONStructurePanel.this.selJSONAttribute.getAlias() : JSONStructurePanel.this.selJSONAttribute.getName());
                jSONElement.setNodeState(TriStateNode.NodeState.NO);
            }
            JSONStructurePanel.this.enableComponents(true);
            if (JSONStructurePanel.this._success && JSONStructurePanel.this._ex == null) {
                JSONStructurePanel.this.updateTreeSize();
                JSONStructurePanel.this.jsonTree.expandAll(true);
                if (JSONStructurePanel.this.dataGuideObserver != null) {
                    JSONStructurePanel.this.dataGuideObserver.dataGuideAvailable(JSONStructurePanel.this.dataGuideInfo, this.result);
                }
                JSONStructurePanel.this.searchField.setEnabled(true);
                JSONStructurePanel.this.updatePanelTitle();
                JSONStructurePanel.this.updateUI();
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)JSONStructurePanel.this._ex, (String)ControlsLrb.get("JSON_GUIDE_LOADING_FAILURE_TITLE"), (String)ControlsLrb.get("JSON_GUIDE_LOADING_FAILURE_MESSAGE"), null);
            }
        }
    }
}

