/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.HintTextField;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONFilterObject;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.FilterParser;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONValueSelectorPanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.icons.OracleIcons;

public class JSONFilterCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Context context;
    private String dataType;
    private String JSONPath;
    private String JSONDataType;
    private JPanel panel;
    private JLabel label;
    private JComboBox<String> comboBox;
    private HintTextField textField;
    private JButton searchButton;
    private boolean validate = false;
    private static String errorTitle = ControlsLrb.get("ERROR_TITLE");
    private static String NUMBER_SET_HINT = ControlsLrb.get("JSON_QUERY_FILTER_NUMBER_SET_HINT");
    private static String NUMBER_VALUE_HINT = ControlsLrb.get("JSON_QUERY_FILTER_NUMBER_VALUE_HINT");
    private static String STRING_LIST_HINT = ControlsLrb.get("JSON_QUERY_FILTER_STRING_LIST_HINT");
    private static String STRING_SET_HINT = ControlsLrb.get("JSON_QUERY_FILTER_STRING_SET_HINT");
    private static String STRING_VALUE_HINT = ControlsLrb.get("JSON_QUERY_FILTER_STRING_VALUE_HINT");
    private static final int MAX_STRING_LENGTH = 4000;

    public JSONFilterCellEditor(Context context, String string) {
        this.context = context;
        this.dataType = string;
        this.initUI();
    }

    public void activate() {
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component component = this.panel.getComponent(i);
            if (!component.isFocusable()) continue;
            component.requestFocusInWindow();
            return;
        }
        this.panel.requestFocusInWindow();
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.setFocusable(true);
        this.comboBox = new JComboBox();
        this.comboBox.setFocusable(true);
        if ("BOOLEAN".equals(this.dataType)) {
            this.label = new JLabel(ServerConstants.JSONFilterOperators.toHuman((String)"Equal"));
            this.panel.setFocusable(false);
            this.panel.add(this.label);
            this.panel.add(this.comboBox);
        } else {
            this.textField = new HintTextField();
            this.textField.setBorder(null);
            this.textField.setFocusable(true);
            this.panel.add(this.comboBox);
            this.panel.add(this.textField);
            if ("NUMBER".equals(this.dataType) || "STRING".equals(this.dataType)) {
                this.searchButton = new JButton();
                this.searchButton.setIcon(OracleIcons.getIcon((String)"search.png"));
                this.searchButton.setMaximumSize(new Dimension(22, 21));
                this.searchButton.setMinimumSize(new Dimension(22, 21));
                this.searchButton.setPreferredSize(new Dimension(22, 21));
                this.searchButton.setFocusable(true);
                this.panel.add(this.searchButton);
                this.searchButton.addActionListener(new SearchButtonActionListener());
            }
            this.panel.setBackground(this.textField.getBackground());
            this.panel.setBorder(this.textField.getBorder());
        }
        this.panel.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "forward_tab_action");
        this.panel.getActionMap().put("forward_tab_action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < JSONFilterCellEditor.this.panel.getComponentCount(); ++i) {
                    Component component = JSONFilterCellEditor.this.panel.getComponent(i);
                    if (!component.isFocusOwner()) continue;
                    if (i < JSONFilterCellEditor.this.panel.getComponentCount() - 1) {
                        Component component2 = JSONFilterCellEditor.this.panel.getComponent(i + 1);
                        component2.requestFocusInWindow();
                        return;
                    }
                    JSONFilterCellEditor.this.panel.getFocusCycleRootAncestor().requestFocusInWindow();
                    JSONFilterCellEditor.this.stopCellEditing();
                }
            }
        });
        this.panel.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), "backward_tab_action");
        this.panel.getActionMap().put("backward_tab_action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = JSONFilterCellEditor.this.panel.getComponentCount() - 1; i >= 0; --i) {
                    Component component = JSONFilterCellEditor.this.panel.getComponent(i);
                    if (!component.isFocusOwner()) continue;
                    if (i > 0) {
                        Component component2 = JSONFilterCellEditor.this.panel.getComponent(i - 1);
                        component2.requestFocusInWindow();
                        return;
                    }
                    JSONFilterCellEditor.this.panel.getFocusCycleRootAncestor().requestFocusInWindow();
                    JSONFilterCellEditor.this.stopCellEditing();
                }
            }
        });
        if ("BOOLEAN".equals(this.dataType)) {
            this.comboBox.addItem("true");
            this.comboBox.addItem("false");
        } else if ("ARRAY".equals(this.dataType)) {
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"In"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"Less"));
        } else if ("NUMBER".equals(this.dataType) || "STRING".equals(this.dataType)) {
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"In"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"NotIn"));
            if ("STRING".equals(this.dataType)) {
                this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"StartWith"));
                this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"Contain"));
            }
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"Equal"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"NotEqual"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"Greater"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"GreaterOrEqual"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"Less"));
            this.comboBox.addItem(ServerConstants.JSONFilterOperators.toHuman((String)"LessOrEqual"));
        }
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)JSONFilterCellEditor.this.comboBox.getSelectedItem();
                if (JSONFilterCellEditor.this.textField != null) {
                    JSONFilterCellEditor.this.textField.setHint(JSONFilterCellEditor.this.getFilterHint(ServerConstants.JSONFilterOperators.toSchema((String)string)));
                }
            }
        });
    }

    private String getFilterHint(String string) {
        if ("ARRAY".equals(this.dataType)) {
            if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string)) {
                return NUMBER_SET_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorLess((String)string)) {
                return NUMBER_VALUE_HINT;
            }
        } else if ("NUMBER".equals(this.dataType)) {
            if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string)) {
                return NUMBER_SET_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorNotIn((String)string)) {
                return NUMBER_SET_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorEqual((String)string)) {
                return NUMBER_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorNotEqual((String)string)) {
                return NUMBER_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorGreater((String)string)) {
                return NUMBER_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorGreaterEqual((String)string)) {
                return NUMBER_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorLess((String)string)) {
                return NUMBER_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorLessEqual((String)string)) {
                return NUMBER_VALUE_HINT;
            }
        } else if ("STRING".equals(this.dataType)) {
            if (ServerConstants.JSONFilterOperators.isOperatorStartWith((String)string)) {
                return STRING_LIST_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorContain((String)string)) {
                return STRING_LIST_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string)) {
                return STRING_SET_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorNotIn((String)string)) {
                return STRING_SET_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorEqual((String)string)) {
                return STRING_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorNotEqual((String)string)) {
                return STRING_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorGreater((String)string)) {
                return STRING_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorGreaterEqual((String)string)) {
                return STRING_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorLess((String)string)) {
                return STRING_VALUE_HINT;
            }
            if (ServerConstants.JSONFilterOperators.isOperatorLessEqual((String)string)) {
                return STRING_VALUE_HINT;
            }
        }
        return "";
    }

    private boolean allowSetOfValues(String string) {
        return ServerConstants.JSONFilterOperators.isOperatorIn((String)string) || ServerConstants.JSONFilterOperators.isOperatorNotIn((String)string) || ServerConstants.JSONFilterOperators.isOperatorStartWith((String)string) || ServerConstants.JSONFilterOperators.isOperatorContain((String)string);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        TableModel tableModel = jTable.getModel();
        int n3 = jTable.convertRowIndexToModel(n);
        JSONFilterObject jSONFilterObject = (JSONFilterObject)tableModel.getValueAt(n3, JSONElement.JSON_FILTER_COLUMN);
        this.JSONPath = (String)tableModel.getValueAt(n3, JSONElement.JSON_PATH);
        this.JSONDataType = (String)tableModel.getValueAt(n3, JSONElement.JSON_DATA_COLUMN);
        if (jSONFilterObject == null) {
            if ("BOOLEAN".equals(this.dataType)) {
                this.comboBox.setSelectedItem("true");
            } else {
                this.comboBox.setSelectedItem(ServerConstants.JSONFilterOperators.toHuman((String)"Equal"));
                String string = (String)this.comboBox.getSelectedItem();
                if (this.textField != null) {
                    this.textField.setText("");
                    this.textField.setHint(this.getFilterHint(ServerConstants.JSONFilterOperators.toSchema((String)string)));
                }
            }
        } else if ("BOOLEAN".equals(this.dataType)) {
            this.comboBox.setSelectedItem(jSONFilterObject.getConditions());
        } else {
            this.comboBox.setSelectedItem(ServerConstants.JSONFilterOperators.toHuman((String)jSONFilterObject.getOperator()));
            if (this.textField != null) {
                this.textField.setText(jSONFilterObject.getConditions());
            }
        }
        if (this.textField != null) {
            this.textField.requestFocus();
            this.textField.setInputVerifier(new EditorInputVerifier());
        }
        return this.panel;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.isCellContentInvalid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    private boolean isCellContentInvalid() {
        boolean bl = false;
        this.validate = true;
        if (this.textField != null) {
            bl = !this.textField.getInputVerifier().shouldYieldFocus(this.textField);
        }
        return bl;
    }

    @Override
    public JSONFilterObject getCellEditorValue() {
        JSONFilterObject jSONFilterObject = null;
        if ("BOOLEAN".equals(this.dataType)) {
            jSONFilterObject = new JSONFilterObject(this.dataType, "Equal", (String)this.comboBox.getSelectedItem());
        } else if (!this.textField.getText().isEmpty()) {
            jSONFilterObject = new JSONFilterObject(this.dataType, ServerConstants.JSONFilterOperators.toSchema((String)((String)this.comboBox.getSelectedItem())), this.textField.getText());
        }
        return jSONFilterObject;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == 2;
        }
        return super.isCellEditable(eventObject);
    }

    public void commitValue(String string) {
        String string2 = (String)this.comboBox.getSelectedItem();
        boolean bl = this.allowSetOfValues(ServerConstants.JSONFilterOperators.toSchema((String)string2));
        if (bl) {
            this.textField.replaceSelection(string);
        } else {
            this.textField.setText(string);
        }
        this.stopCellEditing();
    }

    public Context getContext() {
        return this.context;
    }

    private static boolean discardJSONSettingsWarning() {
        MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
        Boolean bl = messageDialogPersistence.getConfirmed("warnDiscardJSONTextContain");
        if (Boolean.FALSE.equals(bl)) {
            messageDialogPersistence.setConfirmed("warnDiscardJSONTextContain", Boolean.valueOf(true));
        }
        return 1 == MessageDialog.optionalConfirmOrCancel((String)"warnDiscardJSONTextContain", (Component)Ide.getMainWindow(), (Object)ControlsLrb.get("JSON_QUERY_FILTER_DISCARD_TEXT_CONTAIN_WARNING"), (String)ControlsLrb.get("ERROR_WARNING"), null);
    }

    private class SearchButtonActionListener
    implements ActionListener {
        private SearchButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSONQueryNode jSONQueryNode = (JSONQueryNode)JSONFilterCellEditor.this.context.getProperty("JSONQueryNode");
            AttributeType attributeType = (AttributeType)JSONFilterCellEditor.this.context.getProperty("JSONSourceColumn");
            String string = (String)JSONFilterCellEditor.this.comboBox.getSelectedItem();
            boolean bl = JSONFilterCellEditor.this.allowSetOfValues(ServerConstants.JSONFilterOperators.toSchema((String)string));
            JSONValueSelectorPanel jSONValueSelectorPanel = new JSONValueSelectorPanel(JSONFilterCellEditor.this, jSONQueryNode, attributeType.getName(), JSONFilterCellEditor.this.JSONPath, JSONFilterCellEditor.this.JSONDataType, bl);
            jSONValueSelectorPanel.showAsTooltipDialog(JSONFilterCellEditor.this.panel);
        }
    }

    private class EditorInputVerifier
    extends InputVerifier {
        private EditorInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (!JSONFilterCellEditor.this.validate) {
                return true;
            }
            String string = (String)JSONFilterCellEditor.this.comboBox.getSelectedItem();
            boolean bl = JSONFilterCellEditor.this.allowSetOfValues(ServerConstants.JSONFilterOperators.toSchema((String)string));
            boolean bl2 = true;
            HintTextField hintTextField = (HintTextField)jComponent;
            String string2 = hintTextField.getText();
            if (!string2.isEmpty()) {
                if (ServerConstants.JSONFilterOperators.isOperatorContain((String)ServerConstants.JSONFilterOperators.toSchema((String)string))) {
                    if (!JSONFilterCellEditor.discardJSONSettingsWarning()) {
                        bl2 = false;
                    }
                } else if (string2.length() > 4000) {
                    string2 = string2.substring(0, 4000);
                    String string3 = MessageFormat.format(ControlsLrb.get("JSON_QUERY_FILTER_STRING_TOO_LONG"), 4000);
                    MessageDialog.error((Component)JSONFilterCellEditor.this.panel, (Object)string3, (String)errorTitle, null);
                    bl2 = false;
                } else if (StringUtils.checkDataLossWithMsg(JSONFilterCellEditor.this.context, string2, errorTitle)) {
                    bl2 = false;
                } else {
                    FilterParser filterParser = FilterParser.getInstance();
                    List list = null;
                    try {
                        if ("ARRAY".equals(JSONFilterCellEditor.this.dataType)) {
                            list = filterParser.ParseArray(string2);
                        } else if ("NUMBER".equals(JSONFilterCellEditor.this.dataType)) {
                            list = filterParser.ParseNumber(string2);
                        } else if ("STRING".equals(JSONFilterCellEditor.this.dataType)) {
                            list = filterParser.ParseString(string2);
                        }
                        if (!bl && list.size() > 1) {
                            JOptionPane.showMessageDialog(JSONFilterCellEditor.this.panel, ControlsLrb.get("JSON_QUERY_FILTER_TOO_MANY_VALUES_ERROR"), errorTitle, 0);
                            bl2 = false;
                        }
                    }
                    catch (Exception exception) {
                        bl2 = false;
                        JOptionPane.showMessageDialog(JSONFilterCellEditor.this.panel, exception.getLocalizedMessage(), errorTitle, 0);
                    }
                }
            }
            JSONFilterCellEditor.this.validate = false;
            return bl2;
        }
    }
}

