/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionProvider;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class JSONAggregationOutputNameCellEditor
extends DefaultCellEditor {
    private static int MAX_LENGTH = 32;
    private static int MAX_LENGTH_EX = 130;
    private JSONAggregationFunctionProvider provider;
    private AggregationElementsExType.AggregationElement aggElement;
    private int thisrow = -1;
    protected transient JTextField _tf;
    private Context _context;
    private static String errorTitle = ControlsLrb.get("JSON_QUERY_AGGREGATION_OUTPUT_NAME_ERROR_TITLE");

    public JSONAggregationOutputNameCellEditor(Context context, JSONAggregationFunctionProvider jSONAggregationFunctionProvider) {
        super(new JTextField());
        this.provider = jSONAggregationFunctionProvider;
        this._context = context;
        this._tf = (JTextField)this.getComponent();
        this._tf.addKeyListener(new CustomKeyListener());
        boolean bl = SQLHelper.isExpandedObjNameEnabled(context);
        this._tf.setDocument(new TextFieldLimit(bl ? MAX_LENGTH_EX : MAX_LENGTH));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.thisrow = n;
        if (object == null) {
            this._tf.setText("");
        } else if (object instanceof String) {
            String string = (String)object;
            if (StringUtils.isValidNonQuotedDBObjectName(string) && !StringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            this._tf.setText(string);
        }
        return this._tf;
    }

    protected boolean validate(String string) {
        String string2;
        if (StringUtils.checkDataLossWithMsg(this._context, string, errorTitle)) {
            return false;
        }
        String string3 = string2 = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
        if (!StringUtils.isValidNonQuotedDBObjectName(string2.toUpperCase())) {
            String string4 = ControlsLrb.get("JSON_QUERY_AGGREGATION_OUTPUT_NAME_INVALID_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)errorTitle, null);
            return false;
        }
        if (!this.provider.isOutputNameUnique(string)) {
            String string5 = ControlsLrb.get("JSON_QUERY_AGGREGATION_OUTPUT_NAME_NOT_UNIQUE_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)errorTitle, null);
            return false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this._tf.getText();
    }

    @Override
    public boolean stopCellEditing() {
        String string = (String)this.getCellEditorValue();
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = string.toUpperCase();
        }
        if (!string.trim().isEmpty() && !this.validate(string)) {
            return false;
        }
        this.provider.setOutputName(string, this.thisrow);
        return super.stopCellEditing();
    }

    private class CustomKeyListener
    extends KeyAdapter {
        private CustomKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            if (keyEvent.getKeyCode() == 27) {
                JSONAggregationOutputNameCellEditor.this.aggElement = JSONAggregationOutputNameCellEditor.this.provider.getAggregationElement(JSONAggregationOutputNameCellEditor.this.thisrow);
                if (JSONAggregationOutputNameCellEditor.this.aggElement == null || JSONAggregationOutputNameCellEditor.this.aggElement.getOutput() == null) {
                    jTextField.setText("");
                } else {
                    String string = JSONAggregationOutputNameCellEditor.this.aggElement.getOutput().getName();
                    jTextField.setText(string);
                }
            }
        }
    }
}

