/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.charts.Chart;
import oracle.charts.axischart.AxisChartInteractive;
import oracle.charts.types.AxisTitleDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.LineDesc;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.NumAxisDesc;
import oracle.charts.types.SeriesDesc;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphExporter;
import oracle.dmt.dataminer.controls.GraphPopupClickListener;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;

public class GraphPanel2
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final Logger theLogger = Logger.getLogger(GraphPanel2.class.getName());
    protected int Chart_height = 200;
    protected int Chart_width = 300;
    protected GraphDataModel _dataModel;
    protected GraphExporter _exporter;
    protected AxisChartInteractive _graph;
    private JMenuItem viewData;
    private JMenuItem saveImageAs;
    private JMenuItem copyImage;
    private GraphDataDisplay _targetGraphDataDisplay;

    public GraphPanel2(GraphDataDisplay graphDataDisplay, GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        this.setMinimumSize(new Dimension(0, 0));
        this._targetGraphDataDisplay = graphDataDisplay;
    }

    public Chart getGraph() {
        return this._graph;
    }

    public GraphExporter getExporter() {
        return this._exporter;
    }

    public GraphDataModel getGraphDataModel() {
        return this._dataModel;
    }

    public void initGraph(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        this.initGraph();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            if (this._graph.getSeriesElementExited(n, n2)) {
                this._graph.setSeriesUnHighlight();
                this._graph.setSeriesAnnotationRemove();
                this._graph.repaint();
            }
        }
        catch (ChartException chartException) {
            theLogger.log(Level.FINEST, chartException.getMessage());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            SeriesDesc seriesDesc = this._graph.getSeriesIndexDesc(n, n2);
            int n3 = seriesDesc.getSeriesIndex();
            String string = seriesDesc.getSeriesName();
            this._graph.setSeriesHighlight(string, n3, Color.blue);
            this._graph.repaint();
        }
        catch (ChartException chartException) {
            theLogger.log(Level.FINEST, chartException.getMessage());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            if (this._graph.getSeriesElementExited(n, n2)) {
                this._graph.setSeriesUnHighlight();
                this._graph.setSeriesAnnotationRemove();
                this._graph.repaint();
            }
            if (this._graph.getSeriesElementEntered(n, n2)) {
                SeriesDesc seriesDesc = this._graph.getSeriesIndexDesc(n, n2);
                int n3 = seriesDesc.getSeriesIndex();
                String string = seriesDesc.getSeriesName();
                this._graph.setSeriesHighlight(string, n3, Color.orange);
                this._graph.setSeriesAnnotation(string, n3);
                this._graph.repaint();
            }
        }
        catch (ChartException chartException) {
            theLogger.log(Level.FINEST, chartException.getMessage());
        }
    }

    public void initGraph() {
        try {
            String string;
            int n;
            double[] dArray;
            double[] dArray2;
            int n2;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this._graph = new AxisChartInteractive();
            this._graph.addMouseListener((MouseListener)new GraphPopupClickListener(this._targetGraphDataDisplay, this._graph));
            this._graph.setMinimumSize(new Dimension(0, 0));
            AxisChartInteractive axisChartInteractive = this._graph;
            axisChartInteractive.setSize(this.getWidth(), this.getHeight());
            axisChartInteractive.addMouseListener((MouseListener)this);
            axisChartInteractive.addMouseMotionListener((MouseMotionListener)this);
            axisChartInteractive.setPlotBackground(Color.WHITE);
            axisChartInteractive.setBackground(Color.WHITE);
            axisChartInteractive.setLocale(Locale.getDefault());
            String string2 = this._dataModel.getTitle();
            if (string2 != null) {
                axisChartInteractive.getTitle().setText(this._dataModel.getTitle());
            } else {
                axisChartInteractive.getTitle().setVisible(false);
            }
            Integer n3 = this._dataModel.getGraphType();
            Object[] objectArray = this._dataModel.getRowLabels();
            double d = 0.0;
            double d2 = (Double)this._dataModel.maxX1Value();
            double d3 = 0.0;
            double d4 = (Double)this._dataModel.maxY1Value();
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumFractionDigits(2);
            axisChartInteractive.setXSeries(d, d2, numberFormat);
            AxisTitleDesc axisTitleDesc = new AxisTitleDesc();
            axisTitleDesc.setTitle(this._dataModel.getX1Title());
            axisChartInteractive.setChartAttributes(1, axisTitleDesc);
            AxisTitleDesc axisTitleDesc2 = new AxisTitleDesc();
            axisTitleDesc2.setTitle(this._dataModel.getY1Title());
            axisChartInteractive.setChartAttributes(2, axisTitleDesc2);
            NumAxisDesc numAxisDesc = new NumAxisDesc();
            numAxisDesc.setExtentMin(d3);
            numAxisDesc.setExtentMax(d4);
            numAxisDesc.setNumberFormat(numberFormat);
            axisChartInteractive.setChartAttributes(numAxisDesc);
            Object[][] objectArray2 = this._dataModel.getGraphData();
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                dArray2 = new double[objectArray2[n2].length / 2];
                dArray = new double[objectArray2[n2].length / 2];
                int n4 = 0;
                n = 0;
                for (int i = 0; i < objectArray2[n2].length; ++i) {
                    double d5 = (Double)objectArray2[n2][i];
                    if (i % 2 == 0) {
                        dArray2[n4++] = d5;
                        continue;
                    }
                    dArray[n++] = d5;
                }
                string = (String)objectArray[n2];
                if (objectArray2[n2].length == 2) {
                    axisChartInteractive.setYSeries(string, dArray2, dArray);
                    axisChartInteractive.setSeriesGraphType(string, 0);
                    Object object = this._dataModel.getRowMarkerShapes()[n2];
                    LineDesc lineDesc = new LineDesc();
                    lineDesc.setMarkerType(((Integer)object).intValue());
                    lineDesc.setMarkerScale(1.5);
                    axisChartInteractive.setSeriesGraphic(string, lineDesc);
                    axisChartInteractive.setSeriesInLegend(string, false);
                    continue;
                }
                axisChartInteractive.setYSeries(string, dArray2, dArray);
                axisChartInteractive.setSeriesGraphType(string, 1);
                axisChartInteractive.setSeriesWidth(string, 2);
                axisChartInteractive.setSeriesColor(string, this._dataModel.getRowColors()[n2]);
                axisChartInteractive.setSeriesInLegend(string, false);
            }
            n2 = 4;
            dArray2 = new double[n2];
            dArray = new double[n2];
            objectArray = new String[]{GraphPanel2.stripString(TestViewerLrb.get("ROC_GRAPH_DATA_MAX_OVERALL_ACC"), ":"), GraphPanel2.stripString(TestViewerLrb.get("ROC_GRAPH_DATA_MAX_AVG_ACC"), ":"), GraphPanel2.stripString(TestViewerLrb.get("ROC_GRAPH_DATA_CUSTOM_ACC"), ":"), GraphPanel2.stripString(TestViewerLrb.get("ROC_GRAPH_DATA_MODEL_ACC"), ":")};
            int[] nArray = new int[]{1, 2, 4, 3};
            dArray2[0] = 0.0;
            dArray[0] = 0.0;
            dArray2[1] = 0.0;
            dArray[1] = 0.0;
            dArray2[2] = 0.0;
            dArray[2] = 0.0;
            dArray2[3] = 0.0;
            dArray[3] = 0.0;
            for (n = 0; n < n2; ++n) {
                string = (String)objectArray[n];
                axisChartInteractive.setYSeries(string, dArray2, dArray);
                axisChartInteractive.setSeriesGraphType(string, 0);
                MarkerDesc markerDesc = new MarkerDesc();
                markerDesc.setMarkerType(nArray[n]);
                markerDesc.setMarkerScale(0.0);
                axisChartInteractive.setSeriesGraphic(string, markerDesc);
                axisChartInteractive.setSeriesColor(string, Color.WHITE);
            }
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)this._graph, "Center");
            axisChartInteractive.invalidate();
        }
        catch (ChartException chartException) {
            theLogger.log(Level.FINEST, chartException.getMessage());
        }
    }

    private static String stripString(String string, String string2) {
        int n = string.lastIndexOf(string2);
        String string3 = string.substring(0, n);
        return string3;
    }
}

