/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class GraphLegend
extends JLabel {
    private Color _legendColor;
    private Dimension _size;
    private LegendShape _shape = LegendShape.RECTANGLE;

    public GraphLegend(Color color) {
        this._legendColor = color;
    }

    public GraphLegend(Color color, LegendShape legendShape) {
        this._legendColor = color;
        this._size = new Dimension(6, 6);
        this._shape = legendShape;
        this.setSize(this._size);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke basicStroke = new BasicStroke(0.5f, 2, 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(this._legendColor);
        Rectangle rectangle = this.getBounds();
        switch (this._shape) {
            case RECTANGLE: {
                graphics2D.fillRect(0, (int)rectangle.getCenterY() - 2, 6, 6);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawRect(0, (int)rectangle.getCenterY() - 2, 6, 6);
                break;
            }
            case CIRCLE: {
                graphics2D.fillOval(0, (int)rectangle.getCenterY() - 2, 6, 6);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawOval(0, (int)rectangle.getCenterY() - 2, 6, 6);
                break;
            }
            case TRIANGLE: {
                graphics2D.fillPolygon(new int[]{2, 5, 8}, new int[]{(int)rectangle.getCenterY(), (int)rectangle.getCenterY() - 6, (int)rectangle.getCenterY()}, 3);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawPolygon(new int[]{2, 5, 8}, new int[]{(int)rectangle.getCenterY(), (int)rectangle.getCenterY() - 6, (int)rectangle.getCenterY()}, 3);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("GraphLegend");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GraphLegend graphLegend = new GraphLegend(Color.BLUE);
        jFrame.getContentPane().add("Center", graphLegend);
        jFrame.pack();
        jFrame.setSize(new Dimension(50, 50));
        jFrame.setVisible(true);
    }

    public static enum LegendShape {
        RECTANGLE,
        CIRCLE,
        TRIANGLE;

    }
}

