/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.WrapLayout;
import oracle.dmt.dataminer.core.model.fe.common.Tag;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortType;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.comparator.TagComparator;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.utils.ClipboardUtils;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenPreferences;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class DataMinerTagCloud
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(DataMinerTagCloud.class.getName());
    private static final String TOOLTIP_FORMAT = "<html>%s: %s<br>%s: %f</html>";
    private static final double fontMinSize = 10.0;
    private static final double fontMaxSize = 36.0;
    private static String BITMAP_FILTER_EXT = "bmp";
    private static String JPEG_FILTER_EXT = "jpeg";
    private static String JPEG_FILTER_EXT2 = "jpg";
    private static String PNG_FILTER_EXT = "png";
    private Set<Tag> tags;
    private Font italicFont;
    private SortType orderType = SortType.NUMERICAL;
    private FlowLayout wrapLayout;
    private SortDirection sortDirection = SortDirection.DESCENDING;
    private boolean isFilteredDrawing;
    private ButtonGroup buttonGroup;
    private JMenuItem copyImageMenu;
    private JPopupMenu menu;
    private JMenuItem saveImageMenu;
    private JScrollPane scrollPane;
    private JPanel tagCloudPanel;

    public DataMinerTagCloud() {
        this.italicFont = this.getFont().deriveFont(2);
        this.tags = new TreeSet<Tag>((Comparator<Tag>)new TagComparator(this.orderType, this.sortDirection));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.menu = new JPopupMenu();
        this.copyImageMenu = new JMenuItem();
        this.saveImageMenu = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.tagCloudPanel = new JPanel();
        this.copyImageMenu.setText("Copy Image to Clipboard");
        this.menu.add(this.copyImageMenu);
        this.saveImageMenu.setText("Save Image As...");
        this.menu.add(this.saveImageMenu);
        this.setPreferredSize(new Dimension(600, 300));
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        this.tagCloudPanel.setBackground(new Color(225, 225, 225));
        GroupLayout groupLayout = new GroupLayout(this.tagCloudPanel);
        this.tagCloudPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.scrollPane.setViewportView(this.tagCloudPanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 606, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 288, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.copyImageMenu.setText(WorkflowEditorLrb.get("CONTEXT_MENU_COPY_IMAGE"));
        this.saveImageMenu.setText(WorkflowEditorLrb.get("CONTEXT_MENU_SAVE_IMAGE"));
    }

    @Override
    public void initUI() {
        this.wrapLayout = new WrapLayout(0);
        this.wrapLayout.setVgap(3);
        this.copyImageMenu.addActionListener(actionEvent -> this.copyEditorToClipboard());
        this.saveImageMenu.addActionListener(actionEvent -> this.saveToFile());
        this.tagCloudPanel.setComponentPopupMenu(this.menu);
        this.clearTagPanel();
    }

    public void copyEditorToClipboard() {
        try {
            BufferedImage bufferedImage = this.getScreenShot(this.tagCloudPanel);
            ClipboardUtils clipboardUtils = new ClipboardUtils(bufferedImage);
            clipboardUtils.setContentToClipboard();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private BufferedImage getScreenShot(JPanel jPanel) {
        BufferedImage bufferedImage = new BufferedImage(jPanel.getWidth(), jPanel.getHeight(), 2);
        jPanel.paint(bufferedImage.getGraphics());
        return bufferedImage;
    }

    public boolean saveToFile() {
        boolean bl = false;
        String string = PNG_FILTER_EXT;
        try {
            Object object;
            Preferences preferences = Preferences.getPreferences();
            CodeGenPreferences codeGenPreferences = CodeGenPreferences.getInstance((PropertyStorage)preferences);
            JFileChooser jFileChooser = new JFileChooser();
            String string2 = codeGenPreferences.getCodeLocation();
            if (StringUtils.isNotEmpty((String)string2)) {
                jFileChooser.setSelectedFile(new File(string2));
            }
            String string3 = CommonLrb.get("MSG_BASE_FILENAME");
            jFileChooser.setSelectedFile(new File(string3 + "." + string));
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(CommonLrb.get("MSG_PNG_FILES"), PNG_FILTER_EXT);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(CommonLrb.get("MSG_BMP_FILES"), BITMAP_FILTER_EXT));
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(CommonLrb.get("MSG_JPG_FILES"), JPEG_FILTER_EXT, JPEG_FILTER_EXT2));
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            boolean bl2 = false;
            boolean bl3 = true;
            String string4 = "";
            while (bl3) {
                int n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    string4 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (string4.trim().length() == 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_CODE_EMPTY_FILE_NAME"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null);
                        continue;
                    }
                    bl3 = false;
                    object = new File(string4);
                    codeGenPreferences.setCodeLocation(((File)object).getParent());
                    continue;
                }
                bl3 = false;
                bl2 = true;
            }
            if (bl2) {
                return true;
            }
            File file = new File(string4);
            object = file.getName();
            if (!FileHelper.isFileNameWithSuffix((String)object)) {
                String string5 = string4 + ".jpg";
                file = new File(string5);
            }
            if (file != null && file.exists() && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_SAVE_FILE_OVERWRITE"), (String)DataLrb.get("DATA_VIEWER_SAVE_DLG_TITLE"), null, (boolean)true)) {
                return true;
            }
            ImageIO.write((RenderedImage)this.getScreenShot(this.tagCloudPanel), string, file);
            bl = true;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        return bl;
    }

    private void clearTagPanel() {
        this.tagCloudPanel.setLayout(new GridBagLayout());
        this.tagCloudPanel.removeAll();
        this.tagCloudPanel.add(new JLabel(ControlsLrb.get("TAG_CLOUD_NO_TAGS")));
        this.revalidateComponents();
    }

    private void revalidateComponents() {
        this.tagCloudPanel.validate();
        this.tagCloudPanel.repaint();
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    public void clearWords() {
        this.tags.clear();
        this.clearTagPanel();
    }

    public void addWords(List<? extends Tag> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.tags = new TreeSet<Tag>((Comparator<Tag>)new TagComparator(this.orderType, this.sortDirection));
        this.tags.addAll(list);
    }

    public void redrawCloud(List<? extends Tag> list, boolean bl) {
        this.isFilteredDrawing = bl;
        this.clearWords();
        this.addWords(list);
        this.drawCloud(this.orderType, this.sortDirection);
    }

    private void drawCloud(SortType sortType, SortDirection sortDirection) {
        if (this.tags.isEmpty()) {
            return;
        }
        if (sortType != null) {
            this.orderType = sortType;
        }
        if (sortDirection != null) {
            this.sortDirection = sortDirection;
        }
        double d = this.tags.stream().mapToDouble(tag -> tag.getWeight()).max().getAsDouble();
        double d2 = this.tags.stream().mapToDouble(tag -> tag.getWeight()).min().getAsDouble();
        this.tagCloudPanel.removeAll();
        this.tagCloudPanel.setLayout(this.wrapLayout);
        this.tags.forEach(tag -> {
            double d3 = (tag.getWeight() - d2) / (d - d2) * 26.0 + 10.0;
            JLabel jLabel = new JLabel(tag.getText());
            if (!this.isFilteredDrawing && tag.isFiltered()) {
                jLabel.setForeground(Color.BLUE);
                jLabel.setFont(this.italicFont);
            }
            jLabel.setOpaque(false);
            jLabel.setFont(jLabel.getFont().deriveFont((float)d3));
            jLabel.setToolTipText(String.format(TOOLTIP_FORMAT, CommonLrb.get("COLUMN"), tag.getSource(), CoefficientsLrb.get("COEFFICIENT_COLUMN"), tag.getWeight()));
            this.tagCloudPanel.add(jLabel);
        });
        this.revalidateComponents();
    }

    public void refreshCloud() {
        this.drawCloud(this.orderType, this.sortDirection);
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void setOrderType(SortType sortType) {
        this.orderType = sortType;
    }
}

