/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.ide.Context;
import oracle.javatools.ui.table.GenericTableModel;

public abstract class AbstractAttributeTableModel
extends DefaultTableModel
implements GenericTableModel {
    private Vector<OutputAttributeType> _srcData = new Vector();
    private AbstractNode _nodeData = null;
    private Context _context = null;
    private boolean _writable = true;
    private boolean _piMode = false;
    private static String[] _columnNames = new String[]{ControlsLrb.get("ATTRIBUTE_NAME_COLUMN"), ControlsLrb.get("ATTRIBUTE_ALIAS_COLUMN"), ControlsLrb.get("ATTRIBUTE_DATA_TYPE_COLUMN")};
    public static final int ATTRIBUTE_NAME_COLUMN = 0;
    public static final int ATTRIBUTE_ALIAS_COLUMN = 1;
    public static final int ATTRIBUTE_DATA_TYPE_COLUMN = 2;
    public static final int COLUMN_COUNT = 3;
    private boolean _allowAliasUpdate = false;

    public AbstractAttributeTableModel() {
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
    }

    public AbstractAttributeTableModel(Context context, List<AttributeType> list, AbstractNode abstractNode, boolean bl, boolean bl2) {
        this.addAttributeTypes(true, list);
        this._context = context;
        this._nodeData = abstractNode;
        this._allowAliasUpdate = bl;
        this._piMode = bl2;
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
    }

    public AbstractAttributeTableModel(Context context, AbstractNode abstractNode, List<AttributeType> list, boolean bl, boolean bl2) {
        this._context = context;
        this._nodeData = abstractNode;
        this._allowAliasUpdate = bl;
        this._piMode = bl2;
        this.addAttributeTypes(true, list);
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
    }

    public AbstractAttributeTableModel(Context context, List<OutputAttributeType> list, AbstractNode abstractNode, String string, boolean bl, boolean bl2) {
        this._nodeData = abstractNode;
        this._srcData.addAll(list);
        this._allowAliasUpdate = bl;
        this._context = context;
        this._piMode = bl2;
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
    }

    public void setWritable(boolean bl) {
        this._writable = bl;
    }

    public void reload(List<OutputAttributeType> list) {
        this._srcData.clear();
        this._srcData.addAll(list);
        this.fireTableDataChanged();
    }

    private void addAttributeTypes(boolean bl, List<AttributeType> list) {
        for (AttributeType attributeType : list) {
            OutputAttributeType outputAttributeType = new OutputAttributeType(attributeType);
            outputAttributeType.setIncluded(bl);
            this._srcData.add(outputAttributeType);
        }
    }

    public void refreshAttributeStatus(Vector<OutputAttributeType> vector) {
        HashMap<String, OutputAttributeType> hashMap = new HashMap<String, OutputAttributeType>();
        for (OutputAttributeType outputAttributeType : vector) {
            hashMap.put(outputAttributeType.getName(), outputAttributeType);
        }
        for (OutputAttributeType outputAttributeType : this._srcData) {
            OutputAttributeType outputAttributeType2 = (OutputAttributeType)hashMap.get(outputAttributeType.getName());
            if (this.doColumnsMatch(outputAttributeType2, outputAttributeType)) {
                outputAttributeType.setStatus(AttributeStatus.INVALID);
                continue;
            }
            outputAttributeType.setStatus(AttributeStatus.VALID);
        }
    }

    public int getColumnAlignment(int n) {
        return 2;
    }

    public boolean canHide(int n) {
        return true;
    }

    public void removeDuplicateRowsBasedOnMatch(Vector<OutputAttributeType> vector) {
        HashMap<String, OutputAttributeType> hashMap = new HashMap<String, OutputAttributeType>();
        for (OutputAttributeType outputAttributeType : vector) {
            hashMap.put(outputAttributeType.getName(), outputAttributeType);
        }
        Iterator<OutputAttributeType> iterator = this._srcData.iterator();
        while (iterator.hasNext()) {
            OutputAttributeType outputAttributeType;
            outputAttributeType = iterator.next();
            OutputAttributeType outputAttributeType2 = (OutputAttributeType)hashMap.get(outputAttributeType.getName());
            if (!this.doColumnsMatch(outputAttributeType2, outputAttributeType)) continue;
            iterator.remove();
        }
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    public Vector<OutputAttributeType> createMissingRowsBasedOnMatch(Vector<OutputAttributeType> vector) {
        HashMap<String, OutputAttributeType> hashMap = new HashMap<String, OutputAttributeType>();
        Vector<OutputAttributeType> vector2 = new Vector<OutputAttributeType>();
        for (OutputAttributeType outputAttributeType : this._srcData) {
            hashMap.put(outputAttributeType.getName(), outputAttributeType);
        }
        for (OutputAttributeType outputAttributeType : vector) {
            OutputAttributeType outputAttributeType2;
            if (this.doColumnsMatch(outputAttributeType, outputAttributeType2 = (OutputAttributeType)hashMap.get(outputAttributeType.getName()))) continue;
            vector2.add(outputAttributeType);
        }
        return vector2;
    }

    private boolean doColumnsMatch(OutputAttributeType outputAttributeType, OutputAttributeType outputAttributeType2) {
        return outputAttributeType != null && outputAttributeType2 != null && outputAttributeType.getDataType().equals(outputAttributeType2.getDataType());
    }

    @Override
    public int getRowCount() {
        return this._srcData != null ? this._srcData.size() : 0;
    }

    public Vector<OutputAttributeType> getDataVector() {
        return this._srcData;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
        OutputAttributeType outputAttributeType = this._srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = outputAttributeType.getName();
                break;
            }
            case 1: {
                string = outputAttributeType.getAlias();
                break;
            }
            case 2: {
                string = outputAttributeType.getDataType();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return string;
    }

    public Attributes generateAttributes() {
        Attributes attributes = new Attributes();
        List list = attributes.getAttribute();
        for (OutputAttributeType outputAttributeType : this._srcData) {
            list.add(outputAttributeType.getAttributeType());
        }
        return attributes;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        OutputAttributeType outputAttributeType;
        String string;
        if (n2 != 1) {
            return;
        }
        if (this._nodeData == null) {
            return;
        }
        String string2 = "";
        if (object != null) {
            string2 = ((String)object).trim();
        }
        if ((string = (outputAttributeType = this._srcData.get(n)).getAlias()) != null && StringUtils.isDoubleQuotedString(string2)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        if (string2.length() != 0) {
            if (!StringUtils.isDoubleQuotedString(string2)) {
                string2 = string2.toUpperCase();
            }
            if (string != null && string.compareTo(string2) == 0) {
                return;
            }
            if (!AttributeNameValidator.validateAttributeName(string2, this._srcData, this._context, true)) {
                return;
            }
        }
        if (string != null && string.compareTo(string2) == 0) {
            return;
        }
        string2 = StringUtils.trimDoubleQuotes(string2);
        outputAttributeType.setAlias(string2);
        if (this._piMode) {
            this.updateAlias();
        } else {
            this.fireTableDataChanged();
        }
    }

    protected abstract void updateAlias();

    public void removeDuplicateRows(Vector<OutputAttributeType> vector, int[] nArray) {
        OutputAttributeType outputAttributeType = null;
        for (int i = 0; i < nArray.length; ++i) {
            outputAttributeType = vector.elementAt(nArray[i]);
            this._srcData.remove(outputAttributeType);
        }
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1 && this._allowAliasUpdate) {
            return this._writable;
        }
        return false;
    }

    public void addSelection(Vector<OutputAttributeType> vector, int[] nArray) {
        OutputAttributeType outputAttributeType = null;
        for (int i = 0; i < nArray.length; ++i) {
            outputAttributeType = vector.elementAt(nArray[i]);
            this._srcData.add(outputAttributeType);
        }
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<OutputAttributeType> vector = new Vector<OutputAttributeType>();
        OutputAttributeType outputAttributeType = null;
        for (int i = 0; i < nArray.length; ++i) {
            outputAttributeType = this._srcData.elementAt(nArray[i]);
            vector.add(outputAttributeType);
        }
        this._srcData.removeAll(vector);
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    public boolean isColumnInvalid(int n) {
        OutputAttributeType outputAttributeType = this._srcData.get(n);
        return outputAttributeType.getStatus().equals((Object)AttributeStatus.INVALID);
    }

    public String getInvalidMessage(int n) {
        return "";
    }

    public AbstractNode getData() {
        return this._nodeData;
    }

    public Context getContext() {
        return this._context;
    }
}

