/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.common.model;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;

public class AttrTableModel<T extends AttributeType>
extends ODMrTableModel<T> {
    private static final String[] COLUMNS = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
    public static final int NAME = 0;
    public static final int DATA_TYPE = 1;

    public AttrTableModel(List<T> list) {
        this(COLUMNS, list);
    }

    public AttrTableModel(String[] stringArray, List<T> list) {
        super(stringArray, list);
    }

    public Object getValueAt(int n, int n2) {
        AttributeType attributeType = (AttributeType)this.srcData.get(n);
        switch (n2) {
            case 0: {
                return attributeType;
            }
            case 1: {
                return this.getDataType(attributeType);
            }
        }
        assert (false) : "Invalid column";
        return null;
    }

    protected String getDataType(AttributeType attributeType) {
        String string = attributeType.getDataType();
        String string2 = attributeType.getDataTypeQualifier();
        if (DatabaseMetadataUtils.isACharacterOracleDataType(string)) {
            String string3 = DatabaseMetadataUtils.getJSONDataType(string, string2);
            return string3;
        }
        return string;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 0: {
                return AttributeTypeComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    @Override
    public String getStringValueAt(int n, int n2) {
        AttributeType attributeType = (AttributeType)this.srcData.get(n);
        switch (n2) {
            case 0: {
                return attributeType.getName();
            }
        }
        Object object = this.getValueAt(n, n2);
        return object != null ? object.toString() : null;
    }
}

