/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import oracle.dss.util.svg.batik.LinearGradientExtension;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtendedSVGGraphics2D
extends SVGGraphics2D {
    private Element m_currentElement;
    private Shape m_currentShape;
    private int m_prevMethod;

    public ExtendedSVGGraphics2D(Document d) {
        super(d);
        SVGGeneratorContext ctx = this.getGeneratorContext();
        ctx.setExtensionHandler((ExtensionHandler)new LinearGradientExtension());
    }

    public void draw(Shape s) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element svgShape = this.shapeConverter.toSVG(s);
            if (svgShape != null) {
                this.domGroupManager.addElement(svgShape, (short)1);
                this._registerShape(s, svgShape, "stroke");
            }
        } else {
            Shape strokedShape = stroke.createStrokedShape(s);
            this.fill(strokedShape);
        }
    }

    public void fill(Shape s) {
        Element svgShape = this.shapeConverter.toSVG(s);
        if (svgShape != null) {
            this.domGroupManager.addElement(svgShape, (short)16);
            this._registerShape(s, svgShape, "fill");
        }
    }

    private void _registerShape(Shape shape, Element elem, String attrib) {
        if (shape == this.m_currentShape) {
            this.m_currentElement.setAttribute(attrib, elem.getAttribute(attrib));
            elem.getParentNode().removeChild(elem);
        } else {
            this.m_currentShape = shape;
            this.m_currentElement = elem;
        }
    }

    public Element getCurrentElement() {
        return this.m_currentElement;
    }

    public static void _decorateFocusEffect(Element elem) {
        elem.setAttribute("onmouseover", "setAttribute(\"fill-opacity\", \"0.5\")");
        elem.setAttribute("onmouseout", "setAttribute(\"fill-opacity\", \"1\")");
    }

    public static void _decorateSelectEffect(Element elem) {
        elem.setAttribute("onclick", "setAttribute(\"fill\", \"#c0c0c0\");setAttribute(\"fill-opacity\", \"0.1\")");
    }
}

