/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DVTImageMapTranscoder
extends SVGAbstractTranscoder {
    private final String CDATA = "CDATA";
    private final String AREA_TAG = "area";
    private final String MAP_TAG = "map";
    private final String MAP_NAME_ATTR = "name";
    private final String TITLE_ATTR = "title";
    private final String AREA_TAG_SHAPE_ATTR = "shape";
    private final String AREA_TAG_SHAPE_ATTR_POLY = "poly";
    private final String AREA_TAG_COORDS_ATTR = "coords";
    private final DecimalFormat decFormat = new DecimalFormat("#.##");
    private String _mapName = null;
    private int _imageWidth = -1;
    private int _imageHeight = -1;

    public DVTImageMapTranscoder() {
    }

    public DVTImageMapTranscoder(String mapName, int imageWidth, int imageHeight) {
        this._mapName = mapName;
        this._imageWidth = imageWidth;
        this._imageHeight = imageHeight;
    }

    private TransformerHandler getTransformerHandler(TranscoderOutput output) throws TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        TransformerHandler handler = null;
        if (tfactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            SAXTransformerFactory stfactory = (SAXTransformerFactory)tfactory;
            handler = stfactory.newTransformerHandler();
            handler.setResult(new StreamResult(output.getWriter()));
        }
        return handler;
    }

    private String getTitle(SVGElement element) {
        Node n = element.getFirstChild();
        if (n != null && n.getNodeName().equals("desc")) {
            return n.getTextContent();
        }
        return null;
    }

    protected BridgeContext createBridgeContext(SVGOMDocument doc) {
        BridgeContext context = super.createBridgeContext(doc);
        context.setDynamicState(2);
        return context;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        Node node;
        TransformerHandler handler;
        super.transcode(document, uri, output);
        try {
            handler = this.getTransformerHandler(output);
        }
        catch (TransformerConfigurationException ex) {
            throw new TranscoderException((Exception)ex);
        }
        AttributesImpl myatt = new AttributesImpl();
        myatt.addAttribute("", "name", "name", "CDATA", this._mapName);
        try {
            handler.startDocument();
            handler.startElement("", "map", "map", myatt);
        }
        catch (SAXException ex) {
            throw new TranscoderException((Exception)ex);
        }
        NodeIterator i = ((DocumentTraversal)((Object)document)).createNodeIterator(document, 1, null, true);
        while ((node = i.nextNode()) != null) {
            String title;
            SVGElement elementNode;
            try {
                elementNode = (SVGElement)node;
            }
            catch (ClassCastException ex) {
                continue;
            }
            GraphicsNode gn = this.ctx.getGraphicsNode((Node)elementNode);
            if (gn == null || (title = this.getTitle(elementNode)) == null || title.isEmpty()) continue;
            this.createAreaTag(title, gn, handler);
        }
        try {
            handler.endElement("", "map", "map");
            handler.endDocument();
        }
        catch (SAXException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    private AttributesImpl createAreaTagAttr(ArrayList<Double> coords, String title) {
        StringBuilder strCoords = new StringBuilder();
        for (int i = 0; i < coords.size(); ++i) {
            strCoords.append(this.decFormat.format(coords.get(i)));
            strCoords.append(',');
        }
        strCoords.deleteCharAt(strCoords.length() - 1);
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "shape", "shape", "CDATA", "poly");
        att.addAttribute("", "coords", "coords", "CDATA", strCoords.toString());
        att.addAttribute("", "title", "title", "CDATA", title);
        return att;
    }

    private void createAreaTag(String title, GraphicsNode node, TransformerHandler filter) throws TranscoderException {
        AffineTransform tx = node.getGlobalTransform();
        tx.preConcatenate(this.curTxf);
        ArrayList<Double> coords = new ArrayList<Double>();
        AttributesImpl att = null;
        int numPoints = 0;
        boolean isTagCreated = false;
        PathIterator path = node.getOutline().getPathIterator(tx, 1.0);
        while (!path.isDone()) {
            double[] points = new double[6];
            int seg = path.currentSegment(points);
            if (seg == 4) {
                if (numPoints > 2) {
                    isTagCreated = true;
                    att = this.createAreaTagAttr(coords, title);
                    break;
                }
            } else {
                coords.add(points[0]);
                coords.add(points[1]);
                ++numPoints;
            }
            path.next();
        }
        if (!isTagCreated && numPoints == 2) {
            att = this.createAreaTagAttr(this.getLineOutline(coords), title);
        }
        if (att != null) {
            try {
                filter.startElement("", "area", "area", att);
                filter.endElement("", "area", "area");
            }
            catch (SAXException ex) {
                throw new TranscoderException((Exception)ex);
            }
        }
    }

    private double calcYCoordFromDistance(double slopeSq, double y, double dist) {
        double denominator = Math.sqrt(1.0 / slopeSq + 1.0);
        return dist / denominator + y;
    }

    private double calcXCoordFromDistance(double slopeSq, double x, double dist) {
        return dist / Math.sqrt(slopeSq + 1.0) + x;
    }

    private ArrayList<Double> getLineOutline(ArrayList<Double> coords) {
        double origX1 = coords.get(0);
        double origY1 = coords.get(1);
        double origX2 = coords.get(2);
        double origY2 = coords.get(3);
        double dx = origX2 - origX1;
        double dy = origY2 - origY1;
        ArrayList<Double> bbox = new ArrayList<Double>();
        if (dy == 0.0) {
            bbox.add(origX1);
            bbox.add(origY1 + 1.5);
            bbox.add(origX2);
            bbox.add(origY2 + 1.5);
            bbox.add(origX2);
            bbox.add(origY2 - 1.5);
            bbox.add(origX1);
            bbox.add(origY1 - 1.5);
        } else if (dx == 0.0) {
            bbox.add(origX1 + 1.5);
            bbox.add(origY1);
            bbox.add(origX2 + 1.5);
            bbox.add(origY2);
            bbox.add(origX2 - 1.5);
            bbox.add(origY2);
            bbox.add(origX1 - 1.5);
            bbox.add(origY1);
        } else {
            double slope = -dx / dy;
            double slopeSq = Math.pow(slope, 2.0);
            bbox.add(this.calcXCoordFromDistance(slopeSq, origX1, 1.5));
            bbox.add(this.calcYCoordFromDistance(slopeSq, origY1, 1.5));
            bbox.add(this.calcXCoordFromDistance(slopeSq, origX2, 1.5));
            bbox.add(this.calcYCoordFromDistance(slopeSq, origY2, 1.5));
            bbox.add(this.calcXCoordFromDistance(slopeSq, origX2, -1.5));
            bbox.add(this.calcYCoordFromDistance(slopeSq, origY2, -1.5));
            bbox.add(this.calcXCoordFromDistance(slopeSq, origX1, -1.5));
            bbox.add(this.calcYCoordFromDistance(slopeSq, origY1, -1.5));
        }
        return bbox;
    }
}

