/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.containers;

import java.awt.Polygon;
import java.awt.geom.Path2D;
import java.io.InputStream;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.Ellipse;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Rectangle;
import oracle.dss.util.svg.batik.DVTTranscoder;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import org.apache.batik.transcoder.TranscoderInput;

@CodeSharingSafe(value="StaticInitializer")
public class Marker
extends Container {
    Container m_marker;
    String m_id;
    public static final String HUMAN_ID = "h";
    public static final String PLUS_ID = "p";
    public static final String DIAMOND_ID = "d";
    public static final String SQUARE_ID = "s";
    public static final String TUP_ID = "tu";
    public static final String TDN_ID = "td";
    public static final String CIRCLE_ID = "c";
    public static final String SHAPE_SQUARE = "square";
    public static final String SHAPE_CIRCLE = "circle";
    public static final String SHAPE_DIAMOND = "diamond";
    public static final String SHAPE_PLUS = "plus";
    public static final String SHAPE_TRIANGLE_DOWN = "triangleDown";
    public static final String SHAPE_TRIANGLE_UP = "triangleUp";
    public static final String SHAPE_HUMAN = "human";
    public static final int DEF_SIZE = 8;
    public static final Path2D HUMAN_DEF = new Path2D.Double();

    public Marker(String id) {
        super(id);
    }

    public void loadDefinition(InputStream def) {
        DVTTranscoder parser = new DVTTranscoder();
        try {
            parser.transcode(new TranscoderInput(def));
            this.m_drawables.addAll(parser.getDrawables());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Marker getHumanMarker() {
        Marker marker = new Marker(HUMAN_ID);
        marker.add(new Path(HUMAN_DEF));
        return marker;
    }

    public static Marker getPlusMarker() {
        Marker marker = new Marker(PLUS_ID);
        Polygon polygon = new Polygon();
        int depth = 1;
        boolean done = false;
        while (!done) {
            if (8 >= (depth += 2) * 3 + 2) continue;
            done = true;
            depth -= 2;
        }
        int halfDepth = (depth + 1) / 2;
        polygon.addPoint(-halfDepth, -4);
        polygon.addPoint(halfDepth, -4);
        polygon.addPoint(halfDepth, -halfDepth);
        polygon.addPoint(4, -halfDepth);
        polygon.addPoint(4, halfDepth);
        polygon.addPoint(halfDepth, halfDepth);
        polygon.addPoint(halfDepth, 4);
        polygon.addPoint(-halfDepth, 4);
        polygon.addPoint(-halfDepth, halfDepth);
        polygon.addPoint(-4, halfDepth);
        polygon.addPoint(-4, -halfDepth);
        polygon.addPoint(-halfDepth, -halfDepth);
        polygon.addPoint(-halfDepth, -4);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getDiamondMarker() {
        Marker marker = new Marker(DIAMOND_ID);
        Polygon polygon = new Polygon();
        polygon.addPoint(4, 0);
        polygon.addPoint(0, -4);
        polygon.addPoint(-4, 0);
        polygon.addPoint(0, 4);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getSquareMarker() {
        Marker marker = new Marker(SQUARE_ID);
        marker.add(new Rectangle(-4.0, -4.0, 8.0, 8.0));
        return marker;
    }

    public static Marker getTriangleUpMarker() {
        Marker marker = new Marker(TUP_ID);
        int skewTip = (int)Math.round(4.8);
        int skewBtm = (int)Math.round(3.2);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, skewTip);
        polygon.addPoint(4, skewBtm);
        polygon.addPoint(-4, skewBtm);
        polygon.addPoint(0, skewTip);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getTriangleDownMarker() {
        Marker marker = new Marker(TDN_ID);
        int skewTip = (int)Math.round(4.8);
        int skewBtm = (int)Math.round(3.2);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, skewTip);
        polygon.addPoint(4, skewBtm);
        polygon.addPoint(-4, skewBtm);
        polygon.addPoint(0, skewTip);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getCircleMarker() {
        Marker marker = new Marker(CIRCLE_ID);
        marker.add(new Ellipse(-4.0, -4.0, 8.0, 8.0));
        return marker;
    }

    static {
        HUMAN_DEF.moveTo(39.791983, 38.300506);
        HUMAN_DEF.curveTo(47.199983, 38.300506, 53.205983, 32.296506, 53.205983, 24.894506);
        HUMAN_DEF.lineTo(53.205983, 15.636506);
        HUMAN_DEF.curveTo(53.205983, 8.234506, 47.199983, 2.232506, 39.791983, 2.232506);
        HUMAN_DEF.curveTo(32.381983, 2.232506, 26.377983, 8.234506, 26.377983, 15.636506);
        HUMAN_DEF.lineTo(26.377983, 24.894506);
        HUMAN_DEF.curveTo(26.377983, 32.296506, 32.381983, 38.300506, 39.791983, 38.300506);
        HUMAN_DEF.closePath();
        HUMAN_DEF.moveTo(56.010983, 45.575506);
        HUMAN_DEF.lineTo(23.574983, 45.575506);
        HUMAN_DEF.curveTo(9.5389825, 45.575506, 2.2219825, 56.954506, 2.2219825, 70.989506);
        HUMAN_DEF.lineTo(2.2219825, 125.38551);
        HUMAN_DEF.lineTo(14.967983, 125.38551);
        HUMAN_DEF.lineTo(14.967983, 73.776506);
        HUMAN_DEF.curveTo(14.967983, 72.215506, 14.748983, 70.952506, 15.760983, 70.952506);
        HUMAN_DEF.curveTo(16.772983, 70.952506, 16.502983, 72.304506, 16.502983, 73.661506);
        HUMAN_DEF.lineTo(16.502983, 197.92951);
        HUMAN_DEF.curveTo(16.502983, 199.49051, 17.768983, 200.75351, 19.326983, 200.75351);
        HUMAN_DEF.lineTo(31.857983, 200.75351);
        HUMAN_DEF.curveTo(33.417983, 200.75351, 34.681983, 199.48951, 34.681983, 197.92951);
        HUMAN_DEF.lineTo(34.681983, 131.67951);
        HUMAN_DEF.lineTo(44.900983, 131.67951);
        HUMAN_DEF.lineTo(44.900983, 197.92951);
        HUMAN_DEF.curveTo(44.900983, 199.49051, 46.164983, 200.75351, 47.724983, 200.75351);
        HUMAN_DEF.lineTo(60.252983, 200.75351);
        HUMAN_DEF.curveTo(61.812983, 200.75351, 63.077983, 199.48951, 63.077983, 197.92951);
        HUMAN_DEF.lineTo(63.077983, 73.661506);
        HUMAN_DEF.curveTo(63.077983, 72.304506, 62.960983, 70.952506, 63.916983, 70.952506);
        HUMAN_DEF.curveTo(64.872983, 70.952506, 64.708983, 72.216506, 64.708983, 73.776506);
        HUMAN_DEF.lineTo(64.708983, 125.38551);
        HUMAN_DEF.lineTo(77.358983, 125.38551);
        HUMAN_DEF.lineTo(77.358983, 70.989506);
        HUMAN_DEF.curveTo(77.360983, 56.954506, 70.047983, 45.575506, 56.010983, 45.575506);
        HUMAN_DEF.closePath();
    }
}

