/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.presutil;

import java.awt.Color;
import oracle.dss.graph.pfj.AssertionException;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GradientStopObj
implements Cloneable {
    private final double m_position;
    private final Color m_leftColor;
    private final Color m_rightColor;

    GradientStopObj(double position, Color color) {
        this.m_leftColor = color;
        this.m_rightColor = color;
        if (!(position >= 0.0) || !(position <= 1.0)) {
            throw new AssertionException(0.0, 1.0, position);
        }
        this.m_position = position;
    }

    GradientStopObj(double position, Color leftColor, Color rightColor) {
        this.m_leftColor = leftColor;
        this.m_rightColor = rightColor;
        if (!(position >= 0.0) || !(position <= 1.0)) {
            throw new AssertionException(0.0, 1.0, position);
        }
        this.m_position = position;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GradientStopObj)) {
            return false;
        }
        GradientStopObj stop = (GradientStopObj)obj;
        if (this.m_position != stop.m_position) {
            return false;
        }
        if (!this.m_leftColor.equals(stop.m_leftColor)) {
            return false;
        }
        return this.m_rightColor.equals(stop.m_rightColor);
    }

    protected Object clone() {
        return new GradientStopObj(this.m_position, this.m_leftColor, this.m_rightColor);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + (int)(this.m_position * 100.0);
        hashCode = 31 * hashCode + this.m_leftColor.getAlpha();
        hashCode = 31 * hashCode + this.m_leftColor.getRGB();
        hashCode = 31 * hashCode + this.m_rightColor.getAlpha();
        hashCode = 31 * hashCode + this.m_rightColor.getRGB();
        return hashCode;
    }

    public double getPosition() {
        return this.m_position;
    }

    public Color getLeftColor() {
        return this.m_leftColor;
    }

    public Color getRightColor() {
        return this.m_rightColor;
    }

    public Color getColor() {
        return this.m_rightColor;
    }
}

