/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.pagingControl.CommonPagingControl;
import oracle.dss.pagingControl.PageItem;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.pagingControl.PagingControlAttributes;
import oracle.dss.pagingControl.PagingControlConstants;
import oracle.dss.pagingControl.PagingControlController;
import oracle.dss.pagingControl.PagingControlControllerAdapter;
import oracle.dss.pagingControl.PagingControlDefaultValues;
import oracle.dss.pagingControl.PagingControlListener;
import oracle.dss.pagingControl.PagingControlModel;
import oracle.dss.pagingControl.PagingControlModelAdapter;
import oracle.dss.pagingControl.PagingControlStyleManager;
import oracle.dss.pagingControl.PagingControlXML;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;
import oracle.javatools.annotations.Concealed;

public class PagingControl
extends Dataview
implements ComponentListener,
FocusListener,
MouseListener,
MouseMotionListener,
PagingControlAttributes,
PagingControlConstants,
ViewComponent {
    private static final long serialVersionUID = 1L;
    @Concealed
    protected DataSource m_dataSource = null;
    @Concealed
    protected PagingControlController m_pagingControlController = null;
    @Concealed
    protected PagingControlModel m_pagingControlModel = null;
    @Concealed
    protected CommonPagingControl m_commonPagingControl = null;
    @Concealed
    protected DataviewCommon m_view = null;
    @Concealed
    protected boolean m_printOrPreviewMode = false;
    @Concealed
    protected PagingComponent m_pc = null;
    @Concealed
    protected JLabel m_label = null;
    @Concealed
    protected JScrollPane m_scrollPane;
    @Concealed
    protected int m_zoomFactor = 100;
    @Concealed
    protected static final int BORDER_LEFT_SPACING = 5;
    @Concealed
    protected static final int BORDER_RIGHT_SPACING = 5;
    @Concealed
    protected static final int BORDER_TOP_SPACING = 5;
    @Concealed
    protected static final int BORDER_BOTTOM_SPACING = 5;
    private Font _defaultLabelFont = null;
    private ViewStyle _viewStyle = null;
    private boolean _swapAllowed = true;
    private Dimension _prefSize;
    private int _previousItemCount;
    private int _previousPageItemIndex = -1;
    private boolean _dragging;
    private BufferedImage _imgGhost;
    private boolean _pagingControlSelected = false;
    private boolean _embedded = false;

    public PagingControl() {
        this._setupPagingControlView();
        this.getAccessibleContext().setAccessibleName(this.getLabelText());
    }

    public PagingControl(DataSource ds) {
        this.m_dataSource = ds;
        this._setupPagingControlView();
        this.getAccessibleContext().setAccessibleName(this.getLabelText());
    }

    @Concealed
    PagingControl(Dataview view) {
        this._embedded = true;
        this.m_dataSource = view.getDataSource();
        this.m_commonPagingControl = new CommonPagingControl(this, this.getLocale(), true);
        this.setCommonDataview(this.m_commonPagingControl);
        this.setLocale(view.getLocale());
        this.setZoomFactor(view.getZoomFactor());
        this.setFormatProvider(view);
        this.setLayerMetadataLabelType(view.getLayerMetadataLabelType(2));
        this._setupPagingControlView();
    }

    private void _setupPagingControlView() {
        if (this.m_commonPagingControl == null) {
            this.m_commonPagingControl = new CommonPagingControl(this, this.getLocale(), false);
        }
        this.setCommonDataview(this.m_commonPagingControl);
        this.m_pagingControlModel = new PagingControlModelAdapter(this);
        this.setModel(this.m_pagingControlModel);
        if (this.m_dataSource != null) {
            this.setDataSource(this.m_dataSource);
        } else {
            this.m_dataSource = new LocalDataSource();
            this.setDataSource(new LocalDataSource());
        }
        this.m_pagingControlModel.setDataSource(this.m_dataSource);
        this.init();
        this.m_pagingControlController = new PagingControlControllerAdapter(this, this._embedded);
        this.setController(this.m_pagingControlController);
        this.m_commonPagingControl.setPagingControlStyleManager(this.m_pagingControlModel.getPagingControlStyleManager());
    }

    @Concealed
    public CommonPagingControl getCommonPagingControl() {
        return this.m_commonPagingControl;
    }

    @Concealed
    public void setPagingControlModel(PagingControlModel pagingControlModel) {
        super.setModel(pagingControlModel);
        PagingControlModel oldModel = this.m_pagingControlModel;
        this.m_pagingControlModel = pagingControlModel;
        this.firePropertyChange(this, "PagingControlModel", oldModel, this.m_pagingControlModel);
    }

    public PagingControlModel getPagingControlModel() {
        return this.m_pagingControlModel;
    }

    @Concealed
    public void setPagingControlController(PagingControlController pagingControlController) {
        super.setController(pagingControlController);
        PagingControlController oldController = this.m_pagingControlController;
        if (oldController != null) {
            oldController.cleanUp();
        }
        this.m_pagingControlController = pagingControlController;
        this.firePropertyChange(this, "PagingControlController", oldController, this.m_pagingControlController);
    }

    public PagingControlController getPagingControlController() {
        return this.m_pagingControlController;
    }

    @Concealed
    public void setPagingControlStyleManager(PagingControlStyleManager m) {
        if (this.m_pagingControlModel != null) {
            PagingControlStyleManager oldStyle = this.m_pagingControlModel.getPagingControlStyleManager();
            this.m_pagingControlModel.setPagingControlStyleManager(m);
            this.m_commonPagingControl.setPagingControlStyleManager(m);
            this.firePropertyChange(this, "PagingControlStyleManager", oldStyle, m);
        }
    }

    public PagingControlStyleManager getPagingControlStyleManager() {
        if (this.m_pagingControlModel != null) {
            return this.m_pagingControlModel.getPagingControlStyleManager();
        }
        return null;
    }

    public void addPagingControlListener(PagingControlListener l) {
        if (this.m_pagingControlController != null) {
            this.m_pagingControlController.addPagingControlListener(l);
        }
    }

    public void removePagingControlListener(PagingControlListener l) {
        if (this.m_pagingControlController != null) {
            this.m_pagingControlController.removePagingControlListener(l);
        }
    }

    @Override
    @Concealed
    public void modelDataChanged(DataChangedEvent e) {
        if (e.getType() == 2) {
            this.refreshData();
        }
        super.modelDataChanged(e);
        this.m_commonPagingControl.setDataAccess(e.getDataAccess());
        if (e.isPageDirty()) {
            this.updatePageItems();
        } else {
            this.updateCurrentPage();
        }
    }

    @Override
    @Concealed
    public void modelDataAvailable(DataAvailableEvent e) {
        this.refreshData();
        super.modelDataAvailable(e);
        this.m_commonPagingControl.setDataAccess(e.getDataAccess());
        if (this.getPagingComponent() != null) {
            this.updatePageItems();
        }
    }

    @Override
    @Concealed
    public void modelWaitDataAvailable(WaitDataAvailableEvent e) {
        this.refreshData();
        super.modelWaitDataAvailable(e);
    }

    @Override
    public void setFormatProvider(DataviewCommon view) {
        this.m_view = view;
    }

    @Override
    public DataviewCommon getFormatProvider() {
        return this.m_view;
    }

    @Override
    @Concealed
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.m_commonPagingControl.setLocale(loc);
        this.updateResourceBundle();
        if (this.m_dataSource != null && this.m_dataSource instanceof LocalDataSource) {
            ((LocalDataSource)this.m_dataSource).setLocale(loc);
        }
    }

    private void updateResourceBundle() {
        this.m_commonPagingControl.updateResourceBundle();
        if (this.m_label != null) {
            this.m_label.setText(this.m_commonPagingControl.getIntlString(this.getLabelText()));
        }
    }

    public void setLabelText(String label) {
        this.m_commonPagingControl.setLabelText(label);
        this.m_label.setText(label);
    }

    public String getLabelText() {
        return this.m_commonPagingControl.getLabelText();
    }

    public void setLabelVisible(boolean visible) {
        this.m_commonPagingControl.setLabelVisible(visible);
        this.m_label.setVisible(visible);
    }

    public boolean isLabelVisible() {
        return this.m_commonPagingControl.isLabelVisible();
    }

    public void setOrientation(int orientation) {
        if (orientation != this.getOrientation()) {
            this.m_commonPagingControl.setOrientation(orientation);
            this.removeAll();
            this.init();
        }
    }

    public int getOrientation() {
        return this.m_commonPagingControl.getOrientation();
    }

    public void setDragEnabled(boolean drag) {
        this.m_commonPagingControl.setDragEnabled(drag);
        if (drag) {
            this.getPagingControlController().enableDrag();
        } else {
            this.getPagingControlController().disableDrag();
        }
    }

    public boolean isDragEnabled() {
        return this.m_commonPagingControl.isDragEnabled();
    }

    public void setSplitterDragEnabled(boolean splitterDragEnabled) {
        this.m_commonPagingControl.setSplitterDragEnabled(splitterDragEnabled);
    }

    public boolean isSplitterDragEnabled() {
        return this.m_commonPagingControl.isSplitterDragEnabled();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_commonPagingControl.setVisible(visible);
        if (this.m_label != null && this.isLabelVisible()) {
            this.m_label.setVisible(visible);
        }
        if (this.m_pc != null) {
            this.m_pc.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_commonPagingControl.isVisible();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_commonPagingControl.setEnabled(enabled);
        if (this.m_label != null) {
            this.m_label.setEnabled(enabled);
        }
        if (this.m_pc != null) {
            this.m_pc.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_commonPagingControl.isEnabled();
    }

    @Override
    @Concealed
    public void setSwapAllowed(boolean swap) {
        this.m_commonPagingControl.setSwapAllowed(swap);
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            pc.setSwapAllowed(swap);
        }
    }

    @Override
    @Concealed
    public boolean isSwapAllowed() {
        return this.m_commonPagingControl.isSwapAllowed();
    }

    public void setPageItemLabelVisible(boolean visible) {
        if (visible != this.isPageItemLabelVisible()) {
            this.m_commonPagingControl.setPageItemLabelVisible(visible);
            this.updatePageItems();
        }
    }

    public boolean isPageItemLabelVisible() {
        return this.m_commonPagingControl.isPageItemLabelVisible();
    }

    @Concealed
    public void setZoomFactor(int zoom) {
        this.m_zoomFactor = zoom;
        if (this.m_pc != null) {
            this.m_pc.setZoomFactor(zoom);
            if (this.m_label != null) {
                this._defaultLabelFont = this.m_label.getFont();
                if (zoom != this.m_zoomFactor) {
                    this.m_label.setFont(this.scaleFont(this._defaultLabelFont, zoom));
                } else {
                    this.m_label.setFont(this._defaultLabelFont);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._prefSize != null) {
            return this._prefSize;
        }
        this.calculatePreferredSize();
        return this._prefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._prefSize != null) {
            return this._prefSize;
        }
        this.calculatePreferredSize();
        return this._prefSize;
    }

    public DropTargetListener getDropTargetListener() {
        return this.getPagingControlController().getDropTargetListener();
    }

    @Override
    public void cleanUp() {
        this.m_pc.removeMouseListener(this);
        this.m_pc.removeMouseMotionListener(this);
        this.m_pagingControlController.cleanUp();
        this.m_pagingControlController = null;
        this.m_scrollPane = null;
        this.removeComponentListener(this);
        super.cleanUp();
    }

    private void init() {
        this.setName("PagingControl_PageAxis");
        if (this.getOrientation() == 0) {
            this.setLayout(new BoxLayout(this, 0));
        } else {
            this.setLayout(new BoxLayout(this, 1));
        }
        this.m_label = new JLabel(this.getLabelText());
        this.add(this.m_label);
        this.m_label.setVisible(this.isLabelVisible());
        this.m_label.setName("PagingControl_Label");
        this._defaultLabelFont = this.m_label.getFont();
        this.m_pc = new PagingComponent(this);
        if (this._viewStyle != null) {
            this.m_pc.setViewStyle(this._viewStyle);
        }
        this.m_pc.setZoomFactor(this.getZoomFactor());
        this.m_pc.setEnabled(this.isEnabled());
        this.m_pc.setSwapAllowed(this._swapAllowed);
        this.m_pc.addMouseListener(this);
        this.m_pc.addMouseMotionListener(this);
        this.m_scrollPane = new JScrollPane((Component)((Object)this.m_pc));
        this.add(this.m_scrollPane);
        this.m_scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                PagingControl.this.repaint();
            }
        });
        this.m_scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                PagingControl.this.repaint();
            }
        });
        this.m_scrollPane.setName("PagingControl_ScrollPane");
        this.addComponentListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    @Override
    @Concealed
    public void componentShown(ComponentEvent e) {
        this.revalidate();
        this.calculatePreferredSize();
    }

    @Override
    @Concealed
    public void componentResized(ComponentEvent e) {
        this.revalidate();
        this.calculatePreferredSize();
    }

    @Override
    @Concealed
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    @Concealed
    public void componentMoved(ComponentEvent e) {
    }

    void calculatePreferredSize() {
        int height;
        int width;
        if (this.getOrientation() == 0) {
            int scrollBarWidth = this.m_scrollPane.getVerticalScrollBar().getMinimumSize().width;
            if (this.isLabelVisible()) {
                width = this.m_label.getPreferredSize().width + this.m_scrollPane.getViewport().getPreferredSize().width + scrollBarWidth + 5 + 5;
                height = Math.max(this.m_scrollPane.getViewport().getPreferredSize().height, this.m_label.getPreferredSize().height) + 5 + 5 + 4;
            } else {
                width = this.m_scrollPane.getViewport().getPreferredSize().width + scrollBarWidth + 5 + 5;
                height = this.m_scrollPane.getViewport().getPreferredSize().height + 5 + 5 + 4;
            }
        } else {
            int scrollBarHeight = this.m_scrollPane.getHorizontalScrollBar().getMinimumSize().width;
            if (this.isLabelVisible()) {
                width = Math.max(this.m_scrollPane.getViewport().getPreferredSize().width, this.m_label.getPreferredSize().width) + 5 + 5;
                height = this.m_scrollPane.getViewport().getPreferredSize().height + this.m_label.getPreferredSize().height + scrollBarHeight + 5 + 5;
            } else {
                width = this.m_scrollPane.getViewport().getPreferredSize().width + 5 + 5;
                height = this.m_scrollPane.getViewport().getPreferredSize().height + scrollBarHeight + 5 + 5;
            }
        }
        this._prefSize = new Dimension(width, height);
        this.m_scrollPane.getViewport().setPreferredSize(this.m_pc.getPreferredScrollableViewportSize());
    }

    void setDragging(boolean dragging) {
        if (dragging != this.isDragging()) {
            this._dragging = dragging;
        }
    }

    boolean isDragging() {
        return this._dragging;
    }

    BufferedImage getDragImage() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != 0 && height != 0) {
            BufferedImage _imgGhost = new BufferedImage(width, height, 3);
            Graphics2D g2 = _imgGhost.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            this.paint(g2);
            g2.dispose();
            return _imgGhost;
        }
        return null;
    }

    protected JLabel getLabel() {
        return this.m_label;
    }

    @Concealed
    public PagingComponent getPagingComponent() {
        return this.m_pc;
    }

    @Concealed
    public void updateCurrentPage() {
        if (this.m_pagingControlModel.getDataAccess() == null) {
            return;
        }
        DataAccess da = this.m_pagingControlModel.getDataAccess();
        if (da == null) {
            return;
        }
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            pc.updateCurrentPage();
        }
        this.calculatePreferredSize();
    }

    @Concealed
    public void updatePageItems() {
        if (this.m_pagingControlModel == null) {
            return;
        }
        DataAccess da = this.m_pagingControlModel.getDataAccess();
        if (da == null) {
            return;
        }
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            this._previousItemCount = pc.getComponentCount();
            this.removePageItemListeners();
            this.getPagingComponent().newPageItems();
            this.addPageItemListeners();
        }
        this.updatePageItemStyles();
        this.calculatePreferredSize();
    }

    @Concealed
    private void addPageItemListeners() {
        for (int i = 0; i < this.m_pc.getComponentCount(); ++i) {
            this.addPIM((PageItem)((Object)this.m_pc.getComponent(i)));
        }
    }

    @Concealed
    private void removePageItemListeners() {
        for (int i = 0; i < this.m_pc.getComponentCount(); ++i) {
            this.removePIM((PageItem)((Object)this.m_pc.getComponent(i)));
        }
    }

    private void addPIM(PageItem pi) {
        pi.addMouseListener(this);
        pi.addMouseMotionListener(this);
        pi.addFocusListener(this);
        pi.getComponent(0).addMouseListener(this);
        pi.getComponent(0).addMouseMotionListener(this);
        pi.getComponent(1).addMouseListener(this);
        pi.getComponent(1).addMouseMotionListener(this);
    }

    private void removePIM(PageItem pi) {
        pi.removeMouseListener(this);
        pi.removeMouseMotionListener(this);
        pi.addFocusListener(this);
        pi.getComponent(0).removeMouseListener(this);
        pi.getComponent(0).removeMouseMotionListener(this);
        pi.getComponent(1).removeMouseListener(this);
        pi.getComponent(1).removeMouseMotionListener(this);
    }

    @Override
    @Concealed
    public void mouseDragged(MouseEvent e) {
        this.processMouseMotionEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void mouseMoved(MouseEvent e) {
        this.processMouseMotionEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(this.convertMouseEvent(e));
        if (e.getSource() instanceof JComponent && ((JComponent)e.getSource()).getParent() instanceof PageItem && SwingUtilities.isRightMouseButton(e)) {
            this.getPagingComponent().setSelectedItem((PageItem)((Object)((JComponent)e.getSource()).getParent()));
        }
    }

    @Override
    @Concealed
    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void mouseEntered(MouseEvent e) {
        this.processMouseEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void mouseExited(MouseEvent e) {
        this.processMouseEvent(this.convertMouseEvent(e));
    }

    @Override
    @Concealed
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            int index = this.m_pc.getIndex((PageItem)e.getSource());
            int count = this.m_pc.getComponentCount();
            this._previousItemCount = this.getPreviousItemCount();
            if (index == -1) {
                PageItem pi = null;
                if (count > 0) {
                    if (this._previousPageItemIndex > count - 1) {
                        this._previousPageItemIndex = count - 1;
                        pi = (PageItem)this.m_pc.getItem(this._previousPageItemIndex);
                    } else if (count == this._previousItemCount) {
                        if (this._previousPageItemIndex != -1) {
                            pi = (PageItem)this.m_pc.getItem(this._previousPageItemIndex);
                        }
                    } else {
                        --this._previousPageItemIndex;
                        if (this._previousPageItemIndex < 0) {
                            this._previousPageItemIndex = 0;
                        }
                        pi = (PageItem)this.m_pc.getItem(this._previousPageItemIndex);
                    }
                    if (pi != null) {
                        pi.requestFocus();
                    }
                    return;
                }
            } else {
                this._previousPageItemIndex = index;
            }
        }
        this.processFocusEvent(e);
    }

    @Override
    @Concealed
    public void focusLost(FocusEvent e) {
        this.processFocusEvent(e);
    }

    @Concealed
    protected MouseEvent convertMouseEvent(MouseEvent e) {
        if (e.getSource() instanceof JComponent && ((JComponent)e.getSource()).getParent() instanceof PageItem) {
            return this.createPageItemMouseEvent(e);
        }
        return this.createPageControlMouseEvent(e);
    }

    @Concealed
    protected MouseEvent createPageItemMouseEvent(MouseEvent e) {
        return new MouseEvent(((JComponent)e.getSource()).getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
    }

    @Concealed
    protected MouseEvent createPageControlMouseEvent(MouseEvent e) {
        return new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
    }

    @Concealed
    int getPreviousItemCount() {
        return this._previousItemCount;
    }

    @Concealed
    int getPreviousPageItemIndex() {
        return this._previousPageItemIndex;
    }

    @Concealed
    public void setPreviousPageItemIndex(int index) {
        this._previousPageItemIndex = index;
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public String getComponentName() {
        return "PageHeader";
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    @Concealed
    public int getEdge() {
        return 2;
    }

    @Override
    @Concealed
    public final ViewPagingControl getPagingControl() {
        return null;
    }

    @Override
    @Concealed
    public final void setPagingControlPosition(int loc) {
    }

    @Override
    @Concealed
    public final int getPagingControlPosition() {
        return -1;
    }

    @Override
    @Concealed
    protected final void positionPagingControl(int location) {
    }

    @Override
    @Concealed
    public final DataviewTitles getDataviewTitle() {
        return null;
    }

    @Override
    @Concealed
    public final DataviewTitles getDataviewSubtitle() {
        return null;
    }

    @Override
    @Concealed
    public final DataviewTitles getDataviewFootnote() {
        return null;
    }

    @Override
    @Concealed
    protected final void createTitles() {
    }

    @Override
    @Concealed
    public String getVersion() {
        return "4.0.0.0";
    }

    @Override
    @Concealed
    public String getIntlString(String key) {
        return this.m_commonPagingControl.getIntlString(key);
    }

    @Override
    @Concealed
    protected DataviewXML getViewXML() {
        return this.m_commonPagingControl.getViewXML();
    }

    @Override
    public int getPresentationHeight() {
        return this.getBounds().height;
    }

    @Override
    public int getPresentationWidth() {
        return this.getBounds().width;
    }

    @Override
    @Concealed
    public boolean isDrillingSupported() {
        return this.m_commonPagingControl.isDrillingSupported();
    }

    @Override
    @Concealed
    public boolean isPrintOrPreviewMode() {
        return this.m_printOrPreviewMode;
    }

    @Override
    public int getViewType() {
        return 4;
    }

    @Override
    @Concealed
    public Object getComponentFromID(int ID) {
        switch (ID) {
            case 3: 
            case 4: {
                return this.getPagingComponent();
            }
            case 5: {
                return this;
            }
        }
        return null;
    }

    @Override
    @Concealed
    protected String getNameFromID(int ID) {
        switch (ID) {
            case 3: {
                return "PageHeader";
            }
            case 4: {
                return "PageItem";
            }
        }
        return null;
    }

    @Override
    @Concealed
    protected void setDataUnformattedSupported(boolean supported) {
        super.setDataUnformattedSupported(supported);
    }

    @Override
    @Concealed
    protected void setMetadataLongLabelSupported(boolean supported) {
        super.setMetadataLongLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setMetadataMediumLabelSupported(boolean supported) {
        super.setMetadataMediumLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setMetadataShortLabelSupported(boolean supported) {
        super.setMetadataShortLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setMetadataValueSupported(boolean supported) {
        super.setMetadataValueSupported(supported);
    }

    @Override
    @Concealed
    protected void setLayerMetaLongLabelSupported(boolean supported) {
        super.setLayerMetaLongLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setLayerMetaMediumLabelSupported(boolean supported) {
        super.setLayerMetaMediumLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setLayerMetaShortLabelSupported(boolean supported) {
        super.setLayerMetaShortLabelSupported(supported);
    }

    @Override
    @Concealed
    protected void setLayerMetaNameSupported(boolean supported) {
        super.setLayerMetaNameSupported(supported);
    }

    @Override
    @Concealed
    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        this.boundSupport.firePropertyChange(propName, oldValue, newValue);
    }

    @Override
    public boolean selectObject(ComponentHandle id) {
        this.getPagingControlController().setSelectedObject(id);
        return true;
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.getPagingControlController().getSelectedObject();
    }

    @Override
    @Concealed
    public void updatePagingControlStyles() {
        this.updatePageItemStyles();
    }

    @Override
    @Concealed
    public void metadataStyleChanged() {
        this.updatePagingControlStyles();
    }

    @Override
    @Concealed
    protected void metadataLabelTypeChanged() {
        super.metadataLabelTypeChanged();
        this.updatePageItems();
        this.repaint();
    }

    @Override
    @Concealed
    protected void refreshData() {
        int pageIndex = this.getPreviousPageItemIndex();
        if (pageIndex != -1 && this.getPagingComponent().isPageItemSelected()) {
            this.getPagingComponent().getItem(pageIndex).requestFocus();
            this.getPagingComponent().setPageItemSelected(false);
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    @Concealed
    public void initialize(Hashtable env) {
        this.m_commonPagingControl.initialize(env);
    }

    @Override
    @Concealed
    protected void setContext() {
        this.m_commonPagingControl.setContext();
    }

    @Override
    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        HashMap map = new HashMap();
        this.m_commonPagingControl.setXML(xml, map);
        this.applyXMLPropsOnPC(map);
        return true;
    }

    private void applyXMLPropsOnPC(HashMap map) {
        HashMap pcHashMap = (HashMap)map.get("PageHeader");
        for (String key : pcHashMap.keySet()) {
            if (key.equals("labelVisible")) {
                Boolean labelVisible = (Boolean)pcHashMap.get(key);
                this.setLabelVisible(labelVisible);
                continue;
            }
            if (key.equals("orientation")) {
                String orientation = (String)pcHashMap.get(key);
                if (orientation.equals("VERTICAL")) {
                    this.setOrientation(1);
                    continue;
                }
                this.setOrientation(0);
                continue;
            }
            if (key.equals("dragEnabled")) {
                Boolean dragEnabled = (Boolean)pcHashMap.get(key);
                this.setDragEnabled(dragEnabled);
                continue;
            }
            if (key.equals("visible")) {
                Boolean visible = (Boolean)pcHashMap.get(key);
                this.setVisible(visible);
                continue;
            }
            if (key.equals("enabled")) {
                Boolean enabled = (Boolean)pcHashMap.get(key);
                this.setEnabled(enabled);
                continue;
            }
            if (key.equals("swapAllowed")) {
                Boolean swapAllowed = (Boolean)pcHashMap.get(key);
                this.setSwapAllowed(swapAllowed);
                continue;
            }
            if (!key.equals("ViewStyle")) continue;
            ObjectNode node = (ObjectNode)pcHashMap.get(key);
            this.getViewStyle().setXML(node, this.getVersion(), 0);
        }
    }

    @Override
    @Concealed
    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        return this.m_commonPagingControl.getPersistableAttributes(oldAttrs);
    }

    @Override
    public void setPersistableComponents(AggregateInfo[] persistables) {
        this.m_commonPagingControl.setPersistableComponents(persistables);
    }

    @Override
    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        HashMap map = new HashMap();
        this.m_commonPagingControl.readXML(stream, reset, map);
        this.applyXMLPropsOnPC(map);
        return true;
    }

    @Override
    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        return this.m_commonPagingControl.setXML(xmlString, reset);
    }

    @Override
    protected void resetToDefault(int reset, String version) {
        if (reset < 0 || reset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        if (reset == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        ((PagingControlXML)this.m_commonPagingControl.getViewXML()).resetPagingControlXML(reset);
        this.removeListeners(reset);
        if (reset == 4 || reset == 2 || reset == 5) {
            this.setPagingControlModel(new PagingControlModelAdapter(this));
            this.removeErrorHandler();
            this.setDataSource(new LocalDataSource());
            this.setPagingControlController(new PagingControlControllerAdapter(this, this._embedded));
        } else if (reset == 3 || reset == 1) {
            this.getPagingControlController().setSelectedObject(null);
        }
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            pc.resetToDefault(reset);
        } else {
            this.getViewStyle().resetToDefault(reset);
        }
        this.setSwapAllowed(PagingControlDefaultValues.isSwapAllowed());
    }

    @Override
    @Concealed
    public void setObjectNode(ObjectNode node, String version, int reset) {
        this.m_commonPagingControl.setObjectNode(node, version, reset);
    }

    @Override
    @Concealed
    public ObjectNode getObjectNode(boolean allProperties) {
        return this.m_commonPagingControl.getObjectNode(allProperties);
    }

    @Override
    public void setViewStyle(ViewStyle vs) {
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            pc.setViewStyle(vs);
        } else {
            this._viewStyle = (ViewStyle)vs.clone();
            this._viewStyle.setView(this.getFormatProvider());
        }
    }

    @Override
    public ViewStyle getViewStyle() {
        ViewStyle ret = null;
        PagingComponent pc = this.getPagingComponent();
        if (pc != null) {
            ret = pc.getViewStyle();
        } else {
            if (this._viewStyle == null) {
                this._viewStyle = new ViewStyle();
                this._viewStyle.setView(this.getFormatProvider());
            }
            ret = this._viewStyle;
        }
        return ret;
    }

    @Concealed
    public void updatePageItemStyles() {
        int edge = 2;
        PagingComponent pc = this.getPagingComponent();
        int pageSlice = -1;
        try {
            pageSlice = this.m_pagingControlModel.getDataAccess().getEdgeCurrentSlice(2);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("edge out of range when getting current page slice", this.getClass().getName(), "updatePageItemStyles()");
        }
        for (int depth = 0; depth < pc.getComponentCount(); ++depth) {
            PageItem pi = (PageItem)pc.getItem(depth);
            ViewStyle vs = this.getPagingControlStyleManager().getMetadataStyle(this, pi.getSelectedValue(), this.getViewStyle(), depth, pageSlice);
            if (vs == null) {
                vs = (ViewStyle)this.getViewStyle().clone();
            }
            if (this.getZoomFactor() != 100) {
                vs = vs.scaleStyle(vs.getFont());
                vs.setView(this.getFormatProvider());
            } else {
                vs.setView(this.getFormatProvider());
            }
            pi.setAppearance(vs);
        }
    }
}

