/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LabelPosition;
import oracle.dss.legend.shared.LegendItem;
import oracle.dss.legend.shared.marker.LegendMarker;
import oracle.dss.legend.shared.text.ListLabelText;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Stroke;

public class LegendListItem
extends LegendItem
implements Comparable<LegendListItem> {
    private LegendMarker m_marker = null;
    private ListLabelText m_label = null;
    private String m_attributeGroupId = null;
    private String m_hideAttrs = null;
    protected LabelPosition m_labelPosition = LabelPosition.END;
    protected int m_minGap = 3;
    private static final int DEFAULT_FIXED_ORDER = Integer.MIN_VALUE;
    private int m_fixedOrder = Integer.MIN_VALUE;
    private String clientId = "";

    public LegendListItem(ListLabelText label) {
        this.m_label = label;
    }

    public LegendListItem(LegendMarker marker, ListLabelText label) {
        this.m_marker = marker;
        this.m_label = label;
    }

    @Override
    public void internalAccept(LegendVisitor visitor, LegendVisitContext context) {
        if (this.m_marker != null) {
            this.m_marker.accept(visitor, context);
        }
        if (this.m_label != null) {
            this.m_label.accept(visitor, context);
        }
        visitor.visit(this, context);
    }

    public void setAttributeGroupId(String attrGroupId) {
        this.m_attributeGroupId = attrGroupId;
    }

    public String getAttributeGroupId() {
        return this.m_attributeGroupId;
    }

    public LegendMarker getMarker() {
        return this.m_marker;
    }

    public ListLabelText getLabel() {
        return this.m_label;
    }

    @Override
    public void calc() {
        if (this.m_marker == null && this.m_label == null) {
            return;
        }
        int markerSize = 0;
        if (this.m_marker != null) {
            markerSize = this.m_settings.getStyles().getMarkerSize();
            this.m_marker.setWidth(markerSize);
            this.m_marker.setHeight(markerSize);
            this.m_marker.calc();
        }
        int spacing = 0;
        if (this.m_marker != null) {
            spacing = this.m_minGap;
        }
        if (this.m_label != null) {
            this.m_label.setWidth(this.m_width - markerSize - spacing);
            this.m_label.calc();
        }
        this.m_width = Math.min(this.getMarkerWidth() + spacing + this.getLabelWidth(), this.m_width);
        this.m_height = Math.max(this.getMarkerHeight(), this.getLabelHeight());
    }

    protected int getMarkerWidth() {
        return this.m_marker == null ? 0 : this.m_marker.getWidth();
    }

    protected int getMarkerHeight() {
        return this.m_marker == null ? 0 : this.m_marker.getHeight();
    }

    protected int getLabelWidth() {
        return this.m_label == null ? 0 : this.m_label.getWidth();
    }

    protected int getLabelHeight() {
        return this.m_label == null ? 0 : this.m_label.getHeight();
    }

    @Override
    public void calcFinal() {
        if (this.m_marker == null && this.m_label == null) {
            return;
        }
        if (this.m_label != null) {
            this.m_label.setHeight(this.m_height);
            this.m_label.setWidth(this.m_width - this.getMarkerWidth() - 2 * this.m_minGap);
            this.m_label.calcFinal();
        }
        this.m_height = Math.max(this.getMarkerHeight(), this.getLabelHeight());
    }

    @Override
    public List<DrawableObject> render() {
        LegendItem top = null;
        LegendItem bottom = null;
        LegendItem left = null;
        LegendItem right = null;
        LabelPosition labelPosition = this.getLabelPosition();
        if (labelPosition == LabelPosition.TOP) {
            top = this.m_label;
            bottom = this.m_marker;
        } else if (labelPosition == LabelPosition.BOTTOM) {
            top = this.m_marker;
            bottom = this.m_label;
        } else if (labelPosition == LabelPosition.LEFT) {
            left = this.m_label;
            right = this.m_marker;
        } else {
            left = this.m_marker;
            right = this.m_label;
        }
        int topHeight = 0;
        if (top != null) {
            top.setPosition(this.m_x, this.m_y);
            topHeight = top.getHeight();
        }
        if (bottom != null) {
            int spacing = 0;
            if (left != null) {
                spacing = this.m_minGap;
            }
            bottom.setPosition(this.m_x, this.m_y + topHeight + spacing);
        }
        int leftWidth = 0;
        if (left != null) {
            left.setPosition(this.m_x, this.m_y);
            leftWidth = left.getWidth();
        }
        if (right != null) {
            int spacing = 0;
            if (left != null) {
                spacing = this.m_minGap;
            }
            right.setPosition(this.m_x + leftWidth + spacing, this.m_y);
        }
        if (this.m_label != null && this.m_label.getHeight() < this.m_height) {
            int labelY = this.m_label.getY() - this.m_label.getHeight() / 2 + this.m_height / 2;
            this.m_label.setPosition(this.m_label.getX(), labelY);
        }
        if (this.m_marker != null && this.m_marker.getHeight() < this.m_height) {
            int markerY = this.m_marker.getY() - this.m_marker.getHeight() / 2 + this.m_height / 2;
            this.m_marker.setPosition(this.m_marker.getX(), markerY);
        }
        ArrayList<DrawableObject> listItem = new ArrayList<DrawableObject>();
        if (this.m_marker != null) {
            listItem.addAll(this.m_marker.render());
        }
        if (this.m_label != null) {
            listItem.addAll(this.m_label.render());
        }
        return listItem;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.m_labelPosition = labelPosition;
    }

    public LabelPosition getLabelPosition() {
        boolean isBidi = this.m_settings.isBidi();
        LabelPosition labelPosition = this.m_labelPosition;
        if (this.m_labelPosition == LabelPosition.START) {
            labelPosition = isBidi ? LabelPosition.RIGHT : LabelPosition.LEFT;
        } else if (this.m_labelPosition == LabelPosition.END) {
            labelPosition = isBidi ? LabelPosition.LEFT : LabelPosition.RIGHT;
        }
        return labelPosition;
    }

    @Override
    public Fill getDefaultFill() {
        return new FillColor(this.m_settings.getStyles().getBackgroundColor());
    }

    @Override
    public Stroke getDefaultBorder() {
        return null;
    }

    @Override
    public int compareTo(LegendListItem listItem) {
        if (this.m_fixedOrder == Integer.MIN_VALUE && listItem.getFixedOrder() == Integer.MIN_VALUE) {
            return 0;
        }
        if (this.m_fixedOrder == Integer.MIN_VALUE && listItem.getFixedOrder() != Integer.MIN_VALUE) {
            return 1;
        }
        if (this.m_fixedOrder != Integer.MIN_VALUE && listItem.getFixedOrder() == Integer.MIN_VALUE) {
            return -1;
        }
        if (this.m_fixedOrder != Integer.MIN_VALUE && listItem.getFixedOrder() != Integer.MIN_VALUE) {
            if (this.m_fixedOrder > listItem.getFixedOrder()) {
                return 1;
            }
            if (this.m_fixedOrder == listItem.getFixedOrder()) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public void setFixedOrder(int fixedOrder) {
        this.m_fixedOrder = fixedOrder;
    }

    public int getFixedOrder() {
        return this.m_fixedOrder;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setHideAttributes(String hideAttrs) {
        this.m_hideAttrs = hideAttrs;
    }

    public String getHideAttributes() {
        return this.m_hideAttrs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LegendListItem)) {
            return false;
        }
        LegendListItem other = (LegendListItem)object;
        if (!(this.m_marker != null ? this.m_marker.equals(other.m_marker) : other.m_marker == null)) {
            return false;
        }
        return this.m_label != null ? this.m_label.equals(other.m_label) : other.m_label == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.m_marker == null ? 0 : this.m_marker.hashCode());
        result = 37 * result + (this.m_label == null ? 0 : this.m_label.hashCode());
        return result;
    }
}

