/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public abstract class BaseBorderLine
extends BaseGraphComponent {
    @Concealed
    public BaseBorderLine(CommonGraph graph) {
        super(graph);
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setLineColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, width);
        }
    }

    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_identObj);
    }

    public void setLineStyle(int style) {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_identObj, style);
        }
    }

    @Concealed
    protected void resetStyle() {
        this.setLineColor(Color.black);
        this.setLineWidth(2);
        this.setLineStyle(0);
        this.setVisible(false);
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (this.isVisibleInXML() && val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLineWidthObj(this.m_identObj)) != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.getLineColor()) != null) {
            node.addProperty("lineColor", BaseBorderLine.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLineStyleObj(this.m_identObj)) != null) {
            node.addProperty("lineStyle", BaseBorderLine.convertLineStyleToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("lineWidth")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setLineWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("lineStyle")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineStyle", new Integer(BaseBorderLine.convertLineStyleToInt(pNode.getValueAsString())));
            } else {
                this.setLineStyle(BaseBorderLine.convertLineStyleToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("lineColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineColor", new Color(BaseBorderLine.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setLineColor(new Color(BaseBorderLine.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
    }

    boolean isVisibleInXML() {
        return true;
    }
}

