/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Font;
import java.beans.Beans;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dss.dataView.AttributeFormatter;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewConstants;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ThickDataview;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectWriter;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class CommonDataview
implements DataviewCommon,
DataviewConstants,
DataviewAttributes {
    @Concealed
    protected FontList fontList = new FontList();
    @Concealed
    protected transient ErrorHandler m_eh = null;
    private DataAccess m_dataAccess;
    private DataDirector m_dataDirector;
    @Concealed
    protected ThickDataview m_thickView;
    @Concealed
    protected DataviewXML m_viewXML;
    @Concealed
    protected String[] m_memberMetadataLabelTypes = null;
    @Concealed
    protected String[] m_layerMetadataLabelTypes = null;
    @Concealed
    protected WaitData[] m_waitDataForRows = null;
    @Concealed
    protected boolean m_dataUnformattedSupported = true;
    @Concealed
    protected boolean m_metaDateSupported = false;
    @Concealed
    protected boolean m_metaLonglabelSupported = true;
    @Concealed
    protected boolean m_metaMediumlabelSupported = false;
    @Concealed
    protected boolean m_metaShortlabelSupported = false;
    @Concealed
    protected boolean m_metaViewStyleSupported = false;
    @Concealed
    protected boolean m_metaValueSupported = true;
    @Concealed
    protected boolean m_layermetaShortlabelSupported = false;
    @Concealed
    protected boolean m_layermetaMediumlabelSupported = false;
    @Concealed
    protected boolean m_layermetaLonglabelSupported = true;
    @Concealed
    protected boolean m_layermetaNameSupported = false;
    @Concealed
    protected boolean m_layermetaViewStyleSupported = false;
    @Concealed
    protected transient PersistableAttributes m_attrs = null;
    protected ResourceBundle m_dvStrings = null;
    private boolean _userOverrideMode = false;
    private boolean _styleOverrideMode = false;
    private boolean _styleModified = false;
    private Model m_model = null;
    private Locale m_locale;
    @CodeSharingSafe(value="StaticField")
    private static ResourceBundle s_resourceBundle;
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Locale, ResourceBundle> s_resourceBundleMap;
    @Concealed
    protected boolean m_htmlPagingControlAutosubmit = DataviewDefaultValues.isHTMLPagingControlAutosubmit();
    @Concealed
    protected int m_htmlPagingControlWidth = DataviewDefaultValues.getHTMLPagingControlWidth();
    @Concealed
    protected String m_name = DataviewDefaultValues.getName();
    @Concealed
    protected String m_localName = DataviewDefaultValues.getLocalName();
    @Concealed
    protected String m_description = DataviewDefaultValues.getDescription();
    @Concealed
    protected int m_pagingControlPosition = DataviewDefaultValues.getPagingControlPosition();
    @Concealed
    protected boolean m_pagingVisible = false;
    @Concealed
    protected boolean m_validate = false;
    private boolean m_drillingEnabled = false;
    private TokenSubstitution m_tokenSubstitution;
    private AttributeFormatter m_attributeFormatter = new DefaultAttributeFormatter();
    private Map<Object, Object> m_context;
    @Concealed
    public static final String a_animationOnDataChange = "animationOnDataChange";
    @Concealed
    public static final String a_animationIndicators = "animationIndicators";
    @Concealed
    public static final String a_animationUpColor = "animationUpColor";
    @Concealed
    public static final String a_animationDownColor = "animationDownColor";
    @Concealed
    public static final String a_animationDuration = "animationDuration";
    @Concealed
    public static final String a_animationOnDisplay = "animationOnDisplay";
    @Concealed
    public static final String a_visualEffects = "visualEffects";
    @Concealed
    public static final String a_interactiveSliceBehavior = "interactiveSliceBehavior";
    @Concealed
    public static final String adc_none = "none";
    @Concealed
    public static final String adc_auto = "activeData";
    @Concealed
    public static final String adc_on = "auto";
    @Concealed
    public static final String adc_alpha_fade = "alphaFade";
    @Concealed
    public static final String adc_conveyor_from_right = "conveyorFromRight";
    @Concealed
    public static final String adc_conveyor_from_left = "conveyorFromLeft";
    @Concealed
    public static final String adc_cube_to_right = "cubeToRight";
    @Concealed
    public static final String adc_cube_to_left = "cubeToLeft";
    @Concealed
    public static final String adc_flip_right = "flipRight";
    @Concealed
    public static final String adc_flip_left = "flipLeft";
    @Concealed
    public static final String adc_slide_to_right = "slideToRight";
    @Concealed
    public static final String adc_slide_to_left = "slideToLeft";
    @Concealed
    public static final String adc_transition_to_right = "transitionToRight";
    @Concealed
    public static final String adc_transition_to_left = "transitionToLeft";
    @Concealed
    public static final String adc_zoom = "zoom";
    @Concealed
    public static final String ai_none = "NONE";
    @Concealed
    public static final String ai_all = "ALL";
    @Concealed
    public static final String ad_none = "none";
    @Concealed
    public static final String ad_auto = "auto";
    @Concealed
    public static final String ad_alpha_fade = "alphaFade";
    @Concealed
    public static final String ad_conveyor_from_right = "conveyorFromRight";
    @Concealed
    public static final String ad_conveyor_from_left = "conveyorFromLeft";
    @Concealed
    public static final String ad_cube_to_right = "cubeToRight";
    @Concealed
    public static final String ad_cube_to_left = "cubeToLeft";
    @Concealed
    public static final String ad_flip_right = "flipRight";
    @Concealed
    public static final String ad_flip_left = "flipLeft";
    @Concealed
    public static final String ad_slide_to_right = "slideToRight";
    @Concealed
    public static final String ad_slide_to_left = "slideToLeft";
    @Concealed
    public static final String ad_transition_to_right = "transitionToRight";
    @Concealed
    public static final String ad_transition_to_left = "transitionToLeft";
    @Concealed
    public static final String ad_zoom = "zoom";
    @Concealed
    public static final String ve_none = "NONE";
    @Concealed
    public static final String ve_auto = "AUTO";
    @Concealed
    public static final String ve_shadow = "SHADOW";
    @Concealed
    public static final String ve_glow = "GLOW";
    @Concealed
    public static final String ve_bevel = "BEVEL";
    @Concealed
    public static final String a_none = "none";
    @Concealed
    public static final String a_all = "all";
    @Concealed
    public static final String a_auto = "auto";
    @Concealed
    public static final String a_on = "on";
    @Concealed
    public static final String a_off = "off";
    @Concealed
    protected static final String m_method_setName = "setName(String n)";
    @Concealed
    protected static final String m_method_setLocalName = "setLocalName(String n)";
    @Concealed
    protected static final String m_method_setDescription = "setDescription(String n)";
    private static final String m_method_setMemberMetadataLabelType = "public void setMemberMetadataLabelType(int edge, String type)";
    private static final String m_method_getMemberMetadataLabelType = "public String getMemberMetadataLabelType(int edge)";
    private static final String m_method_setMemberMetadataLabelType_all = "public void setMemberMetadataLabelType(String type)";
    private static final String m_method_setLayerMetadataLabelType = "public void setLayerMetadataLabelType(int edge, String type)";
    private static final String m_method_getLayerMetadataLabelType = "public String getLayerMetadataLabelType(int edge)";
    private static final String m_method_setLayerMetadataLabelType_all = "public void setLayerMetadataLabelType(String type)";
    private static final String m_method_setGridData = "public void setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data)";
    private static final String m_method_setTabularData = "setTabularData(List tableRows)";
    @Concealed
    protected static final String m_method_fillRelationalDataArrays = "protected void fillRelationalDataArrays(int colCount, int rowCount, List colLabelsList, List rowLabelsList, Hashtable dataVals, Object[] colLabels, Object[] rowLabels, Object[][] data)";

    public CommonDataview(Locale loc) {
        this.setLocale(loc);
        DefaultErrorHandler handler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            handler.setDebugMode(6);
        }
        this.addErrorHandler((ErrorHandler)handler);
        this.m_memberMetadataLabelTypes = new String[3];
        this.m_layerMetadataLabelTypes = new String[3];
        for (int edge = 0; edge < 3; ++edge) {
            this.m_memberMetadataLabelTypes[edge] = DataviewDefaultValues.getMemberMetadataLabelType(edge);
            this.m_layerMetadataLabelTypes[edge] = DataviewDefaultValues.getLayerMetadataLabelType(edge);
        }
        this.updateResourceBundle();
    }

    public CommonDataview(Locale loc, ErrorHandler handler) {
        this(loc);
        if (handler != null) {
            this.addErrorHandler(handler);
        }
    }

    public void addErrorHandler(ErrorHandler eh) {
        if (eh != null) {
            this.m_eh = eh;
            if (this.getModel() != null) {
                this.getModel().setErrorHandler(eh);
            }
        }
    }

    public void removeErrorHandler() {
        DefaultErrorHandler handler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            handler.setDebugMode(6);
        }
        this.addErrorHandler((ErrorHandler)handler);
    }

    @Override
    @Concealed
    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    @Override
    @Concealed
    public FontList getFontList() {
        return this.fontList;
    }

    @Override
    @Concealed
    public int getZoomFactor() {
        return 100;
    }

    @Concealed
    public String getVersion() {
        if (this.m_thickView != null) {
            return this.m_thickView.getVersion();
        }
        return null;
    }

    @Override
    @Concealed
    public Font scaleFont(Font f, int zoomFactor) {
        if (zoomFactor == 100) {
            return f;
        }
        int newSize = DataviewUtils.scaleByZoom(f.getSize(), zoomFactor);
        return this.fontList.getFont(f.getName(), f.getStyle(), newSize);
    }

    @Override
    @Concealed
    public String getIntlString(String key) {
        return this.getIntlString(key, this.m_dvStrings);
    }

    @Override
    @Concealed
    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + rBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            return key;
        }
        return strTemp;
    }

    @Concealed
    public void setThickDataview(ThickDataview view) {
        this.m_thickView = view;
    }

    @Concealed
    public ThickDataview getThickDataview() {
        return this.m_thickView;
    }

    @Concealed
    protected void updateResourceBundle() {
        try {
            this.m_dvStrings = CommonDataview.getDataviewResourceBundle(this.getLocale());
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource bundle oracle.dss.dataView.resource.DataviewBundle", this.getClass().getName(), "updateResourceBundle()");
            this.m_dvStrings = null;
        }
    }

    protected static ResourceBundle getDataviewResourceBundle(Locale loc) throws MissingResourceException {
        ResourceBundle bundle;
        if (loc != null) {
            ResourceBundle old;
            bundle = s_resourceBundleMap.get(loc);
            if (bundle == null && (old = s_resourceBundleMap.putIfAbsent(loc, bundle = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", loc))) != null) {
                bundle = old;
            }
        } else {
            if (s_resourceBundle == null) {
                s_resourceBundle = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
            }
            bundle = s_resourceBundle;
        }
        return bundle;
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
    }

    @Override
    public Model getModel() {
        return this.m_model;
    }

    public void setModel(Model model) {
        this.m_model = model;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
    }

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregates = null;
        DataSource ds = this.getDataSource();
        if (ds != null && ds instanceof Persistable) {
            aggregates = new AggregateInfo[]{new AggregateInfo((Persistable)ds, 0)};
        }
        return aggregates;
    }

    @Concealed
    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            for (int i = 0; i < persistables.length; ++i) {
                Persistable aggregate = persistables[i].getPersistable();
                if (!(aggregate instanceof DataSource)) continue;
                this.setDataSource((DataSource)aggregate);
                break;
            }
        }
    }

    @Override
    public void setMemberMetadataLabelType(int edge, String type) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        this.m_memberMetadataLabelTypes[edge] = type;
    }

    @Override
    public String getMemberMetadataLabelType(int edge) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getMemberMetadataLabelType);
            return null;
        }
        return this.m_memberMetadataLabelTypes[edge];
    }

    @Override
    @Concealed
    public boolean isMemberMetadataLabelTypeSupported(String type) {
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            return false;
        }
        if (type.equals("shortName")) {
            return this.isMetadataShortLabelSupported();
        }
        if (type.equals("mediumName")) {
            return this.isMetadataMediumLabelSupported();
        }
        if (type.equals("label")) {
            return this.isMetadataLongLabelSupported();
        }
        if (type.equals("value")) {
            return this.isMetadataValueSupported();
        }
        return false;
    }

    public void setMemberMetadataLabelType(String type) {
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType_all);
            return;
        }
        for (int edge = 0; edge < this.m_memberMetadataLabelTypes.length; ++edge) {
            this.m_memberMetadataLabelTypes[edge] = type;
        }
    }

    public String getMemberMetadataLabelType() {
        String type = this.m_memberMetadataLabelTypes[0];
        for (int edge = 1; edge < this.m_memberMetadataLabelTypes.length; ++edge) {
            if (type.equals(this.m_memberMetadataLabelTypes[edge])) continue;
            return null;
        }
        return type;
    }

    public void setLayerMetadataLabelType(String type) {
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType_all);
            return;
        }
        for (int edge = 0; edge < this.m_layerMetadataLabelTypes.length; ++edge) {
            this.m_layerMetadataLabelTypes[edge] = type;
        }
    }

    @Override
    @Concealed
    public boolean isMetadataViewStyleSupported() {
        return this.m_metaViewStyleSupported;
    }

    @Concealed
    public void setMetadataViewStyleSupported(boolean supported) {
        this.m_metaViewStyleSupported = supported;
    }

    @Concealed
    public void setMetadataDateSupported(boolean supported) {
        this.m_metaDateSupported = supported;
    }

    @Concealed
    public boolean isMetadataDateSupported() {
        return this.m_metaDateSupported;
    }

    public String getLayerMetadataLabelType() {
        String type = this.m_layerMetadataLabelTypes[0];
        for (int edge = 1; edge < this.m_layerMetadataLabelTypes.length; ++edge) {
            if (type.equals(this.m_layerMetadataLabelTypes[edge])) continue;
            return null;
        }
        return type;
    }

    @Override
    public void setLayerMetadataLabelType(int edge, String type) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        this.m_layerMetadataLabelTypes[edge] = type;
    }

    @Override
    public String getLayerMetadataLabelType(int edge) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getLayerMetadataLabelType);
            return null;
        }
        return this.m_layerMetadataLabelTypes[edge];
    }

    @Concealed
    public void setMetadataLongLabelSupported(boolean supported) {
        this.m_metaLonglabelSupported = supported;
    }

    @Concealed
    public boolean isMetadataLongLabelSupported() {
        return this.m_metaLonglabelSupported;
    }

    @Concealed
    public void setMetadataMediumLabelSupported(boolean supported) {
        this.m_metaMediumlabelSupported = supported;
    }

    @Concealed
    public boolean isMetadataMediumLabelSupported() {
        return this.m_metaMediumlabelSupported;
    }

    @Concealed
    public void setMetadataShortLabelSupported(boolean supported) {
        this.m_metaShortlabelSupported = supported;
    }

    @Override
    @Concealed
    public boolean isMetadataShortLabelSupported() {
        return this.m_metaShortlabelSupported;
    }

    @Concealed
    public void setMetadataValueSupported(boolean supported) {
        this.m_metaValueSupported = supported;
    }

    @Concealed
    public boolean isMetadataValueSupported() {
        return this.m_metaValueSupported;
    }

    @Override
    @Concealed
    public boolean isLayerMetadataLabelTypeSupported(String type) {
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            return false;
        }
        if (type.equals("dimShortName")) {
            return this.isLayerMetaShortLabelSupported();
        }
        if (type.equals("dimMediumName")) {
            return this.isLayerMetaMediumLabelSupported();
        }
        if (type.equals("layerLabel")) {
            return this.isLayerMetaLongLabelSupported();
        }
        if (type.equals("layerName")) {
            return this.isLayerMetaNameSupported();
        }
        return false;
    }

    @Concealed
    public void setLayerMetaLongLabelSupported(boolean supported) {
        this.m_layermetaLonglabelSupported = supported;
    }

    @Concealed
    public boolean isLayerMetaLongLabelSupported() {
        return this.m_layermetaLonglabelSupported;
    }

    @Concealed
    public void setLayerMetaMediumLabelSupported(boolean supported) {
        this.m_layermetaMediumlabelSupported = supported;
    }

    @Concealed
    public boolean isLayerMetaMediumLabelSupported() {
        return this.m_layermetaMediumlabelSupported;
    }

    @Concealed
    public void setLayerMetaShortLabelSupported(boolean supported) {
        this.m_layermetaShortlabelSupported = supported;
    }

    @Override
    @Concealed
    public boolean isLayerMetaShortLabelSupported() {
        return this.m_layermetaShortlabelSupported;
    }

    @Concealed
    public void setLayerMetaNameSupported(boolean supported) {
        this.m_layermetaNameSupported = supported;
    }

    @Concealed
    public boolean isLayerMetaNameSupported() {
        return this.m_layermetaNameSupported;
    }

    @Concealed
    public void setLayerMetaViewStyleSupported(boolean supported) {
        this.m_layermetaViewStyleSupported = supported;
    }

    @Override
    @Concealed
    public boolean isLayerMetaViewStyleSupported() {
        return this.m_layermetaViewStyleSupported;
    }

    @Concealed
    public void setDataUnformattedSupported(boolean supported) {
        this.m_dataUnformattedSupported = supported;
    }

    @Override
    @Concealed
    public boolean isDataUnformattedSupported() {
        return this.m_dataUnformattedSupported;
    }

    @Override
    @Concealed
    public boolean isDataViewFormatSupported() {
        return false;
    }

    @Override
    @Concealed
    public void repaint() {
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.repaint();
        }
    }

    @Override
    public DataviewTitles getDataviewFootnote() {
        return null;
    }

    @Override
    public DataviewTitles getDataviewSubtitle() {
        return null;
    }

    @Override
    public DataviewTitles getDataviewTitle() {
        return null;
    }

    @Override
    @Concealed
    public void dataFormatChanged() {
    }

    @Override
    @Concealed
    public void metadataStyleChanged() {
    }

    @Override
    @Concealed
    public void dataStyleChanged() {
    }

    @Override
    @Concealed
    public void setWaitDataForRow(int row, WaitData waitData) {
        try {
            if (this.m_waitDataForRows == null) {
                this.m_waitDataForRows = new WaitData[this.getModel().getDataAccess().getEdgeExtent(1)];
            }
        }
        catch (EdgeOutOfRangeException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setWaitDataForRow");
            this.m_waitDataForRows = new WaitData[0];
        }
        if (row >= 0 && row < this.m_waitDataForRows.length) {
            this.m_waitDataForRows[row] = waitData;
        } else {
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "setWaitDataForRow");
        }
    }

    @Override
    @Concealed
    public WaitData getWaitDataForRow(int row) {
        if (this.m_waitDataForRows != null) {
            if (row >= 0 && row < this.m_waitDataForRows.length) {
                return this.m_waitDataForRows[row];
            }
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "getWaitDataForRow");
            return null;
        }
        return null;
    }

    protected WaitData[] getWaitData() {
        return this.m_waitDataForRows;
    }

    @Concealed
    public void clearWaitDataForAllRows() {
        if (this.m_waitDataForRows != null) {
            for (int i = 0; i < this.m_waitDataForRows.length; ++i) {
                this.m_waitDataForRows[i] = null;
            }
            this.m_waitDataForRows = null;
        }
    }

    @Concealed
    public DataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
    }

    @Concealed
    public DataDirector getDataDirector() {
        return this.m_dataDirector;
    }

    @Concealed
    public void setDataDirector(DataDirector dataDirector) {
        this.m_dataDirector = dataDirector;
    }

    @Concealed
    protected void setLocalXMLDataSource(LocalXMLDataSource ds) {
        this.setDataDirector((DataDirector)ds);
        this.setDataAccess((DataAccess)ds);
        this.setMetadataViewStyleSupported(true);
        this.setMetadataDateSupported(true);
        this.setMetadataMediumLabelSupported(true);
        this.setMetadataShortLabelSupported(true);
        this.setLayerMetaLongLabelSupported(true);
        this.setLayerMetaMediumLabelSupported(true);
        this.setLayerMetaShortLabelSupported(true);
    }

    @Concealed
    public boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        return this.setGridData(columnLabels, rowLabels, data, true);
    }

    @Concealed
    protected boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data, boolean bAllowNoData) {
        int col;
        if (columnLabels == null) {
            this.getErrorHandler().log("columnLabels array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            columnLabels = new String[]{};
        }
        if (rowLabels == null) {
            this.getErrorHandler().log("rowLabels array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            rowLabels = new String[]{};
        }
        if (data == null) {
            this.getErrorHandler().log("data array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            data = new Double[0][0];
        }
        int colCount = columnLabels.length;
        int rowCount = rowLabels.length;
        if (data.length != colCount) {
            this.getErrorHandler().log("data column count different from column label count", this.getClass().getName(), m_method_setGridData);
            return false;
        }
        for (col = 0; col < colCount; ++col) {
            if (data[col] == null || data[col].length == rowCount) continue;
            this.getErrorHandler().log("data row count different from row label count", this.getClass().getName(), m_method_setGridData);
            return false;
        }
        for (col = 0; col < colCount; ++col) {
            if (columnLabels[col] != null) continue;
            this.getErrorHandler().log("column label null at column " + col, this.getClass().getName(), m_method_setGridData);
        }
        for (int row = 0; row < rowCount; ++row) {
            if (rowLabels[row] != null) continue;
            this.getErrorHandler().log("row label null at row " + row, this.getClass().getName(), m_method_setGridData);
        }
        for (col = 0; col < colCount; ++col) {
            for (int row = 0; row < rowCount; ++row) {
                if (data[col] != null) continue;
                this.getErrorHandler().log("data cell null at column " + col + ", row " + row, this.getClass().getName(), m_method_setGridData);
            }
        }
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.setDataSource(new LocalXMLDataSource(columnLabels, rowLabels, data));
        } else {
            this.setLocalXMLDataSource(new LocalXMLDataSource(columnLabels, rowLabels, data));
        }
        return true;
    }

    public boolean setTabularData(List tableRows) {
        return this.setTabularData(tableRows, true);
    }

    @Concealed
    protected boolean setTabularData(List tableRows, boolean bAllowNoData) {
        if (tableRows == null) {
            this.getErrorHandler().log("tableRows list null", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
            tableRows = new ArrayList();
        }
        boolean COL = false;
        boolean ROW = true;
        int DATA = 2;
        int rowKeyCount = 0;
        int colKeyCount = 0;
        Hashtable<Object, Integer> rowKeys = new Hashtable<Object, Integer>();
        Hashtable<Object, Integer> colKeys = new Hashtable<Object, Integer>();
        Hashtable<String, Object> dataVals = new Hashtable<String, Object>();
        ArrayList<Object> rowLabelsList = new ArrayList<Object>();
        ArrayList<Object> colLabelsList = new ArrayList<Object>();
        boolean bNonNullRelRowExists = false;
        for (Object obj : tableRows) {
            Object rowLabel;
            Object colLabel;
            Object[] relRow = null;
            if (obj == null) {
                this.getErrorHandler().log("element of tableRows list null", this.getClass().getName(), m_method_setTabularData);
                continue;
            }
            if (!(obj instanceof Object[])) {
                this.getErrorHandler().log("element of tableRows list not Object[]", this.getClass().getName(), m_method_setTabularData);
                continue;
            }
            bNonNullRelRowExists = true;
            Object[] tmpRelRow = (Object[])obj;
            if (tmpRelRow.length < 3) {
                relRow = new Object[3];
                for (int i = 0; i < tmpRelRow.length; ++i) {
                    relRow[i] = tmpRelRow[i];
                }
            } else {
                relRow = tmpRelRow;
            }
            if ((colLabel = relRow[0]) == null) {
                this.getErrorHandler().log("null column label", this.getClass().getName(), m_method_setTabularData);
                colLabel = "";
            }
            if (!colKeys.containsKey(colLabel)) {
                colKeys.put(colLabel, new Integer(colKeyCount++));
                colLabelsList.add(colLabel);
            }
            if ((rowLabel = relRow[1]) == null) {
                this.getErrorHandler().log("null row label", this.getClass().getName(), m_method_setTabularData);
                rowLabel = "";
            }
            if (!rowKeys.containsKey(rowLabel)) {
                rowKeys.put(rowLabel, new Integer(rowKeyCount++));
                rowLabelsList.add(rowLabel);
            }
            String dataKey = rowLabel.toString() + ",";
            dataKey = colLabel instanceof Date ? dataKey + ((Date)colLabel).getTime() : dataKey + colLabel.toString();
            Object dataObj = relRow[2];
            if (dataVals.containsKey(dataKey)) {
                this.getErrorHandler().log("duplicate data at (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_setTabularData);
            }
            if (dataObj != null) {
                dataVals.put(dataKey, dataObj);
                continue;
            }
            dataVals.put(dataKey, NullObject.getNullObject());
        }
        if (!bNonNullRelRowExists) {
            this.getErrorHandler().log("all relational rows are null", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
        }
        if (rowKeyCount < 1 || colKeyCount < 1) {
            this.getErrorHandler().log("fewer than 1 column or 1 row of data provided", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
        }
        int rowCount = rowKeyCount;
        int colCount = colKeyCount;
        Object[] rowLabels = new Object[rowCount];
        Object[] colLabels = new Object[colCount];
        Object[][] data = new Object[colCount][rowCount];
        this.fillRelationalDataArrays(colCount, rowCount, colLabelsList, rowLabelsList, dataVals, colLabels, rowLabels, data);
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.setDataSource(new LocalXMLDataSource(colLabels, rowLabels, data));
        } else {
            this.setLocalXMLDataSource(new LocalXMLDataSource(colLabels, rowLabels, data));
        }
        return true;
    }

    @Concealed
    protected void fillRelationalDataArrays(int colCount, int rowCount, List colLabelsList, List rowLabelsList, Hashtable dataVals, Object[] colLabels, Object[] rowLabels, Object[][] data) {
        int row = 0;
        int col = 0;
        int rowLabelsListSize = rowLabelsList.size();
        for (int i = 0; i < rowLabelsListSize; ++i) {
            Object rowLabel = rowLabelsList.get(i);
            if (row < rowCount) {
                rowLabels[row] = rowLabel;
            } else {
                this.getErrorHandler().log("label for out of bounds row index " + row, this.getClass().getName(), m_method_fillRelationalDataArrays);
            }
            ++row;
        }
        while (row < rowCount) {
            this.getErrorHandler().log("missing label for row index " + row, this.getClass().getName(), m_method_fillRelationalDataArrays);
            rowLabels[row] = null;
            ++row;
        }
        int colLabelsListSize = colLabelsList.size();
        for (int j = 0; j < colLabelsListSize; ++j) {
            Object colLabel = colLabelsList.get(j);
            if (col < colCount) {
                colLabels[col] = colLabel;
            } else {
                this.getErrorHandler().log("label for out of bounds column index " + col, this.getClass().getName(), m_method_fillRelationalDataArrays);
            }
            ++col;
        }
        while (col < colCount) {
            this.getErrorHandler().log("missing label for column index " + col, this.getClass().getName(), m_method_fillRelationalDataArrays);
            colLabels[col] = null;
            ++col;
        }
        int totalCellCount = colCount * rowCount;
        int cellCount = 0;
        Object dataObj = null;
        boolean bLogTabularMissingDataWarning = this.isLogTabularMissingDataWarning();
        for (row = 0; row < rowCount; ++row) {
            Object rowLabel = rowLabels[row];
            if (rowLabel == null) {
                rowLabel = "";
            }
            for (col = 0; col < colCount; ++col) {
                Object colLabel = colLabels[col];
                if (colLabel == null) {
                    colLabel = "";
                }
                String dataKey = rowLabel.toString() + ",";
                dataKey = colLabel instanceof Date ? dataKey + ((Date)colLabel).getTime() : dataKey + colLabel.toString();
                dataObj = dataVals.remove(dataKey);
                if (dataObj != null) {
                    if (dataObj instanceof NullObject) {
                        dataObj = null;
                    } else {
                        ++cellCount;
                    }
                } else if (bLogTabularMissingDataWarning) {
                    this.getErrorHandler().log("missing data for cell at (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_fillRelationalDataArrays);
                }
                data[col][row] = dataObj;
            }
        }
        Enumeration dataKeysEnum = dataVals.keys();
        while (dataKeysEnum.hasMoreElements()) {
            String dataKey = (String)dataKeysEnum.nextElement();
            this.getErrorHandler().log("unused data for (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_fillRelationalDataArrays);
        }
    }

    protected boolean isLogTabularMissingDataWarning() {
        return true;
    }

    @Override
    public void setHTMLPagingControlAutosubmit(boolean autosubmit) {
        this.m_htmlPagingControlAutosubmit = autosubmit;
    }

    @Override
    public boolean isHTMLPagingControlAutosubmit() {
        return this.m_htmlPagingControlAutosubmit;
    }

    @Override
    public void setHTMLPagingControlWidth(int width) {
        this.m_htmlPagingControlWidth = width;
    }

    @Override
    public int getHTMLPagingControlWidth() {
        return this.m_htmlPagingControlWidth;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.getErrorHandler().log("invalid name", this.getClass().getName(), m_method_setName);
            return;
        }
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setLocalName(String name) {
        if (name == null) {
            this.getErrorHandler().log("invalid Local name", this.getClass().getName(), m_method_setLocalName);
            return;
        }
        this.m_localName = name;
    }

    @Override
    public String getLocalName() {
        return this.m_localName;
    }

    @Override
    public void setDescription(String desc) {
        if (desc == null) {
            this.getErrorHandler().log("invalid Description", this.getClass().getName(), m_method_setDescription);
            return;
        }
        this.m_description = desc;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setDrillingEnabled(boolean b) {
        if (this.getModel() != null) {
            this.getModel().setDrillingEnabled(b);
        }
        this.m_drillingEnabled = b;
    }

    @Override
    public boolean isDrillingEnabled() {
        if (this.getModel() != null) {
            return this.getModel().isDrillingEnabled();
        }
        return this.m_drillingEnabled;
    }

    @Override
    public boolean isDrillingSupported() {
        return false;
    }

    @Override
    public void setPagingControlVisible(boolean v) {
        this.m_pagingVisible = v;
    }

    @Override
    public boolean isPagingControlVisible() {
        return this.m_pagingVisible;
    }

    @Override
    public void setPagingControlPosition(int loc) {
        this.m_pagingControlPosition = loc;
    }

    @Override
    public int getPagingControlPosition() {
        return this.m_pagingControlPosition;
    }

    public void setXMLValidated(boolean validate) {
        this.m_validate = validate;
    }

    public boolean isXMLValidated() {
        return this.m_validate;
    }

    @Concealed
    protected ObjectNode getObjectNode(String objName, boolean allProperties) {
        return this.getObjectNode(objName, allProperties, "");
    }

    @Concealed
    protected ObjectNode getObjectNode(String objName, boolean allProperties, String version) {
        ObjectNode node = new ObjectNode(objName);
        node.addProperty("version", version);
        this.getViewXML().getObjectNode(node, allProperties);
        return node;
    }

    public String getXML(String objName, boolean allProperties) {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode(objName, allProperties));
            return writer.toString();
        }
        catch (BIIOException biioe) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "getXML(boolean allProperties)");
            return null;
        }
    }

    @Concealed
    protected DataviewXML getViewXML() {
        return this.m_viewXML;
    }

    @Concealed
    protected void setViewXML(DataviewXML viewXML) {
        this.m_viewXML = viewXML;
    }

    @Override
    public void setDataSource(DataSource ds) {
    }

    @Concealed
    public int convertComponentTypeToInteger(String type) {
        if (type.equals("PAGE_HEADER")) {
            return 3;
        }
        return -1;
    }

    @Concealed
    public String convertComponentTypeToString(int type) {
        if (type == 3) {
            return "PAGE_HEADER";
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Concealed
    public String getFlashPlayerDownloadMessageHTML(String version, String url) {
        String s = MessageFormat.format(this.getIntlString("FlashPlayerDownload"), version, "<a href='" + url + "'>" + url + "</a>");
        return s;
    }

    @Override
    @Concealed
    public BitSet createPropertyOverrideFlags(int maxID) {
        return new BitSet(maxID);
    }

    @Override
    @Concealed
    public void setPropertyOverrideFlags(int attrID, BitSet userFlags, BitSet styleFlags) {
        if (userFlags != null && attrID >= 0 && attrID < userFlags.size()) {
            if (this.isUserOverrideMode()) {
                userFlags.set(attrID);
            }
            if (this.isStyleOverrideMode()) {
                styleFlags.set(attrID);
            }
            this._styleModified = true;
        }
    }

    @Override
    @Concealed
    public TokenSubstitution getTokenSubstitution() {
        if (this.m_tokenSubstitution == null) {
            this.m_tokenSubstitution = new TokenSubstitutionAdapter(this);
        }
        return this.m_tokenSubstitution;
    }

    @Override
    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_tokenSubstitution = token;
    }

    @Override
    @Concealed
    public boolean isPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            return overrideFlags.get(attrID);
        }
        return false;
    }

    @Concealed
    public void clearPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            overrideFlags.clear(attrID);
        }
    }

    @Concealed
    protected void setStyleOverrideMode(boolean flag) {
        this._styleOverrideMode = flag;
    }

    @Concealed
    protected boolean isStyleOverrideMode() {
        return this._styleOverrideMode;
    }

    @Concealed
    protected boolean isStyleModified() {
        return this._styleModified;
    }

    @Concealed
    protected void clearStyleModified() {
        this._styleModified = false;
    }

    @Concealed
    protected void setUserOverrideMode(boolean flag) {
        this._userOverrideMode = flag;
    }

    @Concealed
    protected boolean isUserOverrideMode() {
        return this._userOverrideMode;
    }

    protected boolean isEdgeValid(int edge) {
        return edge == 0 || edge == 1 || edge == 2;
    }

    private boolean _isMemberMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("label") || type.equals("mediumName") || type.equals("value") || type.equals("shortName");
    }

    private boolean _isLayerMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("layerLabel") || type.equals("dimMediumName") || type.equals("layerName") || type.equals("dimShortName");
    }

    @Concealed
    public void setAttributeFormatter(AttributeFormatter attributeFormatter) {
        this.m_attributeFormatter = attributeFormatter;
    }

    @Concealed
    public AttributeFormatter getAttributeFormatter() {
        return this.m_attributeFormatter;
    }

    @Concealed
    public Map<Object, Object> getContext() {
        return this.m_context;
    }

    @Concealed
    public void setContext(Map<Object, Object> context) {
        this.m_context = context;
    }

    @Concealed
    public static int convertAnimationOnDataChangeToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationOnDataChange();
        if (type.equals("none") || type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals(adc_auto) || type.equals(ve_auto)) {
            styleName = 1;
        } else if (type.equals("auto") || type.equals("ON")) {
            styleName = 2;
        } else if (type.equals("alphaFade")) {
            styleName = 3;
        } else if (type.equals("conveyorFromRight")) {
            styleName = 4;
        } else if (type.equals("conveyorFromLeft")) {
            styleName = 5;
        } else if (type.equals("cubeToRight")) {
            styleName = 6;
        } else if (type.equals("cubeToLeft")) {
            styleName = 7;
        } else if (type.equals("flipRight")) {
            styleName = 8;
        } else if (type.equals("flipLeft")) {
            styleName = 9;
        } else if (type.equals("slideToRight")) {
            styleName = 10;
        } else if (type.equals("slideToLeft")) {
            styleName = 11;
        } else if (type.equals("transitionToRight")) {
            styleName = 12;
        } else if (type.equals("transitionToLeft")) {
            styleName = 13;
        } else if (type.equals("zoom")) {
            styleName = 14;
        }
        return styleName;
    }

    @Concealed
    public static String convertAnimationOnDataChangeToString(int type) {
        String styleName = adc_auto;
        if (type == 0) {
            styleName = "none";
        } else if (type == 1) {
            styleName = adc_auto;
        } else if (type == 2) {
            styleName = "auto";
        } else if (type == 3) {
            styleName = "alphaFade";
        } else if (type == 4) {
            styleName = "conveyorFromRight";
        } else if (type == 5) {
            styleName = "conveyorFromLeft";
        } else if (type == 6) {
            styleName = "cubeToRight";
        } else if (type == 7) {
            styleName = "cubeToLeft";
        } else if (type == 8) {
            styleName = "flipRight";
        } else if (type == 9) {
            styleName = "flipLeft";
        } else if (type == 10) {
            styleName = "slideToRight";
        } else if (type == 11) {
            styleName = "slideToLeft";
        } else if (type == 12) {
            styleName = "transitionToRight";
        } else if (type == 13) {
            styleName = "transitionToLeft";
        } else if (type == 14) {
            styleName = "zoom";
        }
        return styleName;
    }

    @Concealed
    public static int convertAnimationIndicatorsToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationIndicators();
        if (type.equals("NONE") || type.equals("none")) {
            styleName = 0;
        } else if (type.equals(ai_all) || type.equals(a_all)) {
            styleName = 1;
        }
        return styleName;
    }

    @Concealed
    public static String convertAnimationIndicatorsToString(int type) {
        String styleName = ai_all;
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = ai_all;
        }
        return styleName;
    }

    @Concealed
    public static int convertAnimationOnDisplayToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationOnDisplay();
        if (type.equals("none") || type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals("auto") || type.equals(ve_auto)) {
            styleName = 1;
        } else if (type.equals("alphaFade")) {
            styleName = 2;
        } else if (type.equals("conveyorFromRight")) {
            styleName = 3;
        } else if (type.equals("conveyorFromLeft")) {
            styleName = 4;
        } else if (type.equals("cubeToRight")) {
            styleName = 5;
        } else if (type.equals("cubeToLeft")) {
            styleName = 6;
        } else if (type.equals("flipRight")) {
            styleName = 7;
        } else if (type.equals("flipLeft")) {
            styleName = 8;
        } else if (type.equals("slideToRight")) {
            styleName = 9;
        } else if (type.equals("slideToLeft")) {
            styleName = 10;
        } else if (type.equals("transitionToRight")) {
            styleName = 11;
        } else if (type.equals("transitionToLeft")) {
            styleName = 12;
        } else if (type.equals("zoom")) {
            styleName = 13;
        }
        return styleName;
    }

    @Concealed
    public static String convertAnimationOnDisplayToString(int type) {
        String styleName = "none";
        if (type == 0) {
            styleName = "none";
        } else if (type == 1) {
            styleName = "auto";
        } else if (type == 2) {
            styleName = "alphaFade";
        } else if (type == 3) {
            styleName = "conveyorFromRight";
        } else if (type == 4) {
            styleName = "conveyorFromLeft";
        } else if (type == 5) {
            styleName = "cubeToRight";
        } else if (type == 6) {
            styleName = "cubeToLeft";
        } else if (type == 7) {
            styleName = "flipRight";
        } else if (type == 8) {
            styleName = "flipLeft";
        } else if (type == 9) {
            styleName = "slideToRight";
        } else if (type == 10) {
            styleName = "slideToLeft";
        } else if (type == 11) {
            styleName = "transitionToRight";
        } else if (type == 12) {
            styleName = "transitionToLeft";
        } else if (type == 13) {
            styleName = "zoom";
        }
        return styleName;
    }

    @Concealed
    public static int convertVisualEffectsToInt(String type) {
        int styleName = DataviewDefaultValues.getVisualEffects();
        if (type.equals("NONE") || type.equals("none")) {
            styleName = 0;
        } else if (type.equals(ve_auto) || type.equals("auto")) {
            styleName = 1;
        }
        return styleName;
    }

    @Concealed
    public static String convertVisualEffectsToString(int type) {
        String styleName = ve_auto;
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = ve_auto;
        }
        return styleName;
    }

    static {
        s_resourceBundleMap = new ConcurrentHashMap();
    }

    @Concealed
    protected static class NullObject {
        @CodeSharingSafe(value="StaticField")
        private static NullObject m_nullObj = null;

        private NullObject() {
        }

        public static NullObject getNullObject() {
            if (m_nullObj == null) {
                m_nullObj = new NullObject();
            }
            return m_nullObj;
        }
    }

    @Concealed
    public static class DefaultAttributeFormatter
    implements AttributeFormatter {
        @Override
        public boolean hasAttributeFormatter(Object attributeName) {
            return false;
        }

        @Override
        public String formatAsString(Object attributeName, Object toFormat) {
            return null;
        }
    }
}

