/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.markers.MarkerEvent;
import oracle.ide.markers.MarkerEventHandler;
import oracle.ide.markers.MarkerEventType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Filter;

public interface MarkerEventHandlerDescriptor
extends Filter<MarkerEvent> {
    public MarkerEventHandler getHandler();

    public String getHandlerName();

    public String getFilterName();

    public List<String> getMarkerTypeNames();

    public boolean includesSubtypes(String var1);

    public List<MarkerEventType> getMarkerEventTypes(String var1);

    public static class Factory {
        private static final String HANDLER_EL_NAME = "handler";
        private static final String HOOK_ID = "marker-event-handlers-hook";
        private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "marker-event-handlers-hook");
        private static final CopyOnWriteArrayList<MarkerEventHandlerDescriptor> DESCRIPTORS = new CopyOnWriteArrayList();
        private static final HashStructureHookAggregator AGGREGATOR = new HashStructureHookAggregator(HOOK_NAME, new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getCombinedHashStructure());
            }
        });

        private static void addDescriptors(HashStructure hash) {
            if (null == hash) {
                return;
            }
            List list = hash.getAsList(HANDLER_EL_NAME);
            for (Object obj : list) {
                MarkerEventHandlerDescriptor descriptor = (MarkerEventHandlerDescriptor)AdapterManager.Factory.getAdapterManager().adapt(obj, MarkerEventHandlerDescriptor.class);
                if (null == descriptor) continue;
                DESCRIPTORS.addIfAbsent(descriptor);
            }
        }

        public static List<MarkerEventHandlerDescriptor> getHandlers() {
            AGGREGATOR.initialize();
            return Collections.unmodifiableList(DESCRIPTORS);
        }
    }
}

