/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerAttributesHandler;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ClassHierarchy;

public class MarkerAttributesHandlerChain
implements MarkerAttributesHandler<Marker> {
    private final MarkerAttributesHandler[] handlers;

    private MarkerAttributesHandlerChain(List<MarkerAttributesHandler> handlers) {
        if (null == handlers || handlers.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one MarkerAttributesHandler instance");
        }
        this.handlers = handlers.toArray(new MarkerAttributesHandler[handlers.size()]);
    }

    @Override
    public Object getAttribute(Marker marker, String name) {
        for (MarkerAttributesHandler handler : this.handlers) {
            Object attrValue = handler.getAttribute(marker, name);
            if (null == attrValue) continue;
            return attrValue;
        }
        return null;
    }

    @Override
    public int getAttribute(Marker marker, String name, int defaultVal) {
        for (MarkerAttributesHandler handler : this.handlers) {
            int attrValue = handler.getAttribute(marker, name, defaultVal);
            if (defaultVal == attrValue) continue;
            return attrValue;
        }
        return defaultVal;
    }

    @Override
    public long getAttribute(Marker marker, String name, long defaultVal) {
        for (MarkerAttributesHandler handler : this.handlers) {
            long attrValue = handler.getAttribute(marker, name, defaultVal);
            if (defaultVal == attrValue) continue;
            return attrValue;
        }
        return defaultVal;
    }

    @Override
    public float getAttribute(Marker marker, String name, float defaultVal) {
        for (MarkerAttributesHandler handler : this.handlers) {
            float attrValue = handler.getAttribute(marker, name, defaultVal);
            if (defaultVal == attrValue) continue;
            return attrValue;
        }
        return defaultVal;
    }

    @Override
    public double getAttribute(Marker marker, String name, double defaultVal) {
        for (MarkerAttributesHandler handler : this.handlers) {
            double attrValue = handler.getAttribute(marker, name, defaultVal);
            if (defaultVal == attrValue) continue;
            return attrValue;
        }
        return defaultVal;
    }

    @Override
    public boolean getAttribute(Marker marker, String name, boolean defaultVal) {
        for (MarkerAttributesHandler handler : this.handlers) {
            boolean attrValue = handler.getAttribute(marker, name, defaultVal);
            if (defaultVal == attrValue) continue;
            return attrValue;
        }
        return defaultVal;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            attrs.putAll(handler.getAttributes(marker));
        }
        return attrs;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker, String ... names) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            attrs.putAll(handler.getAttributes(marker, names));
        }
        return attrs;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker, Map<String, Object> defaults) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            attrs.putAll(handler.getAttributes(marker, defaults));
        }
        return attrs;
    }

    @Override
    public void update(Marker marker, Map<String, Object> attributes, boolean replace) {
        for (MarkerAttributesHandler handler : this.handlers) {
            try {
                handler.update(marker, attributes, replace);
            }
            catch (MarkerException e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> removedAttributes(Marker marker) {
        HashMap<String, Object> removedAttrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            removedAttrs.putAll(handler.removedAttributes(marker));
        }
        return removedAttrs;
    }

    @Override
    public Map<String, Object> addedAttributes(Marker marker) {
        HashMap<String, Object> addedAttrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            addedAttrs.putAll(handler.addedAttributes(marker));
        }
        return addedAttrs;
    }

    @Override
    public Map<String, Object> modifiedAttributes(Marker marker) {
        HashMap<String, Object> modifiedAttrs = new HashMap<String, Object>();
        for (MarkerAttributesHandler handler : this.handlers) {
            modifiedAttrs.putAll(handler.modifiedAttributes(marker));
        }
        return modifiedAttrs;
    }

    public static class HashStructureAdapterFactory
    implements AdapterFactory<MarkerAttributesHandlerChain, HashStructure> {
        public HashStructure adapt(MarkerAttributesHandlerChain chain) {
            for (MarkerAttributesHandler handler : chain.handlers) {
                HashStructure hash = (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)handler, HashStructure.class);
                if (null == hash) continue;
                return hash;
            }
            return null;
        }
    }

    public static class Factory {
        public static MarkerAttributesHandler newMarkerAttributesHandlerChainFor(Marker marker) {
            ArrayList<MarkerAttributesHandler> handlers = new ArrayList<MarkerAttributesHandler>();
            List classes = ClassHierarchy.getClassOrder(marker.getClass());
            for (Class _class : classes) {
                Class<? extends MarkerAttributesHandler> handlerType;
                MarkerType markerType = _class.getAnnotation(MarkerType.class);
                if (null == markerType || null == (handlerType = markerType.handler())) continue;
                try {
                    handlers.add(handlerType.newInstance());
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "Trying to instantiate marker attributes handler: " + handlerType.getName(), e);
                }
            }
            return new MarkerAttributesHandlerChain(handlers);
        }
    }
}

