/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import javax.ide.util.MetaClass;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Marker;
import oracle.javatools.util.Filter;

public class MarkerTypeFilter
implements Filter<Marker> {
    private final MetaClass<? extends Marker> markerMetaClass;
    private Class<? extends Marker> markerType;
    private final boolean includeSubtypes;

    public MarkerTypeFilter(Class<? extends Marker> markerType, boolean includeSubtypes) {
        if (markerType == null) {
            throw new IllegalArgumentException("Marker type must not be null");
        }
        this.markerType = markerType;
        this.includeSubtypes = includeSubtypes;
        this.markerMetaClass = null;
    }

    public MarkerTypeFilter(MetaClass<? extends Marker> markerType, boolean includeSubtypes) {
        if (null == markerType) {
            throw new IllegalArgumentException("Marker type must not be null");
        }
        this.markerMetaClass = markerType;
        this.includeSubtypes = includeSubtypes;
    }

    public boolean matches(Marker marker) {
        if (null == this.markerType) {
            try {
                Class markerType;
                this.markerType = markerType = this.markerMetaClass.toClass();
            }
            catch (ClassNotFoundException e) {
                FeedbackManager.reportException((Throwable)e);
                return false;
            }
        }
        if (!this.markerType.isInstance(marker)) {
            return false;
        }
        if (!this.includeSubtypes) {
            Class<?>[] interfaces;
            for (Class<?> _class : interfaces = marker.getClass().getInterfaces()) {
                if (!_class.equals(this.markerType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        String typeName = null != this.markerType ? this.markerType.getName() : this.markerMetaClass.getClassName();
        return this.getClass().getSimpleName() + "/" + typeName;
    }
}

