/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.markers.MarkerJobProvider;
import oracle.ide.markers.MarkerTypeDescriptor;
import oracle.javatools.data.HashStructure;

public interface MarkerJobProviderDescriptor {
    public MarkerTypeDescriptor getMarkerType();

    public MarkerJobProvider getJobProvider();

    public static class Factory {
        private static final String PROVIDER_EL_NAME = "provider";
        private static final String HOOK_ID = "marker-job-providers-hook";
        private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "marker-job-providers-hook");
        private static final CopyOnWriteArrayList<MarkerJobProviderDescriptor> DESCRIPTORS = new CopyOnWriteArrayList();
        private static final HashStructureHookAggregator AGGREGATOR = new HashStructureHookAggregator(HOOK_NAME, new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getCombinedHashStructure());
            }
        });

        private static void addDescriptors(HashStructure hash) {
            if (null == hash) {
                return;
            }
            List list = hash.getAsList(PROVIDER_EL_NAME);
            if (null == list || list.isEmpty()) {
                return;
            }
            for (Object obj : list) {
                MarkerJobProviderDescriptor descriptor = (MarkerJobProviderDescriptor)AdapterManager.Factory.getAdapterManager().adapt(obj, MarkerJobProviderDescriptor.class);
                if (null == descriptor) continue;
                DESCRIPTORS.add(descriptor);
            }
        }

        public static List<MarkerJobProviderDescriptor> getJobProviderDescriptors() {
            AGGREGATOR.initialize();
            return Collections.unmodifiableList(DESCRIPTORS);
        }
    }
}

