/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.markers.MarkerJobForFileScope;
import oracle.ide.markers.MarkerJobNodeOperator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;

public class MarkerJobForProjectScope
extends MarkerJobForFileScope {
    public MarkerJobForProjectScope(MarkerJobNodeOperator nodeOperator) {
        super(nodeOperator);
        Node initialNode = this.getInitialNode();
        if (null != initialNode) {
            this.processContextNode(initialNode);
        }
    }

    protected Node getInitialNode() {
        return Ide.getActiveProject();
    }

    @Override
    protected Node getNode(Context context) {
        if (null == context) {
            return null;
        }
        return context.getProject();
    }

    @Override
    public boolean isInteresting(Node node) {
        if (node instanceof Project) {
            return true;
        }
        return super.isInteresting(node);
    }

    @Override
    public Void operate(Node node) {
        if (node instanceof Project) {
            this.operateImpl(node);
            return null;
        }
        return super.operate(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void operateImpl(Node node) {
        Project project = this.getProject(node);
        Workspace workspace = this.getWorkspace(node);
        Index index = this.getIndex(workspace, project);
        try {
            index.lock();
            try {
                URL[] urls;
                QueryCriteria criteria = this.getQueryCriteria();
                for (URL url : urls = index.blockingQuery(criteria)) {
                    try {
                        Node found = NodeFactory.findOrCreate((URL)url);
                        if (null == found) {
                            url = URLFactory.encodeURL((URL)url);
                            found = NodeFactory.findOrCreate((URL)url);
                        }
                        if (null == found) continue;
                        this.processContextNode(found);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                }
            }
            finally {
                index.unlock();
            }
        }
        catch (InterruptedException criteria) {
        }
        catch (LockFailedException criteria) {
        }
        catch (QueryFailedException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        finally {
            index.release();
        }
    }

    private Project getProject(Node node) {
        if (node instanceof Project) {
            return (Project)node;
        }
        return null;
    }

    protected final Index getIndex(Workspace workspace, Project project) {
        return this.createIndex(IndexManager.getIndexManager(), workspace, project);
    }

    protected Index createIndex(IndexManager mgr, Workspace ws, Project proj) {
        return null != proj ? mgr.getIndex(ws, proj) : mgr.getIndex(ws);
    }

    protected final QueryCriteria getQueryCriteria() {
        QueryCriteria criteria = new QueryCriteria();
        this.configureCriteria(criteria);
        return criteria;
    }

    protected void configureCriteria(QueryCriteria criteria) {
        criteria.put((Object)"file.all", (Object)"file.all");
    }

    private Workspace getWorkspace(Node node) {
        if (node instanceof Workspace) {
            return (Workspace)node;
        }
        if (node instanceof Project) {
            return ((Project)node).getWorkspace();
        }
        return Ide.getActiveWorkspace();
    }
}

