/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerEventType;
import oracle.javatools.data.Cache;

public class MarkerEvent
extends EventObject {
    private final MarkerEventType eventType;
    private final Cache<Marker> markers;

    public MarkerEvent(Object source, MarkerEventType eventType, Marker ... markers) {
        super(source);
        if (null == eventType) {
            throw new IllegalArgumentException("Marker event type must not be null");
        }
        this.eventType = eventType;
        if (null == markers || 0 == markers.length) {
            throw new IllegalArgumentException("At least one marker must be represented");
        }
        this.markers = Cache.Factory.newWeakCache();
        this.markers.addAll(Arrays.asList(markers));
    }

    public List<Marker> getMarkers() {
        return Collections.unmodifiableList(new ArrayList<Marker>((Collection<Marker>)this.markers));
    }

    public MarkerEventType getEventType() {
        return this.eventType;
    }
}

