/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.library.Library;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.controls.SwitchablePanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContext;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.JDevFavoritesNavigator;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

public class HelpWindow
extends DockableWindow
implements ContextMenuListener,
Controller,
ListSelectionListener {
    private static final float SECTION_TOP = 1.0f;
    private static final float SECTION_MIDDLE = 2.0f;
    public static final String VIEW_TYPE = "HelpSystemAddin";
    public static final String NAME = "HelpWindow";
    private JPanel _panel = new JPanel();
    private SwitchablePanel _switchablePanel;
    private boolean _initialized;
    private DefaultCustomTabPage _TOCPage;
    private JDevTOCNavigator _TOCNavigator;
    private JDevFavoritesNavigator _favoritesNavigator;
    private DefaultCustomTabPage _favoritesPage;
    private String _windowTitle = HelpArb.getString(22);
    private HelpNavigatorListener _helpNavigatorListener;
    private ContextMenu _contextMenu;
    private CustomTab _tabs;
    private DefaultCustomTabPage _currentPage;
    private boolean _uiInitialized;
    private Action _closeTabAction = new TabCloseAction();
    private MouseListener _contextMenuMouseListener = new ContextMenuMouseListener();
    private boolean _separateWindow;
    private static final int PRINT_TOPIC_SUBTREE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.PrintTopicSubtreeCmd");
    private static final int OPEN_TOPIC_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.OpenTopicEditorCmd");
    private static final int TOC_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.TOCTabCmd");
    private static final int FAV_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.FAVTabCmd");
    private static final int SEARCH_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.SearchTabCmd");
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    public static final int TOC_NAVIGATOR = 0;
    public static final int FAVORITES_NAVIGATOR = 1;
    static final String FOCUSED_TAB_NODE = "HelpWindowFocusedTabNode";
    static final String FOCUSED_TAB_NUM = "TabNum";
    private static final String HELP_ID = "f1_helpnav_html";

    public HelpWindow(String viewId) {
        super(viewId);
        this._helpNavigatorListener = new HelpNavigatorListener();
        this._panel.setOpaque(false);
    }

    public String getTitleName() {
        return this._windowTitle;
    }

    public String getTabName() {
        return HelpArb.getString(13);
    }

    public Icon getTabIcon() {
        return HelpArb.getIcon(14);
    }

    public String getMenuTitle() {
        return HelpArb.getString(22);
    }

    public Component getGUI() {
        this._init();
        return this._panel;
    }

    public Toolbar getToolbar() {
        if (this._currentPage == this._favoritesPage) {
            return this._favoritesNavigator.getToolbar();
        }
        return null;
    }

    public int getType() {
        return 32;
    }

    public JDevTOCNavigator getTOCNavigator() {
        return this._TOCNavigator;
    }

    public void updateTitle() {
        super.updateTitle((Object)this._windowTitle);
        this.fireTitleChangeListener();
    }

    public static ViewId getHelpWindowViewId() {
        return new ViewId("HelpSystemAddin.HelpWindow");
    }

    final void switchNavigator(int displayNavigator) {
        Object userObject;
        this._init();
        DefaultCustomTabPage desiredPage = this.getTabPageForIntPage(displayNavigator);
        this.setSelectedTabToTab((CustomTabPage)desiredPage);
        if (desiredPage instanceof DefaultCustomTabPage && (userObject = desiredPage.getUserObject()) instanceof NavigatorHolder) {
            NavigatorHolder holder = (NavigatorHolder)userObject;
            holder.setVisible(true);
            GraphicsUtils.focusComponentOrChild((Component)holder, (boolean)true);
        }
    }

    void setSeparateWindow(boolean separateWindow) {
        this._separateWindow = separateWindow;
    }

    private void saveLastFocusedTab(DefaultCustomTabPage tabPage) {
        HelpOptions opts = HelpOptions.getInstance();
        int windowType = this._separateWindow ? 2 : 1;
        opts.setLastTabFocused(this.getPageIntForPage(tabPage), windowType);
    }

    private void setSelectedTabToTab(CustomTabPage tabPage) {
        ListModel model = this._tabs.getModel();
        int numPages = model.getSize();
        for (int i = 0; i < numPages; ++i) {
            if (model.getElementAt(i) != tabPage) continue;
            this._tabs.setSelectedPage(i);
            return;
        }
        this._handleDisplay(tabPage, true);
        this._setPageShowOption(tabPage, true);
        this.setSelectedTabToTab(tabPage);
        this.saveLastFocusedTab((DefaultCustomTabPage)tabPage);
    }

    public void close() {
        this.dispose();
        super.close();
    }

    public void dispose() {
        if (this._initialized) {
            ComponentListener[] cls;
            HierarchyListener[] hls;
            if (this._TOCPage != null) {
                this._TOCPage.setUserObject(null);
            }
            if (this._favoritesPage != null) {
                this._favoritesPage.setUserObject(null);
            }
            for (HierarchyListener l : hls = (HierarchyListener[])this._tabs.getListeners(HierarchyListener.class)) {
                this._tabs.removeHierarchyListener(l);
            }
            Component guiComp = this.getGUI();
            for (ComponentListener l : cls = (ComponentListener[])guiComp.getListeners(ComponentListener.class)) {
                guiComp.removeComponentListener(l);
            }
            this._tabs.removeSelectionListener((ListSelectionListener)this);
            this._switchablePanel.removeAllPages();
            this._switchablePanel = null;
            this._TOCNavigator = null;
            this._favoritesNavigator = null;
            IdeAction dropDownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
            dropDownAction.removeController((Controller)this);
            this._initialized = false;
        }
    }

    public boolean isPrintingEnabled() {
        if (this._currentPage != null && this._currentPage.getUserObject() != null) {
            Component comp = (Component)this._currentPage.getUserObject();
            if (comp instanceof TOCNavigator) {
                return this._TOCNavigator.getCurrentSelection() != null;
            }
            return false;
        }
        return false;
    }

    void setActive(boolean active) {
        if (this._TOCNavigator != null) {
            this._TOCNavigator.setActive(active);
        }
        if (this._favoritesNavigator != null) {
            this._favoritesNavigator.setActive(active);
        }
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if (this._currentPage != null) {
            return this._contextMenu;
        }
        return null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(HELP_ID);
    }

    public Controller getController() {
        return this;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        this.addMenuItems(popup, null);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LazyNavigator lazyNav;
        if (e.getFirstIndex() == -1) {
            return;
        }
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._tabs.getPage(e.getFirstIndex());
        if (page == this._currentPage) {
            return;
        }
        this.saveLastFocusedTab(page);
        Component targetComponent = (Component)page.getUserObject();
        NavigatorHolder holder = null;
        if (targetComponent instanceof NavigatorHolder) {
            holder = (NavigatorHolder)targetComponent;
            targetComponent = holder.getNavigator();
        }
        if (targetComponent == null) {
            this._initNavigatorHolder(page);
            targetComponent = ((NavigatorHolder)page.getUserObject()).getNavigator();
        }
        this._helpNavigatorListener.removeListener();
        this._currentPage = page;
        this.updateSelection();
        if (targetComponent instanceof Navigator) {
            this._helpNavigatorListener.addListenerToNavigator((Navigator)targetComponent);
        }
        if (targetComponent == this._TOCNavigator) {
            if (!this._TOCNavigator.isInitialized()) {
                this._TOCNavigator.initializeLazyNavigator();
            }
        } else if (targetComponent instanceof LazyNavigator && !(lazyNav = (LazyNavigator)targetComponent).isInitialized()) {
            lazyNav.initializeLazyNavigator();
        }
        if (targetComponent instanceof JDevNavigator) {
            ((JDevNavigator)((Object)targetComponent)).setActive(true);
        }
    }

    private void _setPageShowOption(CustomTabPage page, boolean show) {
        int windowType;
        HelpOptions opts = HelpOptions.getInstance();
        int n = windowType = this._separateWindow ? 2 : 1;
        if (page == this._TOCPage) {
            opts.setTOCLocation(windowType, show);
        } else if (page == this._favoritesPage) {
            opts.setFavoritesLocation(windowType, show);
        }
    }

    private void _gotoTab(int cmdId) {
        DefaultCustomTabPage page = null;
        int pageNum = -1;
        if (cmdId == TOC_TAB_CMD_ID) {
            pageNum = 0;
            page = this._TOCPage;
        } else if (cmdId == FAV_TAB_CMD_ID) {
            pageNum = 1;
            page = this._favoritesPage;
        }
        this._handleDisplay((CustomTabPage)page, true);
        this.switchNavigator(pageNum);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == PRINT_TOPIC_SUBTREE_CMD_ID) {
            TopicTreeNode selectedNode = this._TOCNavigator.getCurrentSelectionNode();
            Topic[] topics = selectedNode.getAllTopicsInSubTree();
            Context newContext = new Context(context);
            HelpContext.setTopics(newContext, topics);
            try {
                IdeAction printAction = IdeAction.find((String)"Ide.PRINT_PREVIEW_CMD_ID");
                printAction.performAction(newContext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (cmdId == OPEN_TOPIC_CMD_ID) {
            Topic topic = null;
            if (this._currentPage == this._TOCPage) {
                topic = this._TOCNavigator.getCurrentSelection();
            } else if (this._currentPage == this._favoritesPage) {
                topic = this._favoritesNavigator.getCurrentSelection();
            }
            if (topic != null && HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).showTopic(topic);
            }
            return true;
        }
        if (cmdId == 70) {
            this._navigate(-1);
            return true;
        }
        if (cmdId == 71) {
            this._navigate(1);
            return true;
        }
        if (cmdId == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
            if (context.getView() instanceof HelpWindow) {
                this._switchablePanel.displayDropdownMenu();
                return true;
            }
        } else if (cmdId == TOC_TAB_CMD_ID || cmdId == FAV_TAB_CMD_ID || cmdId == SEARCH_TAB_CMD_ID) {
            this._gotoTab(cmdId);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            action.setEnabled(this.isPrintingEnabled());
            return true;
        }
        if (cmdId == 70) {
            action.setEnabled(this._determineNavigation(-1) != -1);
            return true;
        }
        if (cmdId == 71) {
            action.setEnabled(this._determineNavigation(1) != -1);
            return true;
        }
        return false;
    }

    private synchronized void _init() {
        if (!this._uiInitialized) {
            this._initializeUI();
        }
        if (this._initialized) {
            return;
        }
        Library library = HelpWindow.getLibrary();
        HelpSystem helpSys = HelpSystem.getHelpSystem();
        if (library != null) {
            int windowType;
            Preferences prefs = Preferences.getPreferences();
            HelpOptions opts = HelpOptions.getInstance((PropertyStorage)prefs);
            int n = windowType = this._separateWindow ? 2 : 1;
            if (HelpOptions.isNavigatorShown(opts.getTOCLocation(), windowType)) {
                this._switchablePanel.addPage((CustomTabPage)this._TOCPage, (Component)this._TOCPage.getUserObject());
            }
            if (HelpOptions.isNavigatorShown(opts.getFavoritesLocation(), windowType) && HelpSystemAddin.isNavigatorSupported(1)) {
                this._switchablePanel.addPage((CustomTabPage)this._favoritesPage, (Component)this._favoritesPage.getUserObject());
            }
            int focusedTab = -1;
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                focusedTab = opts.getLastTabFocused(this._separateWindow ? 2 : 1);
            }
            this._currentPage = focusedTab == -1 ? this.getTabPageForIntPage(0) : this.getTabPageForIntPage(focusedTab);
            this._handleDisplay((CustomTabPage)this._currentPage, true);
            NavigatorHolder holder = (NavigatorHolder)this._currentPage.getUserObject();
            if (holder.getNavigator() == null) {
                this._initNavigatorHolder(this._currentPage);
            }
            Navigator topNavigator = holder.getNavigator();
            this._helpNavigatorListener.addListenerToNavigator(topNavigator);
            this._switchablePanel.moveToFront((Component)holder);
            this.setSelectedTabToTab((CustomTabPage)this._currentPage);
            this._tabs.addHierarchyListener((HierarchyListener)new TabHierarchyListener());
            if (topNavigator instanceof LazyNavigator) {
                ((LazyNavigator)topNavigator).initializeLazyNavigator();
            } else if (topNavigator instanceof JDevTOCNavigator) {
                ((JDevTOCNavigator)topNavigator).initializeLazyNavigator();
            }
            this._panel.revalidate();
            this._initialized = true;
        } else {
            this._initialized = false;
        }
    }

    static Library getLibrary() {
        JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        Library library = helpSys.getLibrary();
        return library;
    }

    private void _initNavigatorHolder(DefaultCustomTabPage tabPage) {
        Library library = HelpWindow.getLibrary();
        if (tabPage == this._TOCPage) {
            this._initTOCNavigator(library);
        } else if (tabPage == this._favoritesPage) {
            this._initFavoritesNavigator(library);
        }
    }

    private boolean _initTOCNavigator(Library library) {
        boolean retval = false;
        if (library != null) {
            try {
                JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                this._TOCNavigator = new JDevTOCNavigator(this, library);
                NavigatorHolder holder = (NavigatorHolder)this._TOCPage.getUserObject();
                holder.setNavigator((Navigator)this._TOCNavigator);
                this._TOCNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                retval = true;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
        return retval;
    }

    private boolean _initFavoritesNavigator(Library library) {
        boolean retval = false;
        HelpSystem helpSys = HelpSystem.getHelpSystem();
        if (library != null) {
            try {
                FavoritesModel favoritesModel;
                if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel()) != null) {
                    this._favoritesNavigator = new JDevFavoritesNavigator(this, library, "Favorites");
                    this._favoritesNavigator.setFavoritesModel(favoritesModel);
                    NavigatorHolder holder = (NavigatorHolder)this._favoritesPage.getUserObject();
                    holder.setNavigator((Navigator)this._favoritesNavigator);
                    this._favoritesNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                    retval = true;
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
        return retval;
    }

    private void _initializeUI() {
        NavigatorHolder holder = new NavigatorHolder();
        this._TOCPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"library.png"), HelpArb.getString(18), (Object)holder);
        holder.setTabPage(this._TOCPage);
        this._TOCPage.setTooltip(HelpArb.getString(18));
        if (HelpSystemAddin.isNavigatorSupported(1)) {
            holder = new NavigatorHolder();
            this._favoritesPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"favorites.png"), HelpArb.getString(19), (Object)holder);
            holder.setTabPage(this._favoritesPage);
            this._favoritesPage.setTooltip(HelpArb.getString(19));
        }
        this._panel.setLayout(new BorderLayout());
        this._switchablePanel = new SwitchablePanel(1);
        this._tabs = this._switchablePanel.getCustomTab();
        this._switchablePanel.setOpaque(false);
        this._tabs.setOffsetSelected(0);
        this._tabs.addSelectionListener((ListSelectionListener)this);
        this._tabs.setCloseAction(this._closeTabAction);
        this._tabs.addMouseListener((MouseListener)new CustomTabMouseListener());
        IdeAction dropDownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        dropDownAction.addController((Controller)this);
        this._panel.add((Component)this._switchablePanel, "Center");
        this._uiInitialized = true;
    }

    CustomTab getCustomTab() {
        return this._tabs;
    }

    private int _getNumPages() {
        DefaultListModel model = this._switchablePanel.getModel();
        int numTabs = model.getSize();
        return numTabs;
    }

    private void _closeTabPage(CustomTabPage tabPage) {
        int numOpenTabs = this._getNumPages();
        if (numOpenTabs == 1) {
            this._switchablePanel.getCustomTab().setSelectedPage(-1);
        }
        this._switchablePanel.removePage(tabPage);
        this._setPageShowOption(tabPage, false);
    }

    private int _determineNavigation(int direction) {
        DefaultListModel listModel = this._switchablePanel.getModel();
        if (listModel.size() > 1) {
            int listPosition = listModel.indexOf(this._currentPage);
            if (listPosition == 0 && direction == -1) {
                return -1;
            }
            if (listPosition == listModel.size() - 1 && direction == 1) {
                return -1;
            }
            return listPosition + direction;
        }
        return -1;
    }

    private void _navigate(int direction) {
        int targetPosition = this._determineNavigation(direction);
        if (targetPosition != -1) {
            this._tabs.setSelectedPage(targetPosition);
        }
    }

    private int getPageIntForPage(DefaultCustomTabPage page) {
        int returnPage = -1;
        if (page == this._TOCPage) {
            returnPage = 0;
        } else if (page == this._favoritesPage) {
            returnPage = 1;
        }
        return returnPage;
    }

    private DefaultCustomTabPage getTabPageForIntPage(int page) {
        DefaultCustomTabPage returnPage = null;
        if (page == 0) {
            returnPage = this._TOCPage;
        } else if (page == 1) {
            returnPage = this._favoritesPage;
        }
        return returnPage;
    }

    private void _handleDisplay(CustomTabPage tabPage, boolean display) {
        boolean isCurrentlyDisplayed = false;
        Component comp = this._switchablePanel.getComponentForPage(tabPage);
        if (comp != null) {
            isCurrentlyDisplayed = true;
        }
        if (isCurrentlyDisplayed != display) {
            if (display) {
                int newPageNum = this.getPageIntForPage((DefaultCustomTabPage)tabPage);
                int pageNum = 0;
                int insertLocation = 0;
                DefaultListModel listModel = this._switchablePanel.getModel();
                int listLen = listModel.size();
                for (int i = 0; i < listLen && pageNum < newPageNum; ++i) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)listModel.elementAt(i);
                    pageNum = this.getPageIntForPage(page);
                    insertLocation = i;
                    if (i != listLen - 1 || pageNum >= newPageNum) continue;
                    ++insertLocation;
                }
                DefaultCustomTabPage dtabPage = (DefaultCustomTabPage)tabPage;
                NavigatorHolder holder = (NavigatorHolder)dtabPage.getUserObject();
                this._switchablePanel.addPage(tabPage, (Component)holder, insertLocation);
            } else {
                this._closeTabPage(tabPage);
            }
        }
    }

    void addMenuItems(Object popup, Topic topic) {
        boolean isCtxMenu = popup instanceof ContextMenu;
        ContextMenu cm = null;
        if (!isCtxMenu) {
            cm = this.getContextMenu();
            JPopupMenu pmenu = (JPopupMenu)popup;
            if (pmenu.getComponentCount() > 0) {
                pmenu.add(new JPopupMenu.Separator());
            }
        } else {
            cm = (ContextMenu)popup;
        }
        float currentItemLoc = 1.0f;
        if (this._currentPage != null && this._currentPage == this._TOCPage || this._currentPage == this._favoritesPage) {
            boolean actionEnabled;
            Topic selTopic = topic;
            if (selTopic == null) {
                if (this._currentPage == this._TOCPage) {
                    topic = this._TOCNavigator.getCurrentSelection();
                } else if (this._currentPage == this._favoritesPage) {
                    topic = this._favoritesNavigator.getCurrentSelection();
                }
            }
            String label = HelpArb.getString(53);
            IdeAction action = IdeAction.get((int)OPEN_TOPIC_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
            action.addController((Controller)this);
            boolean bl = actionEnabled = topic != null && topic.hasTarget();
            if (this._currentPage != null && this._currentPage == this._favoritesPage && !this._favoritesNavigator.hasSingleSelection()) {
                actionEnabled = false;
            }
            action.setEnabled(actionEnabled);
            this._addMenuItemForAction(popup, action, currentItemLoc);
            if (this._currentPage != null && this._currentPage == this._TOCPage && topic != null && !this.isExternalTopic(topic)) {
                if (!isCtxMenu && popup instanceof JPopupMenu) {
                    ((JPopupMenu)popup).addSeparator();
                } else if (isCtxMenu) {
                    currentItemLoc = 2.0f;
                }
                label = HelpArb.getString(15);
                action = IdeAction.get((int)PRINT_TOPIC_SUBTREE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)IdeArb.getIcon((int)75), null, (boolean)true);
                action.addController((Controller)this);
                action.setEnabled(topic != null);
                TopicTreeNode ttn = this._TOCNavigator.getCurrentSelectionNode();
                label = ttn.hasChildren() ? HelpArb.getString(15) : HelpArb.getString(16);
                action.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                action.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)label)));
                this._addMenuItemForAction(popup, action, currentItemLoc);
            }
            if (this._currentPage != null && this._currentPage == this._favoritesPage && popup instanceof ContextMenu) {
                currentItemLoc = 2.0f;
                action = this._favoritesNavigator.getNewFavoriteFolderAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                action = this._favoritesNavigator.getAddExternalAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                currentItemLoc = MenuConstants.increment((float)currentItemLoc);
                action = this._favoritesNavigator.getRenameFavoriteAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                action.updateAction(new Context());
                action = this._favoritesNavigator.getDeleteFavoriteAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                ((ContextMenu)popup).addSeparator();
                currentItemLoc += MenuConstants.increment((float)currentItemLoc);
            }
        }
    }

    boolean isNavigatorAvailable(int navigator) {
        boolean available = HelpSystemAddin.isNavigatorSupported(navigator);
        return available;
    }

    private boolean isExternalTopic(Topic topic) {
        MultipleTypeTopic mtt;
        int mttType;
        boolean retval = false;
        if (topic instanceof MultipleTypeTopic && ((mttType = (mtt = (MultipleTypeTopic)topic).getTopicType()) == 3 || mttType == 11)) {
            retval = true;
        }
        return retval;
    }

    private void _addMenuItemForAction(Object popup, IdeAction action, float location) {
        boolean isCtxMenu = popup instanceof ContextMenu;
        ContextMenu cm = null;
        cm = !isCtxMenu ? this.getContextMenu() : (ContextMenu)popup;
        JMenuItem menuItem = cm.createMenuItem((ToggleAction)action);
        if (isCtxMenu) {
            cm.add((Component)menuItem, location);
        } else {
            ((JPopupMenu)popup).add(menuItem);
        }
    }

    private final class CustomTabMouseListener
    extends MouseAdapter {
        private CustomTabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            ContextMenu cm = new ContextMenu();
            Context context = HelpWindow.this.getContext(e);
            cm.show(context);
        }
    }

    final class NavigatorHolder
    extends JPanel {
        private Navigator _navigator;
        private DefaultCustomTabPage _tabPage;

        public NavigatorHolder() {
            this.setFocusCycleRoot(false);
        }

        public void setTabPage(DefaultCustomTabPage tabPage) {
            this._tabPage = tabPage;
        }

        public Navigator getNavigator() {
            return this._navigator;
        }

        public void setNavigator(Navigator navigator) {
            this._navigator = navigator;
            this.setLayout(new BorderLayout());
            this.add((Component)navigator, "Center");
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible && this._navigator == null) {
                HelpWindow.this._initNavigatorHolder(this._tabPage);
            }
            if (this._navigator != null) {
                this._navigator.setVisible(visible);
            }
            super.setVisible(visible);
        }
    }

    private final class TabHierarchyListener
    implements HierarchyListener {
        private TabHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            long cflags = e.getChangeFlags();
            if ((cflags & 4L) == 4L) {
                HelpWindow.this._switchablePanel.ensureTabVisible();
                HelpWindow.this._tabs.removeHierarchyListener((HierarchyListener)this);
            }
        }
    }

    private final class ContextMenuMouseListener
    extends MouseAdapter {
        private ContextMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            Context context = HelpWindow.this.getContext(e);
            HelpWindow.this.getContextMenu().show(context);
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        private TabCloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomTabPage tabPage = (CustomTabPage)e.getSource();
            HelpWindow.this._closeTabPage(tabPage);
        }
    }

    private final class HelpNavigatorListener
    implements NavigatorListener {
        private Navigator _owner;

        private HelpNavigatorListener() {
        }

        public void addListenerToNavigator(Navigator navigator) {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
            }
            navigator.addNavigatorListener((NavigatorListener)this);
            this._owner = navigator;
        }

        public void removeListener() {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
                this._owner = null;
            }
        }

        public void topicSelected(NavigatorEvent e) {
        }

        public void topicActivated(NavigatorEvent e) {
            Topic topic = e.getTopic();
            if (topic instanceof MultipleTypeTopic) {
                MultipleTypeTopic mTopic = (MultipleTypeTopic)topic;
                if (mTopic.getTopicType() == 3 || mTopic.getTopicType() == 11) {
                    try {
                        URL externalURL = mTopic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(externalURL, null, null);
                    }
                    catch (MalformedURLException mue) {
                        Assert.println((String)"HelpWindow.HelpNavigatorListener.topicActivated() caught MalformedURLException");
                    }
                } else if (topic.hasTarget()) {
                    JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                    helpSys.showTopic(e.getTopic());
                }
            } else if (topic.hasTarget()) {
                Target target = topic.getTarget();
                if (target instanceof SimpleURLTarget) {
                    try {
                        URL targetURL = target.getURL();
                        if (targetURL.getProtocol().startsWith("http")) {
                            BrowserRunner.getBrowserRunner().runBrowserOnURL(targetURL, null, null);
                            return;
                        }
                    }
                    catch (MalformedURLException targetURL) {
                        // empty catch block
                    }
                }
                JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                helpSys.showTopic(e.getTopic());
            }
        }
    }
}

