/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpSystemConstants;

public final class HelpSystemController
implements Controller {
    private static final int TOC_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.TableOfContents");
    private static final int SEARCH_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.FullTextSearch");

    public final boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOC_CMD_ID) {
            HelpSystemAddin.showNavigator(0, null);
            return true;
        }
        if (cmdId == SEARCH_CMD_ID) {
            HelpSystemAddin.showNavigator(0, null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelpCenterWindow.getInstance().focusSearchControl();
                }
            });
            return true;
        }
        if (cmdId == HelpSystemConstants.FORWARD_CMD_ID && context.getView() instanceof HelpContentPanel) {
            return context.getView().getController().handleEvent(action, context);
        }
        return false;
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == HelpSystemConstants.CHELP_TOPICS_ID || cmdId == TOC_CMD_ID || cmdId == SEARCH_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }
}

