/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLGranteeAccessor;
import oracle.xml.parser.v2.XMLNode;

public class XMLUserAccessor
extends XMLGranteeAccessor {
    private static String USER = "USER";
    private static String X_TYPE = "sxml:TYPE";
    private static String X_DEFAULT_TS = "sxml:DEFAULT_TABLESPACE";
    private static String X_TEMP_TS = "sxml:TEMPORARY_TABLESPACE";
    private static String X_PASSWORD_EXPIRE = "sxml:PASSWORD_EXPIRE";
    private static String X_ACCOUNT_LOCK = "sxml:ACCOUNT_LOCK";
    private static String X_GLOBAL_NAME = "sxml:EXTERNAL_NAME";
    private static String X_PROFILE = "sxml:PROFILE";

    protected XMLUserAccessor() {
    }

    protected XMLUserAccessor(XMLNode xmlDoc, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlDoc, client);
    }

    public String getDefaultTablespace() {
        return this.selectTextValue(X_DEFAULT_TS);
    }

    public String getTemporaryTablespace() {
        return this.selectTextValue(X_TEMP_TS);
    }

    public String getPasswordExpiration() {
        return this.nodeExists(X_PASSWORD_EXPIRE) ? "EXPIRED" : "UNEXPIRED";
    }

    public String getAccountStatus() {
        return this.nodeExists(X_ACCOUNT_LOCK) ? "LOCKED" : "UNLOCKED";
    }

    public String getAuthenticationType() {
        return this.selectTextValue(X_TYPE);
    }

    public String getGlobalUsername() {
        return this.selectTextValue(X_GLOBAL_NAME);
    }

    public String getDefaultConsumerGroup() {
        return null;
    }

    public String getProfile() {
        return this.selectTextValue(X_PROFILE);
    }

    @Override
    protected String getTypePathElement() {
        return USER;
    }

    @Override
    public String toString() {
        return super.toString() + "  Password expiration: " + this.getPasswordExpiration() + "\n  " + "  Account status: " + this.getAccountStatus() + "\n  " + "  Default tablespace: " + this.getDefaultTablespace() + "\n  " + "  Temporary tablespace: " + this.getTemporaryTablespace() + "\n  " + "  Profile: " + this.getProfile() + "\n  " + "  Global username: " + this.nin(this.getGlobalUsername()) + "\n  " + "  Default consumer group: " + this.nin(this.getDefaultConsumerGroup()) + "\n";
    }
}

