/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.HashMap;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLColumnAccessor;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class XMLTableColumnsAccessor
extends XMLColumnAccessor {
    private static String COL_LIST = "COL_LIST";
    private static String COL_LIST_ITEM = "COL_LIST_ITEM";
    private boolean m_isPKColumn = false;
    private boolean m_isUKColumn = false;
    private boolean m_removedNNullColumn = false;
    private static String X_COLUMN_DATATYPE = "sxml:DATATYPE";
    private static String X_COLUMN_LENGTH = "sxml:LENGTH";
    private static String X_COLUMN_PRECISION = "sxml:PRECISION";
    private static String X_COLUMN_SCALE = "sxml:SCALE";
    private static String X_COLUMN_DEFAULT = "sxml:DEFAULT";
    private static String X_COLUMN_CONSTRAINT_TYPE = "sxml:CONSTRAINT/sxml:TYPE";
    private static String X_COLUMN_NOT_NULL_CONSTRAINT = "sxml:NOT_NULL";
    private static String X_COLUMN_NOT_NULL_CONSTRAINT_NAME = "sxml:NOT_NULL/sxml:NAME";
    private static String X_COLUMN_TYPE_SCHEMA = "sxml:TYPE_PROPERTIES/sxml:SCHEMA";
    private static String X_COLUMN_TYPE_NAME = "sxml:TYPE_PROPERTIES/sxml:NAME";
    private static String X_COLUMN_NUMBER = "sxml:COL_NUM";
    private static String X_COLUMN_SORT = "sxml:SORT";

    protected XMLTableColumnsAccessor() {
    }

    protected XMLTableColumnsAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        String onSchema = this.getColumnTypeSchema();
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setColumnTypeSchema((String)schemaMap.get(onSchema), changeMode);
        }
    }

    public static String getColumnItemsPath() {
        return "/sxml:TABLE/sxml:RELATIONAL_TABLE/sxml:" + COL_LIST + "/sxml:" + COL_LIST_ITEM;
    }

    public String getColumnDataType() {
        return this.selectTextValue(X_COLUMN_DATATYPE);
    }

    public boolean isLOBType() {
        String dt = this.getColumnDataType();
        if (dt != null) {
            return dt.equals("CLOB") || dt.equals("NCLOB") || dt.equals("BLOB");
        }
        return false;
    }

    public String getColumnLength() {
        String sn = this.selectTextValue(X_COLUMN_LENGTH);
        if (sn == null || sn.trim().equals("")) {
            sn = "0";
        }
        return sn;
    }

    public short getLength() {
        String length = this.getColumnLength();
        return Short.parseShort(length);
    }

    public String getColumnScale() {
        return this.selectTextValue(X_COLUMN_SCALE);
    }

    public String getColumnPrecision() {
        return this.selectTextValue(X_COLUMN_PRECISION);
    }

    public String getColumnDefault() {
        return this.selectTextValue(X_COLUMN_DEFAULT);
    }

    public String getDefaultValue() {
        return this.getColumnDefault();
    }

    public boolean getColumnAllowNull() {
        return !this.getIsPrimaryKeyColumn() && !this.nodeExists(X_COLUMN_NOT_NULL_CONSTRAINT) && !this.m_removedNNullColumn;
    }

    public void markRemovedNNColumn() {
        this.m_removedNNullColumn = true;
    }

    public boolean getAllowNull() {
        return this.getColumnAllowNull();
    }

    public String getColumnTypeSchema() {
        return this.selectTextValue(X_COLUMN_TYPE_SCHEMA);
    }

    public void setColumnTypeSchema(String schema) {
        this.setTextValue(X_COLUMN_TYPE_SCHEMA, schema);
    }

    private void setColumnTypeSchema(String schema, int changeMode) {
        this.setTextValue(X_COLUMN_TYPE_SCHEMA, schema, changeMode);
    }

    public String getColumnTypeName() {
        return this.selectTextValue(X_COLUMN_TYPE_NAME);
    }

    public String getColumnColID() {
        return this.selectTextValue(X_COLUMN_NUMBER);
    }

    public boolean getColumnSort() {
        return this.nodeExists(X_COLUMN_SORT);
    }

    @Override
    protected String getTypePathElement() {
        return "TABLE";
    }

    public boolean hasNamedColLevelConstraint() {
        boolean hasNCLC = false;
        String consName = this.selectTextValue(X_COLUMN_NOT_NULL_CONSTRAINT_NAME);
        if (consName != null) {
            hasNCLC = true;
        }
        return hasNCLC;
    }

    public String getConstraintName() {
        return this.selectTextValue(X_COLUMN_NOT_NULL_CONSTRAINT_NAME);
    }

    public void setConstraintName(String cName) {
        this.setTextValue(X_COLUMN_NOT_NULL_CONSTRAINT_NAME, cName);
    }

    public String getDatatypeClause() {
        XMLDocument columnDoc = new XMLDocument();
        XMLNode importable = (XMLNode)columnDoc.importNode((Node)this.getXmlNode(), true);
        columnDoc.appendChild((Node)importable);
        String ddl = this.generateDDL(4, 1, columnDoc);
        return ddl;
    }

    @Override
    protected int getObjType() {
        return 102;
    }

    void setIsPrimaryKeyColumn(boolean isPKCol) {
        this.m_isPKColumn = isPKCol;
    }

    public boolean getIsPrimaryKeyColumn() {
        return this.m_isPKColumn;
    }

    void setIsUniqueKeyColumn(boolean isUKCol) {
        this.m_isUKColumn = isUKCol;
    }

    public boolean getIsUniqueKeyColumn() {
        return this.m_isUKColumn;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   Name: ").append(this.getColumnName()).append("\n").append("    Datatype: ").append(this.getDatatypeClause()).append("\n").append("    Default: ").append(this.nin(this.getColumnDefault())).append("\n").append("    Allow null: ").append(XMLTableColumnsAccessor.YorN(this.getColumnAllowNull())).append("\n");
        return sb.toString();
    }
}

