/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLOnePartitionAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLPartitionsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XMLSchemaObjAccessor
extends XMLAccessor {
    protected static final int AUTOMATIC = -1;
    protected static final int NOPARALLEL = 0;
    private static final int SCHEMA_OBJ_SEG_ATTR_UNINITIALIZED = -1;
    protected static String X_SCHEMA = "sxml:SCHEMA";
    protected PreparedStatement m_commentsStmt = null;
    private static final String s_getObjCommentsQuery_DBA = "select * from ( select null, comments from dba_tab_comments where owner = ? and table_name = ?   and comments is not null union all select column_name, comments from dba_col_comments where owner = ? and table_name = ?   and comments is not null ) order by 1 asc nulls first";
    private static final String s_getObjCommentsQuery_ALL = "select * from ( select null, comments from all_tab_comments where owner = ? and table_name = ?   and comments is not null union all select column_name, comments from all_col_comments where owner = ? and table_name = ?   and comments is not null ) order by 1 asc nulls first";
    private static final String COMMENTS_PATH = "sxml:COMMENTS";

    protected XMLSchemaObjAccessor() {
    }

    protected XMLSchemaObjAccessor(XMLAccessorClient client) {
        super(client);
    }

    protected XMLSchemaObjAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        super.applySchemaMap(schemaMap, changeMode);
        String schema = this.getSchema();
        if (schemaMap.containsKey(schema)) {
            this.setSchema((String)schemaMap.get(schema), changeMode);
        }
    }

    public String getSchema() {
        String schema = this.selectTextValue(this.getSchemaPath());
        return schema;
    }

    public void setSchema(String schema) {
        this.setTextValue(this.getSchemaPath(), schema);
    }

    private void setSchema(String schema, int changeMode) {
        this.setTextValue(this.getSchemaPath(), schema, changeMode);
    }

    public String getObjectSchema() {
        return this.getSchema();
    }

    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getQuotedFullName() {
        int flags;
        boolean suppressSchema = false;
        if (this.getAccessorClient() != null && ((flags = this.getAccessorClient().getSXMLToDDLTransformParamFlags(0)) & 0x40000000) != 0) {
            suppressSchema = true;
        }
        if (!suppressSchema) {
            return "\"" + this.getSchema() + "\"." + this.getQuotedName();
        }
        return this.getQuotedName();
    }

    protected String getSchemaPath() {
        return X_SCHEMA;
    }

    public XMLSegmentAccessor getSegment() {
        return null;
    }

    public String getTablespace() {
        if (this.getSegment() != null) {
            return this.getSegment().getTablespace();
        }
        return null;
    }

    public void setTablespace(String tablespace) {
        if (this.getSegment() != null) {
            this.getSegment().setTablespace(tablespace);
        }
    }

    public boolean getPartitioned() {
        return false;
    }

    public XMLPartitionsAccessor getPartitions() {
        return null;
    }

    public int getNumberPartitions() {
        NodeList pList;
        int count = 0;
        if (this.getPartitions() != null && (pList = this.getPartitions().getPartitions()) != null) {
            count = pList.getLength();
        }
        return count;
    }

    public XMLOnePartitionAccessor getPartitionAt(int index) throws XMLAccessorException {
        NodeList parts;
        XMLOnePartitionAccessor opa = null;
        if (this.getPartitions() != null && (parts = this.getPartitions().getPartitions()) != null && parts.getLength() > index) {
            XMLNode part = (XMLNode)parts.item(index);
            opa = new XMLOnePartitionAccessor(part, this.getAccessorClient());
        }
        return opa;
    }

    protected String getParallelPath() {
        return null;
    }

    protected String getParallelDegreePath() {
        return null;
    }

    protected String getParallelDegreeDegreePath() {
        return null;
    }

    public boolean getParallel() {
        String parallelPath = this.getParallelPath();
        String parallelDegPath = this.getParallelDegreePath();
        if (parallelPath == null || parallelDegPath == null) {
            return false;
        }
        return this.nodeExists(parallelPath) || this.nodeExists(parallelDegPath);
    }

    public void setParallel(boolean parallel) {
        String parallelPath = this.getParallelPath();
        if (parallel && parallelPath != null && !this.getParallel()) {
            this.createTextNode(parallelPath, "PARALLEL", "AUTOMATIC");
        } else if (!parallel && this.getParallel()) {
            if (this.nodeExists(parallelPath)) {
                this.removeNode(parallelPath);
            } else if (this.nodeExists(this.getParallelDegreePath())) {
                this.removeNode(this.getParallelDegreePath());
            }
        }
    }

    public int getDegree() {
        int degree = -1;
        String parallelPath = this.getParallelPath();
        String parallelDegDegPath = this.getParallelDegreeDegreePath();
        if (parallelPath == null || parallelDegDegPath == null) {
            return degree;
        }
        String degreeStr = null;
        if (this.nodeExists(parallelPath)) {
            degreeStr = this.selectTextValue(parallelPath);
        } else if (this.nodeExists(parallelDegDegPath)) {
            degreeStr = this.selectTextValue(parallelDegDegPath);
        }
        if (degreeStr != null) {
            if (degreeStr.equals("AUTOMATIC") || degreeStr.equals("DEFAULT")) {
                degree = -1;
            } else {
                try {
                    degree = Integer.parseInt(degreeStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return degree;
    }

    public void setDegree(int degree) {
        String parallelPath = this.getParallelPath();
        String parallelDegDegPath = this.getParallelDegreeDegreePath();
        if (parallelPath == null || parallelDegDegPath == null) {
            return;
        }
        if (this.getDegree() != degree) {
            if (degree == 0) {
                this.setParallel(false);
            } else if (degree == -1) {
                this.setDegreeDefault(true);
            } else {
                String pStr = null;
                try {
                    pStr = Integer.toString(degree);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (pStr != null) {
                    if (this.nodeExists(parallelPath)) {
                        this.setTextValue(parallelPath, pStr);
                    } else if (this.nodeExists(parallelDegDegPath)) {
                        this.setTextValue(parallelDegDegPath, pStr);
                    } else {
                        this.createTextNode(parallelPath, "PARALLEL", pStr);
                    }
                }
            }
        }
    }

    public boolean getDegreeDefault() {
        String parallelPath = this.getParallelPath();
        String parallelDegDegPath = this.getParallelDegreeDegreePath();
        if (parallelPath == null || parallelDegDegPath == null) {
            return false;
        }
        String parallel = this.selectTextValue(parallelPath);
        if (parallel != null && parallel.equals("AUTOMATIC")) {
            return true;
        }
        parallel = this.selectTextValue(parallelDegDegPath);
        return parallel != null && parallel.equals("DEFAULT");
    }

    public void setDegreeDefault(boolean def) {
        String parallelPath = this.getParallelPath();
        String parallelDegDegPath = this.getParallelDegreeDegreePath();
        if (parallelPath == null || parallelDegDegPath == null) {
            return;
        }
        if (def) {
            if (this.nodeExists(parallelPath)) {
                this.setTextValue(parallelPath, "AUTOMATIC");
            } else if (this.nodeExists(parallelDegDegPath)) {
                this.setTextValue(parallelDegDegPath, "DEFAULT");
            } else {
                this.setParallel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLDocument getSXMLDocFromDB(CMConnection dbConn, String mdapiType, String objSchema, String objName, boolean forDiffing) throws SQLException, XMLAccessorException {
        XMLDocument doc = super.getSXMLDocFromDB(dbConn, mdapiType, objSchema, objName, forDiffing);
        if (doc != null) {
            StringBuffer sb = null;
            if (forDiffing && this.isCommentableType() && this.includeComments()) {
                ResultSet rs = null;
                try {
                    rs = this.getCommentsForObject(dbConn, objSchema, objName);
                    while (rs.next()) {
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        String column = rs.getString(1);
                        String comment = rs.getString(2);
                        if (comment != null && comment.indexOf(38) >= 0) {
                            comment = comment.replaceAll("&", "&amp;");
                        }
                        sb.append("<").append(column == null ? "OBJECT_COMMENT" : "COLUMN_COMMENT");
                        if (column != null) {
                            sb.append(" ").append("NAME").append("=\"").append(column).append("\"><").append("COL_LIST_ITEM").append(">").append(column).append("</").append("COL_LIST_ITEM").append("><").append("COMMENT");
                        }
                        sb.append(">").append(comment).append("</");
                        if (column != null) {
                            sb.append("COMMENT").append(">").append("</").append("COLUMN_COMMENT");
                        } else {
                            sb.append("OBJECT_COMMENT");
                        }
                        sb.append(">");
                    }
                }
                finally {
                    CMConnection.close(this.m_commentsStmt, rs);
                }
                StringBuffer cBuff = new StringBuffer("<").append("COMMENTS").append(" xmlns=\"http://xmlns.oracle.com/ku\">");
                if (sb != null && sb.length() > 0) {
                    cBuff.append(sb);
                }
                cBuff.append("</").append("COMMENTS").append(">");
                String cString = cBuff.toString();
                try {
                    StringReader r = new StringReader(cString);
                    XMLDocument cDoc = (XMLDocument)CMXMLUtils.parseXMLDocument(r);
                    XMLNode cNode = XMLSchemaObjAccessor.getNode((XMLNode)cDoc, COMMENTS_PATH);
                    if (cNode != null) {
                        Node importedNode = doc.importNode((Node)cNode, true);
                        XMLNode root = XMLSchemaObjAccessor.getNode((XMLNode)doc, "/sxml:" + this.getTypePathElement());
                        root.appendChild(importedNode);
                    }
                }
                catch (ParserConfigurationException pce) {
                    pce.printStackTrace();
                }
                catch (SAXException saxe) {
                    saxe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return doc;
    }

    protected boolean includeComments() {
        return this.getAccessorClient() != null && (this.getAccessorClient().getTransformParamFlags(this.getObjType(), 3) & 0x4000000) != 0;
    }

    protected ResultSet getCommentsForObject(CMConnection dbConn, String objSchema, String objName) throws SQLException {
        String query = dbConn.canAccessDbaViews() ? s_getObjCommentsQuery_DBA : s_getObjCommentsQuery_ALL;
        this.m_commentsStmt = dbConn.prepareStatement(query);
        this.m_commentsStmt.setString(1, objSchema);
        this.m_commentsStmt.setString(2, objName);
        this.m_commentsStmt.setString(3, objSchema);
        this.m_commentsStmt.setString(4, objName);
        ResultSet rs = this.m_commentsStmt.executeQuery();
        return rs;
    }

    @Override
    public String toString() {
        return super.toString() + "  Schema: " + this.getSchema() + "\n";
    }
}

