/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLLOBColumnAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPartitionsAccessor
extends XMLAccessor {
    private static final int DATA_PART_ATTR_RANGE_PARTITION = 0;
    private static final int DATA_PART_ATTR_HASH_PARTITION = 1;
    private static final int DATA_PART_ATTR_LIST_PARTITION = 2;
    private static final int DATA_PART_ATTR_RANGE_HASH_PARTITION = 3;
    private static final int DATA_PART_ATTR_RANGE_LIST_PARTITION = 4;
    private static final int DATA_PART_ATTR_LOCAL_PARTITION = 5;
    private static final int DATA_PART_ATTR_GLOBAL_RANGE_PARTITION = 6;
    private static final int DATA_PART_ATTR_GLOBAL_HASH_PARTITION = 7;
    private static String HASH_PARTITIONING = "HASH_PARTITIONING";
    private static String LIST_PARTITIONING = "LIST_PARTITIONING";
    private static String RANGE_PARTITIONING = "RANGE_PARTITIONING";
    private static String HASH_SUBPARTITIONING = "HASH_SUBPARTITIONING";
    private static String LIST_SUBPARTITIONING = "LIST_SUBPARTITIONING";
    private static String GLOBAL_PARTITIONING = "GLOBAL_PARTITIONING";
    private static String LOCAL_PARTITIONING = "LOCAL_PARTITIONING";
    private static String TABLE = "TABLE";
    private static String INDEX = "INDEX";
    private static String TABLE_PROPERTIES = "TABLE_PROPERTIES";
    private static String X_TABLE_PARTITIONING = "(//sxml:" + TABLE_PROPERTIES + "/sxml:" + HASH_PARTITIONING + " | " + "//" + "sxml:" + TABLE_PROPERTIES + "/sxml:" + LIST_PARTITIONING + " | " + "//" + "sxml:" + TABLE_PROPERTIES + "/sxml:" + RANGE_PARTITIONING + ")";
    private static String X_INDEX_PARTITIONING = "(//sxml:GLOBAL_PARTITIONING | //sxml:LOCAL_PARTITIONING)";
    public static String X_COMP_BASE = "COMPARTITION_LIST/COMPARTITION_LIST_ITEM";
    public static String SX_COMP_BASE = "sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM";
    public static String X_PART_LIST_ITEM = "PART_LIST/PART_LIST_ITEM";
    public static String SX_PART_LIST_ITEM = "sxml:PARTITION_LIST/sxml:PARTITION_LIST_ITEM";
    private static String X_SUBPARTITION_LIST_ITEM = "sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM";
    private static String X_RANGE_PART_TBSP = "sxml:PHYSICAL_PROPERTIES/*/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE";
    private static String X_HASH_PART_TBSP = "sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE";
    private static String X_PART_OVERFLOW = "sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW";
    private static String X_PART_OVERFLOW_TBSP = X_PART_OVERFLOW + "/sxml:" + "SEGMENT_ATTRIBUTES" + "/sxml:" + "TABLESPACE";
    private static String X_PTN_STORAGE_TABLE = "sxml:COLUMN_PROPERTIES/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE";

    protected XMLPartitionsAccessor() {
    }

    protected XMLPartitionsAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void setXmlDoc(XMLNode xmlDoc) throws XMLAccessorException {
        XMLNode typeNode = XMLPartitionsAccessor.getNode(xmlDoc, "/sxml:TABLE");
        String path = null;
        if (typeNode != null) {
            path = X_TABLE_PARTITIONING;
        } else {
            typeNode = XMLPartitionsAccessor.getNode(xmlDoc, "/sxml:" + INDEX);
            if (typeNode != null) {
                path = X_INDEX_PARTITIONING;
            } else {
                System.out.println("Wrong object type for partitions.");
                return;
            }
        }
        NodeList nodes = XMLPartitionsAccessor.selectNodes(typeNode, path);
        if (nodes != null && nodes.getLength() > 0 && nodes.getLength() == 1) {
            this.setXmlNode((XMLNode)nodes.item(0));
        }
    }

    @Override
    protected String getTypePathElement() {
        return "PARTITION";
    }

    public int getPartitionType() {
        XMLElement xe = (XMLElement)this.getXmlNode();
        String partName = xe.getTagName();
        if (HASH_PARTITIONING.equals(partName)) {
            return 1;
        }
        if (LIST_PARTITIONING.equals(partName)) {
            return 2;
        }
        if (RANGE_PARTITIONING.equals(partName)) {
            if (this.nodeExists("sxml:" + HASH_SUBPARTITIONING)) {
                return 3;
            }
            if (this.nodeExists("sxml:" + LIST_SUBPARTITIONING)) {
                return 4;
            }
            return 0;
        }
        if (LOCAL_PARTITIONING.equals(partName)) {
            return 5;
        }
        if (GLOBAL_PARTITIONING.equals(partName)) {
            if (this.nodeExists("sxml:" + RANGE_PARTITIONING)) {
                return 6;
            }
            if (this.nodeExists("sxml:" + HASH_PARTITIONING)) {
                return 7;
            }
        }
        return -1;
    }

    public int getSubPartCount() {
        NodeList subparts = this.selectNodes("//sxml:SUBPARTITION_LIST_ITEM");
        if (subparts != null) {
            return subparts.getLength();
        }
        return 0;
    }

    public NodeList getPartitionColumns() {
        return this.selectNodes(X_COLUMN_LIST);
    }

    public NodeList getSubPartitionColumns() {
        XMLNode n = this.getSubPartTreeNode();
        if (n == null) {
            return null;
        }
        return XMLPartitionsAccessor.selectNodes(n, X_COLUMN_LIST);
    }

    private XMLNode getSubPartTreeNode() {
        XMLNode n = this.getNode("sxml:" + HASH_SUBPARTITIONING);
        if (n == null) {
            n = this.getNode("sxml:" + LIST_SUBPARTITIONING);
        }
        return n;
    }

    public NodeList getPartitions(int pType) {
        if (pType == 1 || pType == 2 || pType == 0 || pType == 3 || pType == 4 || pType == 5) {
            return this.getPartitions();
        }
        if (pType == 6) {
            return this.selectNodes("sxml:" + RANGE_PARTITIONING + "/" + SX_PART_LIST_ITEM);
        }
        if (pType == 7) {
            return this.selectNodes("sxml:" + HASH_PARTITIONING + "/" + SX_PART_LIST_ITEM);
        }
        return null;
    }

    public NodeList getPartitions() {
        return this.selectNodes(SX_PART_LIST_ITEM);
    }

    public XMLSegmentAccessor getSegmentForPartition(String partName) throws XMLAccessorException {
        XMLNode onePart = this.getPartitionByName(partName);
        XMLSegmentAccessor sa = null;
        if (onePart != null) {
            sa = new XMLSegmentAccessor(onePart, this.getAccessorClient());
        }
        return sa;
    }

    public XMLSegmentAccessor getSegmentForSubpartition(String subpartName) throws XMLAccessorException {
        return this.getSegmentForSubpartition(subpartName, null);
    }

    public XMLSegmentAccessor getSegmentForSubpartition(String subpartName, String owningPartName) throws XMLAccessorException {
        XMLNode subPartNode;
        block4: {
            block3: {
                subPartNode = null;
                if (owningPartName == null) break block3;
                XMLNode owningPart = this.getPartitionByName(owningPartName);
                if (owningPart == null) break block4;
                subPartNode = this.getSubpartition(owningPart, subpartName);
                break block4;
            }
            NodeList ptns = this.getPartitions(this.getPartitionType());
            if (ptns != null) {
                for (int i = 0; i < ptns.getLength(); ++i) {
                    Node ptn = ptns.item(i);
                    XMLNode subPtn = this.getSubpartition((XMLNode)ptn, subpartName);
                    if (subPtn == null) continue;
                    subPartNode = subPtn;
                    break;
                }
            }
        }
        if (subPartNode != null) {
            return new XMLSegmentAccessor(subPartNode, this.getAccessorClient());
        }
        return null;
    }

    public XMLSegmentAccessor getSegmentForPartitionOverflow(String partName) throws XMLAccessorException {
        XMLNode ptn = this.getPartitionByName(partName);
        if (ptn != null) {
            return new XMLSegmentAccessor(ptn, this.getAccessorClient(), true);
        }
        return null;
    }

    public XMLLOBColumnAccessor getLOBColumnPartition(String partName, String colName) throws XMLAccessorException {
        XMLNode stgTblNode;
        XMLLOBColumnAccessor lcAcc = null;
        XMLNode ptn = this.getPartitionByName(partName);
        if (ptn != null && (stgTblNode = XMLPartitionsAccessor.getNode(ptn, X_PTN_STORAGE_TABLE)) != null) {
            lcAcc = new XMLLOBColumnAccessor(stgTblNode, this.getAccessorClient());
        }
        return lcAcc;
    }

    protected XMLNode getPartitionByName(String partName) {
        XMLNode thePtn = null;
        NodeList ptns = this.getPartitions(this.getPartitionType());
        if (ptns != null) {
            for (int i = 0; i < ptns.getLength(); ++i) {
                Node ptn = ptns.item(i);
                if (!partName.equals(XMLPartitionsAccessor.getOnePartName(ptn))) continue;
                thePtn = (XMLNode)ptn;
                break;
            }
        }
        return thePtn;
    }

    protected XMLNode getSubpartition(XMLNode owningPart, String subpartName) {
        XMLNode subpart = null;
        NodeList subParts = this.getSubPartitions((Node)owningPart);
        if (subParts != null) {
            for (int i = 0; i < subParts.getLength(); ++i) {
                Node ptn = subParts.item(i);
                if (!subpartName.equals(XMLPartitionsAccessor.getOnePartName(ptn))) continue;
                subpart = (XMLNode)ptn;
                break;
            }
        }
        return subpart;
    }

    public NodeList getSubPartitions(Node onePart) {
        if (onePart == null) {
            return null;
        }
        return XMLPartitionsAccessor.selectNodes((XMLNode)onePart, X_SUBPARTITION_LIST_ITEM);
    }

    public static String getPartColumnName(Node col) {
        return XMLPartitionsAccessor.getItemName(col);
    }

    public static String getOnePartName(Node onePart) {
        return XMLPartitionsAccessor.getItemName(onePart);
    }

    public String getCompartTbsp() {
        return this.selectTextValue("sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:TABLESPACE");
    }

    public static String getOnePartTbsp(Node onePart) {
        if (XMLPartitionsAccessor.nodeExists((XMLNode)onePart, X_RANGE_PART_TBSP)) {
            return XMLPartitionsAccessor.selectTextValue((XMLNode)onePart, X_RANGE_PART_TBSP);
        }
        return XMLPartitionsAccessor.selectTextValue((XMLNode)onePart, X_HASH_PART_TBSP);
    }

    public static String getOnePartOverflowTbsp(Node onePart) {
        return XMLPartitionsAccessor.getItemOverflowTbsp(onePart);
    }

    public static String getOnePartHighValue(Node onePart) {
        return XMLPartitionsAccessor.getItemHighValue(onePart);
    }

    public String getSubPartColumnName(Node oneSubCol) {
        return XMLPartitionsAccessor.getItemName(oneSubCol);
    }

    public static String getOneSubPartName(Node oneSubPart) {
        return XMLPartitionsAccessor.getItemName(oneSubPart);
    }

    public static String getOneSubPartHighValue(Node oneSubPart) {
        return XMLPartitionsAccessor.getItemHighValue(oneSubPart);
    }

    public static String getOneSubPartTbsp(Node oneSubPart) {
        return XMLPartitionsAccessor.selectTextValue((XMLNode)oneSubPart, "sxml:TABLESPACE");
    }

    private static String getItemOverflowTbsp(Node n) {
        return XMLPartitionsAccessor.selectTextValue((XMLNode)n, X_PART_OVERFLOW_TBSP);
    }

    private static String getItemHighValue(Node n) {
        return XMLPartitionsAccessor.selectTextValue((XMLNode)n, "sxml:VALUES");
    }

    private static String getItemName(Node n) {
        return XMLPartitionsAccessor.selectTextValue((XMLNode)n, "sxml:NAME");
    }

    private static String getItemStatus(Node n) {
        return XMLPartitionsAccessor.selectTextValue((XMLNode)n, "STATUS");
    }

    public boolean getIsLocalPartitioning() {
        XMLElement xe = (XMLElement)this.getXmlNode();
        String partName = xe.getTagName();
        return "LOCAL_PARTITIONING".equals(partName);
    }

    public int getIndexPartitionType() {
        XMLElement xe = (XMLElement)this.getXmlNode();
        String partName = xe.getTagName();
        if ("GLOBAL_PARTITIONING".equals(partName)) {
            if (this.nodeExists("sxml:" + RANGE_PARTITIONING)) {
                return 6;
            }
            if (this.nodeExists("sxml:" + HASH_PARTITIONING)) {
                return 7;
            }
        } else if ("LOCAL_PARTITIONING".equals(partName)) {
            return 5;
        }
        return -1;
    }

    public int getIndexSubpartitionType() {
        if (this.nodeExists("sxml:" + HASH_SUBPARTITIONING)) {
            return 3;
        }
        if (this.nodeExists("sxml:" + LIST_SUBPARTITIONING)) {
            return 4;
        }
        return -1;
    }

    public int getLocalPartitionObjectPartitionType() {
        String partName = null;
        try {
            partName = CMXMLUtils.selectTextValue(this.getXmlNode(), "PARTTYPE");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ("HASH_PARTITIONING".equals(partName)) {
            return 1;
        }
        if ("RANGE_PARTITIONING".equals(partName)) {
            return 0;
        }
        if ("LIST_PARTITIONING".equals(partName)) {
            return 2;
        }
        return -1;
    }

    public static String getOnePartStatus(Node onePart) {
        return XMLPartitionsAccessor.getItemStatus(onePart);
    }

    @Override
    public String toString() {
        int i;
        StringBuffer ptns = new StringBuffer();
        int pType = this.getPartitionType();
        switch (pType) {
            case 1: {
                ptns.append("Hash partitioning\n");
                break;
            }
            case 2: {
                ptns.append("List partitioning\n");
                break;
            }
            case 0: {
                ptns.append("Range partitioning\n");
                break;
            }
            case 3: {
                ptns.append("Range - Hash composite partitioning, ");
                ptns.append("subpartition count: ").append(this.getSubPartCount()).append("\n");
                break;
            }
            case 4: {
                ptns.append("Range - List composite partitioning, ");
                ptns.append("subpartition count: ").append(this.getSubPartCount()).append("\n");
                break;
            }
            case 5: {
                ptns.append("Local partitioning");
                int spCnt = this.getSubPartCount();
                if (spCnt > 0) {
                    ptns.append(", subpartition count: ").append(spCnt);
                }
                ptns.append("\n");
                break;
            }
            case 6: {
                ptns.append("Global range partitioning\n");
                break;
            }
            case 7: {
                ptns.append("Global hash partitioning\n");
                break;
            }
            default: {
                ptns.append("Unknown partitioning type: ").append(pType).append("\n");
            }
        }
        ptns.append("   Columns: ");
        NodeList pCols = this.getPartitionColumns();
        if (pCols != null && pCols.getLength() > 0) {
            boolean first = true;
            for (i = 0; i < pCols.getLength(); ++i) {
                Node col = pCols.item(i);
                if (!first) {
                    ptns.append(", ");
                }
                ptns.append(XMLPartitionsAccessor.getPartColumnName(col));
                first = false;
            }
            ptns.append("\n");
        } else {
            ptns.append("None.\n");
        }
        ptns.append("   Partitions:\n");
        NodeList pList = this.getPartitions(pType);
        if (pList != null && pList.getLength() > 0) {
            for (i = 0; i < pList.getLength(); ++i) {
                NodeList subparts;
                Node ptn = pList.item(i);
                ptns.append("    ").append(XMLPartitionsAccessor.getOnePartName(ptn)).append("\n");
                if (pType == 0 || pType == 4 || pType == 3) {
                    ptns.append("     High value: ").append(XMLPartitionsAccessor.getOnePartHighValue(ptn)).append("\n");
                }
                boolean hasSubparts = false;
                if ((pType == 4 || pType == 3 || pType == 5) && (subparts = this.getSubPartitions(ptn)) != null && subparts.getLength() > 0) {
                    ptns.append("     Subpartitions:\n");
                    for (int j = 0; j < subparts.getLength(); ++j) {
                        Node sptn = subparts.item(j);
                        XMLSegmentAccessor sa = null;
                        try {
                            sa = new XMLSegmentAccessor((XMLNode)sptn, this.getAccessorClient());
                        }
                        catch (XMLAccessorException xae) {
                            System.out.println("Caught XMLAccessorException while getting SegmentAccessor for subpartition: " + xae.getMessage());
                        }
                        String attrs = "Not found.";
                        if (sa != null) {
                            attrs = sa.getAttrs("     ");
                        }
                        ptns.append("      ").append(XMLPartitionsAccessor.getOneSubPartName(sptn)).append("\n").append("       Segment attributes: \n").append(attrs);
                    }
                    hasSubparts = true;
                }
                if (hasSubparts) continue;
                XMLSegmentAccessor sa = null;
                try {
                    sa = new XMLSegmentAccessor((XMLNode)ptn, this.getAccessorClient());
                }
                catch (XMLAccessorException xae) {
                    System.out.println("Caught XMLAccessorException while getting SegmentAccessor for partition: " + xae.getMessage());
                }
                if (sa != null) {
                    String attrs = sa.getAttrs("   ");
                    ptns.append("     Segment attributes: \n").append(attrs);
                }
                if (!XMLPartitionsAccessor.nodeExists((XMLNode)ptn, X_PART_OVERFLOW)) continue;
                try {
                    sa = new XMLSegmentAccessor((XMLNode)ptn, this.getAccessorClient(), true);
                }
                catch (XMLAccessorException xae) {
                    System.out.println("Caught XMLAccessorException while getting SegmentAccessor for partition: " + xae.getMessage());
                }
                if (sa == null) continue;
                String attrs = sa.getAttrs("   ");
                ptns.append("     Overflow segment attributes: \n").append(attrs);
            }
        } else {
            ptns.append("None.\n");
        }
        return ptns.toString();
    }
}

