/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.DiffClasses;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiffClassifier
implements DiffClasses {
    private static final int NO_DIFF_TYPE = 0;
    private static final int EXISTENCE = 1;
    private static final int VALUE = 2;
    private static final long INDETERMINATE = Long.MAX_VALUE;
    private static final HashMap<String, TagHit> s_tagHitMap = new HashMap();
    private static final String[] s_classNames = new String[34];
    private PrintStream m_debugStream = null;
    private boolean m_verbose = false;
    private int m_dcFilter = -1;
    private String m_side1Label = "Right";
    private String m_side2Label = "Left";

    public void setDebugOutput(OutputStream os) {
        this.m_debugStream = os != null ? new PrintStream(os) : null;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setDiffClassFilter(int dcFilter) {
        this.m_dcFilter = dcFilter;
    }

    public void setRightSideLabel(String label) {
        this.m_side1Label = label;
    }

    public void setLeftSideLabel(String label) {
        this.m_side2Label = label;
    }

    public String getOneClassName(long theClass) {
        String name = null;
        for (int i = 0; i < 34; ++i) {
            if ((1L << i & theClass) == 0L) continue;
            name = s_classNames[i];
            break;
        }
        return name;
    }

    public Vector<String> getClassNames(long classes) {
        Vector<String> classNames = new Vector<String>();
        for (int i = 0; i < 34; ++i) {
            if ((1L << i & classes) == 0L) continue;
            classNames.addElement(s_classNames[i]);
        }
        return classNames;
    }

    public long classify(int objType, XMLDocument diffDoc) throws XMLAccessorException {
        return this.classify(objType, diffDoc, null);
    }

    public long classify(int objType, XMLDocument diffDoc, StringBuffer diffDetails) throws XMLAccessorException {
        long classes = 0L;
        if (XMLAccessor.sxmlSupported(objType)) {
            int numDiffs;
            NodeList diffs = CMXMLUtils.selectNodes((XMLNode)diffDoc, "(//*[@src='1' and not (@no_diff)] | //*[@src='2' and not (@no_diff)] | //*[@value1 and not (@no_diff)])");
            if (diffs != null && (numDiffs = diffs.getLength()) > 0) {
                for (int i = 0; i < numDiffs; ++i) {
                    XMLElement diffNode = (XMLElement)diffs.item(i);
                    long theClass = this.classifyOneDiff(objType, diffNode);
                    if (theClass == 65536L) {
                        if ((classes & 0x10000L) != 0L) {
                            classes &= 0xFFFFFFFFFFFEFFFFL;
                            classes |= 0x20000L;
                        } else {
                            classes |= theClass;
                        }
                    } else {
                        classes |= theClass;
                    }
                    if (diffDetails == null) continue;
                    this.formatDiff(theClass, diffNode, diffDetails);
                }
            }
        } else if (objType == 8 || objType == 7 || objType == 5 || objType == 6 || objType == 19) {
            classes = 0x400000L;
            if (diffDetails != null) {
                this.formatNonSXMLDiff(diffDoc, diffDetails);
            }
        } else {
            throw new XMLAccessorException("Unable to classify object of type " + XMLAccessor.intTypeToMDAPIType(objType));
        }
        return classes;
    }

    private long classifyOneDiff(int objType, XMLElement diffNode) throws XMLAccessorException {
        XMLElement node;
        long theClass = 0x200000000L;
        int diffType = this.getDiffType(diffNode);
        String tagName = null;
        TagHit th = null;
        for (node = diffNode; node != null && (th = s_tagHitMap.get(tagName = node.getNodeName())) == null; node = (XMLNode)node.getParentNode()) {
            diffType = 2;
        }
        while (th != null) {
            theClass = th.getDiffClass(diffType);
            if (theClass != Long.MAX_VALUE) {
                if (!this.m_verbose || this.m_debugStream == null) break;
                this.m_debugStream.println("Matched on <" + tagName + "> for diff node: " + diffNode.getAttribute("xpath"));
                break;
            }
            String tagHitName = tagName;
            HashMap parentMap = th.getParentTags();
            if (parentMap != null) {
                while ((node = (XMLNode)node.getParentNode()) != null && (th = (TagHit)parentMap.get(tagName = node.getNodeName())) == null) {
                }
                if (theClass != Long.MAX_VALUE) continue;
                theClass = 0x200000000L;
                continue;
            }
            throw new XMLAccessorException("TagHit for <" + tagName + "> has no parent map.");
        }
        if (th == null && this.m_debugStream != null) {
            this.m_debugStream.println("Terminated with null TagHit: " + diffNode.getAttribute("xpath"));
        }
        if (theClass == 0x1000000L && diffType == 1) {
            theClass = this.doOneSideTabPropsNode(diffNode);
        }
        if (this.m_debugStream != null) {
            if (theClass == 0x200000000L) {
                this.m_debugStream.println("Unable to classify diff node: " + diffNode.getAttribute("xpath"));
            } else if (this.m_verbose) {
                this.m_debugStream.println("Classified as: " + this.getOneClassName(theClass));
            }
            this.m_debugStream.println("");
        }
        return theClass;
    }

    private int getDiffType(XMLElement diffNode) {
        if (diffNode.hasAttribute("src")) {
            return 1;
        }
        if (diffNode.hasAttribute("value1")) {
            return 2;
        }
        return 0;
    }

    private long doOneSideTabPropsNode(XMLElement diffNode) {
        long newClass = 0L;
        NodeList children = diffNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (this.m_verbose && this.m_debugStream != null) {
                this.m_debugStream.println("doOneSideTabPropsNode: Checking TABLE_PROPERTIES child: " + childName);
            }
            if (childName.equals("RANGE_PARTITIONING") || childName.equals("HASH_PARTITIONING") || childName.equals("LIST_PARTITIONING") || childName.equals("REFERENCE_PARTITIONING") || childName.equals("SYSTEM_PARTITIONING")) {
                newClass |= 0x10000L;
                continue;
            }
            if (childName.equals("COLUMN_PROPERTIES")) {
                newClass |= 0x2000000L;
                continue;
            }
            newClass |= 0x1000000L;
        }
        return newClass;
    }

    private void formatDiff(long theClass, XMLElement diffNode, StringBuffer diffDetails) {
        String srcSide;
        int diffType = this.getDiffType(diffNode);
        String diffTypeName = null;
        diffTypeName = diffType == 1 ? ("1".equals(srcSide = diffNode.getAttribute("src")) ? this.m_side1Label + "-side only " : this.m_side2Label + "-side only ") : "Attribute value ";
        String className = this.getOneClassName(theClass);
        diffDetails.append(diffTypeName).append(className).append(" difference:\n");
        if (diffType == 2) {
            String side1Val = diffNode.getAttribute("value1");
            String side2Val = CMXMLUtils.selectTextValue((XMLNode)diffNode, ".");
            diffDetails.append(" ").append(this.m_side2Label).append("-side value: ").append(side2Val).append("\n ").append(this.m_side1Label).append("-side value: ").append(side1Val).append("\n");
        }
        String xpath = diffNode.getAttribute("xpath");
        String context = "**unavailable**";
        if (xpath != null) {
            context = xpath.replaceAll("sxml:", "");
        }
        diffDetails.append(" Context: ").append(context).append("\n");
    }

    private void formatNonSXMLDiff(XMLDocument diffDoc, StringBuffer diffDetails) {
        NodeList ddls = diffDoc.getElementsByTagName("MDAPIDDL");
        if (ddls != null && ddls.getLength() >= 2) {
            Node ddlNode = ddls.item(0);
            XMLText ddlCdata = (XMLText)ddlNode.getChildNodes().item(0);
            String leftDDL = ddlCdata.getData();
            ddlNode = ddls.item(1);
            ddlCdata = (XMLText)ddlNode.getChildNodes().item(0);
            String rightDDL = ddlCdata.getData();
            diffDetails.append(this.m_side2Label).append(" DDL:\n").append(leftDDL).append("\n").append(this.m_side1Label).append(" DDL:\n").append(rightDDL);
        }
    }

    static {
        HashMap<String, TagHit> parentMap = null;
        HashMap<String, TagHit> subMap = null;
        TagHit subTagHit = null;
        parentMap = new HashMap<String, TagHit>();
        parentMap.put("INDEX", new TagHit(2048L));
        s_tagHitMap.put("BITMAP", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        parentMap.put("COLUMN_PROPERTIES", new TagHit(0x2000000L));
        s_tagHitMap.put("CACHE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("CALL_PROCEDURE", new TagHit(1, 0x400000L, 0x400000L, null));
        s_tagHitMap.put("CHECK_CONSTRAINT_LIST", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("CHECK_CONSTRAINT_LIST_ITEM", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("CLUSTER_TABLE", new TagHit(1, 16384L, 16384L, null));
        parentMap = new HashMap();
        parentMap.put("PRIMARY_KEY_CONSTRAINT_LIST_ITEM", new TagHit(32L));
        parentMap.put("UNIQUE_KEY_CONSTRAINT_LIST_ITEM", new TagHit(32L));
        parentMap.put("FOREIGN_KEY_CONSTRAINT_LIST_ITEM", new TagHit(32L));
        parentMap.put("TABLE_INDEX", new TagHit(1024L));
        parentMap.put("BITMAP_JOIN_INDEX", new TagHit(1024L));
        s_tagHitMap.put("COL_LIST", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("RELATIONAL_TABLE", new TagHit(1L));
        parentMap.put("VIEW", new TagHit(1L));
        parentMap.put("TABLE_INDEX", new TagHit(1024L));
        parentMap.put("COLUMN_PROPERTIES", new TagHit(0x2000000L));
        s_tagHitMap.put("COL_LIST_ITEM", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("COL_NUM", new TagHit(1, 0x80000000L, 0x80000000L, null));
        s_tagHitMap.put("COMMENTS", new TagHit(1, 32768L, 32768L, null));
        parentMap = new HashMap();
        parentMap.put("CHECK_CONSTRAINT_LIST_ITEM", new TagHit(32L));
        s_tagHitMap.put("CONDITION", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        s_tagHitMap.put("CYCLE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("DATABASE_EVENT", new TagHit(1, 0x200000L, 0x200000L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(2L));
        s_tagHitMap.put("DATATYPE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("DDL_EVENT", new TagHit(1, 0x200000L, 0x200000L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(8L));
        s_tagHitMap.put("DEFAULT", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("DEFERRABLE", new TagHit(1, 128L, 128L, null));
        parentMap = new HashMap();
        parentMap.put("CHECK_CONSTRAINT_LIST_ITEM", new TagHit(128L));
        parentMap.put("PRIMARY_KEY_CONSTRAINT_LIST_ITEM", new TagHit(128L));
        parentMap.put("UNIQUE_KEY_CONSTRAINT_LIST_ITEM", new TagHit(128L));
        parentMap.put("FOREIGN_KEY_CONSTRAINT_LIST_ITEM", new TagHit(128L));
        parentMap.put("SCOPE_CONSTRAINT_LIST_ITEM", new TagHit(128L));
        s_tagHitMap.put("DISABLE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("DML_EVENT", new TagHit(1, 0x200000L, 0x200000L, null));
        s_tagHitMap.put("EXTERNAL_TABLE", new TagHit(1, 16384L, 16384L, null));
        s_tagHitMap.put("FOREIGN_KEY_CONSTRAINT_LIST", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("FOREIGN_KEY_CONSTRAINT_LIST_ITEM", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("GLOBAL_PARTITIONING", new TagHit(1, 65536L, 65536L, null));
        parentMap = new HashMap();
        parentMap.put("TABLE_PROPERTIES", new TagHit(65536L));
        parentMap.put("RANGE_PARTITIONING", new TagHit(131072L));
        parentMap.put("GLOBAL_PARTITIONING", new TagHit(131072L));
        s_tagHitMap.put("HASH_PARTITIONING", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("HEAP_TABLE", new TagHit(1, 16384L, 16384L, null));
        s_tagHitMap.put("INCREMENT", new TagHit(1, 0x40000000L, 0x40000000L, null));
        s_tagHitMap.put("INDEX_ORGANIZED_TABLE", new TagHit(1, 16384L, 16384L, null));
        s_tagHitMap.put("INITIALLY_DEFERRED", new TagHit(1, 128L, 128L, null));
        s_tagHitMap.put("INITRANS", new TagHit(1, 8192L, 8192L, null));
        s_tagHitMap.put("JOIN_TABLE_LIST", new TagHit(1, 512L, 512L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(2L));
        s_tagHitMap.put("LENGTH", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("TABLE_PROPERTIES", new TagHit(65536L));
        parentMap.put("RANGE_PARTITIONING", new TagHit(131072L));
        s_tagHitMap.put("LIST_PARTITIONING", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("LOCAL_PARTITIONING", new TagHit(1, 65536L, 65536L, null));
        s_tagHitMap.put("LOGGING", new TagHit(1, 0x800000L, 0x800000L, null));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        s_tagHitMap.put("MAXVALUE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        s_tagHitMap.put("MINVALUE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("CHECK_CONSTRAINT_LIST_ITEM", new TagHit(64L));
        parentMap.put("PRIMARY_KEY_CONSTRAINT_LIST_ITEM", new TagHit(64L));
        parentMap.put("UNIQUE_KEY_CONSTRAINT_LIST_ITEM", new TagHit(64L));
        parentMap.put("FOREIGN_KEY_CONSTRAINT_LIST_ITEM", new TagHit(64L));
        parentMap.put("SCOPE_CONSTRAINT_LIST_ITEM", new TagHit(64L));
        parentMap.put("ON_CLUSTER", new TagHit(512L));
        parentMap.put("JOIN_TABLE_LIST", new TagHit(512L));
        parentMap.put("ON_TABLE", new TagHit(512L));
        parentMap.put("OBJECT_PRIV_GRANT_LIST_ITEM", new TagHit(0x100000000L));
        parentMap.put("ROLE_GRANT_LIST_ITEM", new TagHit(0x100000000L));
        parentMap.put("SYSTEM_PRIV_GRANT_LIST_ITEM", new TagHit(0x100000000L));
        subMap = new HashMap<String, TagHit>();
        subMap.put("TABLE_INDEX", new TagHit(1024L));
        subMap.put("RELATIONAL_TABLE", new TagHit(0x20000000L));
        subMap.put("VIEW", new TagHit(0x20000000L));
        subTagHit = new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, subMap);
        parentMap.put("COL_LIST", subTagHit);
        s_tagHitMap.put("NAME", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("NEVER_REFRESH", new TagHit(1, 0x10000000L, 0x10000000L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(32L));
        s_tagHitMap.put("NOT_NULL", new TagHit(2, 4L, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("NOVALIDATE", new TagHit(1, 128L, 128L, null));
        s_tagHitMap.put("OBJECT_PRIV_GRANT_LIST", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("OBJECT_PRIV_GRANT_LIST_ITEM", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("ON_CLUSTER", new TagHit(1, 512L, 512L, null));
        s_tagHitMap.put("ON_TABLE", new TagHit(1, 512L, 512L, null));
        s_tagHitMap.put("ON_PREBUILT_TABLE", new TagHit(1, 512L, 512L, null));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        s_tagHitMap.put("ORDER", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("PARSED_CONDITION", new TagHit(1, 32L, 32L, null));
        s_tagHitMap.put("PARSED_SUBQUERY", new TagHit(1, 0x8000000L, 0x8000000L, null));
        s_tagHitMap.put("PARTITION_LIST_ITEM", new TagHit(2, 262144L, 524288L, null));
        s_tagHitMap.put("PCTFREE", new TagHit(1, 8192L, 8192L, null));
        s_tagHitMap.put("PCTUSED", new TagHit(1, 8192L, 8192L, null));
        s_tagHitMap.put("PHYSICAL_PROPERTIES", new TagHit(1, 0x4000000L, 0x4000000L, null));
        s_tagHitMap.put("PLSQL_BLOCK", new TagHit(1, 0x400000L, 0x400000L, null));
        s_tagHitMap.put("PRECISION", new TagHit(1, 2L, 2L, null));
        s_tagHitMap.put("PRIMARY_KEY_CONSTRAINT_LIST", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("PRIMARY_KEY_CONSTRAINT_LIST_ITEM", new TagHit(1, 16L, 16L, null));
        parentMap = new HashMap();
        parentMap.put("TABLE_PROPERTIES", new TagHit(65536L));
        parentMap.put("RANGE_PARTITIONING", new TagHit(131072L));
        parentMap.put("GLOBAL_PARTITIONING", new TagHit(131072L));
        s_tagHitMap.put("RANGE_PARTITIONING", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("REFERENCES", new TagHit(1, 32L, 32L, null));
        s_tagHitMap.put("REFRESH", new TagHit(1, 0x10000000L, 0x10000000L, null));
        s_tagHitMap.put("RELY", new TagHit(1, 128L, 128L, null));
        s_tagHitMap.put("ROLE_GRANT_LIST", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("ROLE_GRANT_LIST_ITEM", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("SCALE", new TagHit(1, 2L, 2L, null));
        parentMap = new HashMap();
        parentMap.put("ON_CLUSTER", new TagHit(512L));
        parentMap.put("JOIN_TABLE_LIST", new TagHit(512L));
        parentMap.put("ON_TABLE", new TagHit(512L));
        parentMap.put("COL_LIST_ITEM", new TagHit(2L));
        s_tagHitMap.put("SCHEMA", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("SCOPE_CONSTRAINT", new TagHit(1, 32L, 32L, null));
        s_tagHitMap.put("SCOPE_CONSTRAINT_LIST", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("SCOPE_CONSTRAINT_LIST_ITEM", new TagHit(1, 16L, 16L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(2L));
        s_tagHitMap.put("SORT", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        parentMap = new HashMap();
        parentMap.put("SEQUENCE", new TagHit(0x40000000L));
        s_tagHitMap.put("START_WITH", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("STORAGE", new TagHit(1, 8192L, 8192L, null));
        s_tagHitMap.put("SUBQUERY", new TagHit(1, 0x8000000L, 0x8000000L, null));
        s_tagHitMap.put("SYSTEM_PRIV_GRANT_LIST", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("SYSTEM_PRIV_GRANT_LIST_ITEM", new TagHit(1, 0x100000000L, 0x100000000L, null));
        s_tagHitMap.put("TABLESPACE", new TagHit(1, 4096L, 4096L, null));
        s_tagHitMap.put("TABLE_PROPERTIES", new TagHit(1, 0x1000000L, 0x1000000L, null));
        s_tagHitMap.put("TRIGGER_TYPE", new TagHit(1, 0x100000L, 0x100000L, null));
        parentMap = new HashMap();
        parentMap.put("COL_LIST_ITEM", new TagHit(2L));
        s_tagHitMap.put("TYPE_PROPERTIES", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("UNIQUE_KEY_CONSTRAINT_LIST", new TagHit(1, 16L, 16L, null));
        s_tagHitMap.put("UNIQUE_KEY_CONSTRAINT_LIST_ITEM", new TagHit(1, 16L, 16L, null));
        parentMap = new HashMap();
        parentMap.put("INDEX", new TagHit(2048L));
        s_tagHitMap.put("UNIQUE", new TagHit(3, Long.MAX_VALUE, Long.MAX_VALUE, parentMap));
        s_tagHitMap.put("USING_INDEX", new TagHit(1, 256L, 256L, null));
        DiffClassifier.s_classNames[0] = "Column Existence";
        DiffClassifier.s_classNames[1] = "Column Datatype";
        DiffClassifier.s_classNames[2] = "Column Not Null";
        DiffClassifier.s_classNames[3] = "Column Default Value";
        DiffClassifier.s_classNames[4] = "Constraint Existence";
        DiffClassifier.s_classNames[5] = "Constraint Definition";
        DiffClassifier.s_classNames[6] = "Constraint Name";
        DiffClassifier.s_classNames[7] = "Constraint Attributes";
        DiffClassifier.s_classNames[8] = "Constraint Index";
        DiffClassifier.s_classNames[9] = "On Object";
        DiffClassifier.s_classNames[10] = "Index Column List";
        DiffClassifier.s_classNames[11] = "Index Type";
        DiffClassifier.s_classNames[12] = "Tablespace";
        DiffClassifier.s_classNames[13] = "Physical Attributes";
        DiffClassifier.s_classNames[14] = "Table Organization";
        DiffClassifier.s_classNames[15] = "Comments";
        DiffClassifier.s_classNames[16] = "Partitioned";
        DiffClassifier.s_classNames[17] = "Partitioning Type";
        DiffClassifier.s_classNames[18] = "Number of Partitions";
        DiffClassifier.s_classNames[19] = "Partition Definition";
        DiffClassifier.s_classNames[20] = "Trigger Type";
        DiffClassifier.s_classNames[21] = "Trigger Event";
        DiffClassifier.s_classNames[22] = "PL/SQL Body";
        DiffClassifier.s_classNames[23] = "Logging";
        DiffClassifier.s_classNames[24] = "Table Properties";
        DiffClassifier.s_classNames[25] = "Column Properties";
        DiffClassifier.s_classNames[26] = "Physical Properties";
        DiffClassifier.s_classNames[27] = "Subquery";
        DiffClassifier.s_classNames[28] = "Refresh";
        DiffClassifier.s_classNames[29] = "Column Name";
        DiffClassifier.s_classNames[30] = "Sequence Attributes";
        DiffClassifier.s_classNames[31] = "Column Number";
        DiffClassifier.s_classNames[33] = "Unclassified";
    }

    private static class TagHit {
        private static final int UNAMBIGUOUS = 1;
        private static final int DIFFTYPE_DEPENDENT = 2;
        private static final int PARENT_DEPENDENT = 3;
        private int m_hitType;
        private long m_existenceClass;
        private long m_valueClass;
        private HashMap<String, TagHit> m_parentTags;

        private TagHit(int hitType, long existenceClass, long valueClass, HashMap<String, TagHit> parentTags) {
            this.m_hitType = hitType;
            this.m_existenceClass = existenceClass;
            this.m_valueClass = valueClass;
            this.m_parentTags = parentTags;
        }

        private TagHit(long theClass) {
            this.m_valueClass = theClass;
            this.m_hitType = 1;
        }

        private int getHitType() {
            return this.m_hitType;
        }

        private HashMap<String, TagHit> getParentTags() {
            return this.m_parentTags;
        }

        private long getDiffClass(int diffType) {
            if (this.m_hitType == 1) {
                return this.m_valueClass;
            }
            if (this.m_hitType == 2) {
                if (diffType == 1) {
                    return this.m_existenceClass;
                }
                return this.m_valueClass;
            }
            return Long.MAX_VALUE;
        }
    }
}

