/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXSLTransformInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.apache.log4j.Category;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DDLUtils {
    public static final int SIDE_1 = 1;
    public static final int SIDE_2 = 2;
    private static String X_ALL_DIFF_NODES = "(//*[@src] | //*[@value1])";
    private static String X_ALL_CMXML_DIFF_NODES = "//*[@DIFF";
    private static String X_SOURCE_NODES = "//SOURCE";
    private static final Category s_log = Category.getInstance(DDLUtils.class);

    public static boolean sxmlSupported(int objType) {
        boolean supported = true;
        switch (objType) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: {
                supported = false;
            }
        }
        return supported;
    }

    public static void prepDiffDocForCreateDDL(XMLNode diffDoc, int useSide) {
        block28: {
            XMLNode mNode;
            NodeList nodesToModify;
            block26: {
                block27: {
                    NodeList nodesToReplace;
                    block25: {
                        block24: {
                            NodeList nodesToRemove;
                            String otherPattern;
                            block23: {
                                String pattern = null;
                                otherPattern = null;
                                if (useSide == 2) {
                                    pattern = "//*[@src='1']";
                                    otherPattern = "//*[@src='2']";
                                } else if (useSide == 1) {
                                    pattern = "//*[@src='2']";
                                    otherPattern = "//*[@src='1']";
                                }
                                nodesToRemove = null;
                                try {
                                    nodesToRemove = diffDoc.selectNodes(pattern, (NSResolver)CMXMLUtils.getSXMLResolver());
                                }
                                catch (XSLException xe) {
                                    if (!s_log.isDebugEnabled()) break block23;
                                    s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                                }
                            }
                            if (nodesToRemove != null && nodesToRemove.getLength() > 0) {
                                for (int i = 0; i < nodesToRemove.getLength(); ++i) {
                                    XMLNode rNode = (XMLNode)nodesToRemove.item(i);
                                    XMLNode rParent = (XMLNode)rNode.getParentNode();
                                    try {
                                        rParent.removeChild((Node)rNode);
                                        continue;
                                    }
                                    catch (DOMException de) {
                                        if (!s_log.isDebugEnabled()) continue;
                                        s_log.debug((Object)"Caught DOMException\n", (Throwable)de);
                                    }
                                }
                            }
                            nodesToModify = null;
                            try {
                                nodesToModify = diffDoc.selectNodes(otherPattern, (NSResolver)CMXMLUtils.getSXMLResolver());
                            }
                            catch (XSLException xe) {
                                if (!s_log.isDebugEnabled()) break block24;
                                s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                            }
                        }
                        if (nodesToModify != null && nodesToModify.getLength() > 0) {
                            for (int i = 0; i < nodesToModify.getLength(); ++i) {
                                mNode = (XMLNode)nodesToModify.item(i);
                                mNode.getAttributes().removeNamedItem("src");
                            }
                        }
                        if (useSide != 1) break block27;
                        nodesToReplace = null;
                        try {
                            nodesToReplace = diffDoc.selectNodes("//*[@value1]", (NSResolver)CMXMLUtils.getSXMLResolver());
                        }
                        catch (XSLException xe) {
                            if (!s_log.isDebugEnabled()) break block25;
                            s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                        }
                    }
                    if (nodesToReplace == null || nodesToReplace.getLength() <= 0) break block28;
                    for (int i = 0; i < nodesToReplace.getLength(); ++i) {
                        XMLNode rNode = (XMLNode)nodesToReplace.item(i);
                        try {
                            XMLNode rParent;
                            Attr colNumAtt;
                            Attr valueAtt = (Attr)rNode.getAttributes().getNamedItem("value1");
                            if (valueAtt == null) continue;
                            String value1 = valueAtt.getValue();
                            rNode.getFirstChild().setNodeValue(value1);
                            if (rNode.getNodeName().equals("COL_NUM") && (colNumAtt = (Attr)(rParent = (XMLNode)rNode.getParentNode()).getAttributes().getNamedItem("col-num")) != null) {
                                colNumAtt.setValue(value1);
                            }
                            rNode.getAttributes().removeNamedItem("value1");
                            continue;
                        }
                        catch (DOMException de) {
                            if (!s_log.isDebugEnabled()) continue;
                            s_log.debug((Object)"Caught DOMException\n", (Throwable)de);
                        }
                    }
                    break block28;
                }
                nodesToModify = null;
                try {
                    nodesToModify = diffDoc.selectNodes("//*[@value1]", (NSResolver)CMXMLUtils.getSXMLResolver());
                }
                catch (XSLException xe) {
                    if (!s_log.isDebugEnabled()) break block26;
                    s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                }
            }
            if (nodesToModify != null && nodesToModify.getLength() > 0) {
                for (int i = 0; i < nodesToModify.getLength(); ++i) {
                    mNode = (XMLNode)nodesToModify.item(i);
                    mNode.getAttributes().removeNamedItem("value1");
                }
            }
        }
    }

    public static void flipXmlDoc(XMLDocument doc, int objType) {
        block15: {
            block16: {
                if (doc == null) break block15;
                if (!DDLUtils.sxmlSupported(objType)) break block16;
                NodeList diffNodes = null;
                try {
                    diffNodes = doc.selectNodes(X_ALL_DIFF_NODES);
                }
                catch (XSLException xe) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                    }
                    return;
                }
                if (diffNodes == null || diffNodes.getLength() <= 0) break block15;
                for (int i = 0; i < diffNodes.getLength(); ++i) {
                    XMLElement diffNode = (XMLElement)diffNodes.item(i);
                    try {
                        String srcValue = diffNode.getAttribute("src");
                        if (srcValue != null && !srcValue.equals("")) {
                            if (srcValue.equals("1")) {
                                diffNode.setAttribute("src", "2");
                                continue;
                            }
                            if (!srcValue.equals("2")) continue;
                            diffNode.setAttribute("src", "1");
                            continue;
                        }
                        String value1Value = diffNode.getAttribute("value1");
                        if (value1Value == null || value1Value.equals("")) continue;
                        String currValue = CMXMLUtils.selectTextValue((XMLNode)diffNode, ".");
                        CMXMLUtils.setRelativeTextNodeValue((XMLNode)diffNode, null, value1Value);
                        diffNode.setAttribute("value1", currValue);
                        continue;
                    }
                    catch (DOMException de) {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)"Caught DOMException\n", (Throwable)de);
                        }
                        return;
                    }
                }
                break block15;
            }
            NodeList srcNodes = null;
            try {
                srcNodes = doc.selectNodes(X_SOURCE_NODES);
            }
            catch (XSLException xe) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                }
                return;
            }
            if (srcNodes != null && srcNodes.getLength() > 0) {
                block7: for (int sn = 0; sn < srcNodes.getLength(); ++sn) {
                    NodeList childNodes;
                    XMLElement srcNode = (XMLElement)srcNodes.item(sn);
                    if (srcNode == null || (childNodes = srcNode.getChildNodes()) == null || childNodes.getLength() <= 0) continue;
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        XMLPI pi;
                        Node c = childNodes.item(i);
                        if (c == null || c.getNodeType() != 7 || (pi = (XMLPI)c).getTarget() != "UPDATE") continue;
                        String currValue = CMXMLUtils.selectTextValue((XMLNode)srcNode, ".");
                        String oldValue = pi.getData();
                        pi.setData(currValue);
                        CMXMLUtils.setRelativeTextNodeValue((XMLNode)srcNode, null, oldValue);
                        continue block7;
                    }
                }
            }
        }
    }

    public static String generateDDL(int objType, XMLDocument xml, int transform, int transformParams, CMXSLTransformInfo xformInfo, String versionStr) {
        String ddl;
        block8: {
            ddl = null;
            ByteArrayOutputStream bos = null;
            try {
                if (xml != null && xformInfo != null) {
                    XSLProcessor proc = xformInfo.getProcessor();
                    XSLStylesheet ss = xformInfo.getStylesheet();
                    bos = new ByteArrayOutputStream();
                    XMLAccessor.setTransformParams(proc, transformParams, versionStr);
                    if (transform == 4 && (objType == 0 || objType == 2)) {
                        proc.setParam("", "REORDER_COLUMNS", (Object)"1");
                    }
                    proc.processXSL(ss, xml, (OutputStream)bos);
                    ddl = bos.toString("UTF-8");
                }
            }
            catch (XSLException xe) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Caught XSLException\n", (Throwable)xe);
                }
            }
            catch (EOFException eof) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Caught EOFException\n", (Throwable)eof);
                }
            }
            catch (IOException ioe) {
                if (!s_log.isDebugEnabled()) break block8;
                s_log.debug((Object)"Caught IOException\n", (Throwable)ioe);
            }
        }
        return ddl;
    }

    public static String getTargetVersion(CMConnection conn) {
        if (conn == null) {
            return null;
        }
        String v = conn.getDBVersion();
        return DDLUtils.canonizeDBVersion(v);
    }

    public static String getTargetCompatibleVersion(CMConnection conn) {
        if (conn == null) {
            return null;
        }
        String v = conn.getCompatibleVersion();
        return DDLUtils.canonizeDBVersion(v);
    }

    public static String canonizeDBVersion(String v) {
        if (v == null) {
            return null;
        }
        int pos = -1;
        pos = v.indexOf(46);
        String majorV = v.substring(0, pos);
        String minorV = v.substring(pos + 1, v.indexOf(46, pos + 1));
        if (majorV.length() == 1) {
            majorV = "0" + majorV;
        }
        if (minorV.length() == 1) {
            minorV = "0" + minorV;
        }
        return majorV + minorV + "000000";
    }
}

