/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.RAW;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccess;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class ChangePlan
extends ChangePlanInfo {
    private static final int MAX_RAW_ARG_SIZE = Short.MAX_VALUE;
    private static final int MAX_VARCHAR_ARG_SIZE = Short.MAX_VALUE;
    private static final int PRE_SCRIPT = 1;
    private static final int POST_SCRIPT = 2;
    private int m_planID = -1;
    private ChangePlanAccess m_cpAccess = null;
    private static final String s_changeItemInfoQuery = "select object_type, object_schema, object_name,   change_item_type, change_item_description,   source_db_client, source_db_em, source_db_global_name from sysman.mgmt$cm_c_p_chng_items where change_plan_id = ?";
    private static final String s_changeItemDefnQuery = "select change_item_type, addnl_info, change_item_description, source_db_client, source_db_em, source_db_global_name, sxml_document, orig_full_xml from sysman.mgmt$cm_c_p_chng_items where change_plan_id = ?   and object_type = ?   and object_schema = ?   and object_name = ?";
    private static final String s_changeItemDefnNSQuery = "select change_item_type, addnl_info,  change_item_description, source_db_client, source_db_em, source_db_global_name, sxml_document, orig_full_xml from sysman.mgmt$cm_c_p_chng_items where change_plan_id = ?   and object_type = ?   and object_name = ?";
    private static final String s_changeItemInsertDML = "begin   sysman.mgmt_cm_cp.insert_change_item (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end;";
    private static final String s_changeItemInsertOrigXMLDML = "begin   sysman.mgmt_cm_cp.insert_change_item (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end;";
    private static final String s_changeItemUpdateDML = "begin   sysman.mgmt_cm_cp.update_change_item (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end;";
    private static final String s_changeItemUpdateOrigXMLDML = "begin   sysman.mgmt_cm_cp.update_change_item (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end;";
    private static final String s_appendBlobCall = "begin   sysman.mgmt_cm_cp.append_to_blob (?, ?, ?); end;";
    private static final String s_setPreScriptDML = "begin   sysman.mgmt_cm_cp.update_pre_script (?, ?); end;";
    private static final String s_getPreScriptQuery = "select pre_script from sysman.mgmt$cm_change_plans where change_plan_id = ?";
    private static final String s_setPostScriptDML = "begin   sysman.mgmt_cm_cp.update_post_script (?, ?); end;";
    private static final String s_getPostScriptQuery = "select post_script from sysman.mgmt$cm_change_plans where change_plan_id = ?";
    private static final String s_appendClobCall = "begin   sysman.mgmt_cm_cp.append_to_clob (?, ?, ?); end;";
    private static final String s_changeItemDeleteDML = "begin   sysman.mgmt_cm_cp.delete_change_item (?, ?, ?, ?); end;";
    private static final String s_actionAllowedByIDCall = "begin ? := sysman.mgmt_cm_cp.action_allowed( ?, ? ); end;";

    ChangePlan(String planName, String planOwner, int planID, ChangePlanAccess cpAccess) {
        super(planName, planOwner);
        this.m_planID = planID;
        this.m_cpAccess = cpAccess;
    }

    private ChangePlan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeItemInfo[] getChangeItems() throws ChangePlanAccessException, SQLException {
        ChangeItemInfo[] changeItems = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<ChangeItemInfo> ciVec = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        try {
            stmt = cmConn.prepareStatement(s_changeItemInfoQuery);
            stmt.setInt(1, this.m_planID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int objType = rs.getInt(1);
                String objSchema = rs.getString(2);
                String objName = rs.getString(3);
                int ciType = rs.getInt(4);
                String description = rs.getString(5);
                String clientDB = rs.getString(6);
                String emDB = rs.getString(7);
                String globalDB = rs.getString(8);
                String objTypeName = XMLAccessor.intTypeToMDAPIType(objType);
                ChangeItemInfo ciInfo = new ChangeItemInfo(ciType, objTypeName, objName, objSchema, description);
                ciInfo.setClientSourceDatabase(clientDB);
                ciInfo.setEntMgrSourceDatabase(emDB);
                ciInfo.setGlobalSourceDatabase(globalDB);
                if (ciVec == null) {
                    ciVec = new Vector<ChangeItemInfo>();
                }
                ciVec.addElement(ciInfo);
            }
        }
        catch (Throwable throwable) {
            CMConnection.close(stmt, rs);
            throw throwable;
        }
        CMConnection.close(stmt, rs);
        if (ciVec != null) {
            changeItems = new ChangeItemInfo[ciVec.size()];
            for (int i = 0; i < ciVec.size(); ++i) {
                changeItems[i] = (ChangeItemInfo)ciVec.elementAt(i);
            }
        }
        return changeItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeItem getOneChangeItem(ChangeItemInfo itemInfo) throws ChangePlanAccessException, SQLException {
        ChangeItem changeItem = null;
        String objType = itemInfo.getObjectType();
        String objSchema = itemInfo.getObjectSchema();
        String objName = itemInfo.getObjectName();
        int objTypeCode = XMLAccessor.MDAPITypeToIntType(objType);
        boolean isSchema = objSchema != null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        InputStream xmlis = null;
        try {
            stmt = cmConn.prepareStatement(isSchema ? s_changeItemDefnQuery : s_changeItemDefnNSQuery);
            int bindNo = 1;
            stmt.setInt(bindNo++, this.m_planID);
            stmt.setInt(bindNo++, objTypeCode);
            if (isSchema) {
                stmt.setString(bindNo++, objSchema);
            }
            stmt.setString(bindNo++, objName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int ciType = rs.getInt(1);
                String addnlInfo = rs.getString(2);
                String description = rs.getString(3);
                String clientDB = rs.getString(4);
                String emDB = rs.getString(5);
                String globalDB = rs.getString(6);
                Blob sxmlBlob = rs.getBlob(7);
                Blob fullXmlBlob = rs.getBlob(8);
                Document sxmlDoc = null;
                Document fullXmlDoc = null;
                if (sxmlBlob != null) {
                    xmlis = sxmlBlob.getBinaryStream();
                    sxmlDoc = CMXMLUtils.parseXMLDocument(new InflaterInputStream(xmlis), true);
                }
                if (fullXmlBlob != null) {
                    xmlis = fullXmlBlob.getBinaryStream();
                    fullXmlDoc = CMXMLUtils.parseXMLDocument(new InflaterInputStream(xmlis), true);
                }
                changeItem = new ChangeItem(ciType, objType, objName, objSchema, description, (XMLDocument)sxmlDoc);
                changeItem.setChangePlan(this);
                changeItem.setAdditionalInfo(addnlInfo);
                changeItem.setClientSourceDatabase(clientDB);
                changeItem.setEntMgrSourceDatabase(emDB);
                changeItem.setGlobalSourceDatabase(globalDB);
                changeItem.setOriginalFullXML((XMLDocument)fullXmlDoc);
            }
        }
        catch (Throwable throwable) {
            CMConnection.close(stmt, rs);
            throw throwable;
        }
        CMConnection.close(stmt, rs);
        return changeItem;
    }

    public void addChangeItem(ChangeItem item) throws ChangePlanAccessException, SQLException {
        this.addOrUpdateChangeItem(item, true);
    }

    public void updateChangeItem(ChangeItem item) throws ChangePlanAccessException, SQLException {
        this.addOrUpdateChangeItem(item, false);
    }

    public void removeChangeItem(ChangeItemInfo itemInfo) throws ChangePlanAccessException, SQLException {
        CallableStatement stmt = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        int objTypeCode = XMLAccessor.MDAPITypeToIntType(itemInfo.getObjectType());
        String objSchema = itemInfo.getObjectSchema();
        boolean isSchema = objSchema != null;
        try {
            stmt = cmConn.prepareCall(s_changeItemDeleteDML);
            stmt.setInt(1, this.m_planID);
            stmt.setInt(2, objTypeCode);
            if (isSchema) {
                stmt.setString(3, objSchema);
            } else {
                stmt.setNull(3, 12);
            }
            stmt.setString(4, itemInfo.getObjectName());
            stmt.execute();
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 20030) {
                throw new ChangePlanAccessException(6, "Change item " + itemInfo.getItemDisplayName() + " does not exist in change plan " + this.getPlanName() + ", or user cannot modify the plan.", se);
            }
            throw se;
        }
        finally {
            CMConnection.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int userActionAllowed(int userAction) throws ChangePlanAccessException, SQLException {
        int isAllowed = 1;
        this.m_cpAccess.checkLogin();
        CallableStatement stmt = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        try {
            stmt = cmConn.prepareCall(s_actionAllowedByIDCall);
            stmt.registerOutParameter(1, 4);
            stmt.setInt(2, userAction);
            stmt.setInt(3, this.m_planID);
            stmt.execute();
            isAllowed = stmt.getInt(1);
        }
        finally {
            CMConnection.close(stmt);
        }
        return isAllowed;
    }

    public void setPreScript(String script) throws SQLException {
        this.updateScript(script, 1);
    }

    public String getPreScript() throws SQLException {
        return this.getScript(1);
    }

    public void setPostScript(String script) throws SQLException {
        this.updateScript(script, 2);
    }

    public String getPostScript() throws SQLException {
        return this.getScript(2);
    }

    @Override
    public String toString() {
        String info = super.toString() + "\n  ID: " + this.m_planID;
        return info;
    }

    private void addOrUpdateChangeItem(ChangeItem item, boolean adding) throws ChangePlanAccessException, SQLException {
        CallableStatement stmt = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        int objTypeCode = XMLAccessor.MDAPITypeToIntType(item.getObjectType());
        String objSchema = item.getObjectSchema();
        boolean isSchema = objSchema != null;
        String addnlInfo = item.getAdditionalInfo();
        String description = item.getDescription();
        String clientSrcDB = item.getClientSourceDatabase();
        String entMgrSrcDB = item.getEntMgrSourceDatabase();
        String glblSrcDB = item.getGlobalSourceDatabase();
        XMLDocument defn = item.getDefinition();
        XMLDocument fullXmlDefn = item.getOriginalFullXML();
        boolean origXml = fullXmlDefn != null && item.updateFullXML();
        boolean wasAutoCommit = cmConn.getAutoCommit();
        try {
            if (wasAutoCommit) {
                cmConn.setAutoCommit(false);
            }
            String ddl = null;
            ddl = adding ? (origXml ? s_changeItemInsertOrigXMLDML : s_changeItemInsertDML) : (origXml ? s_changeItemUpdateOrigXMLDML : s_changeItemUpdateDML);
            stmt = cmConn.prepareCall(ddl);
            stmt.setInt(1, this.m_planID);
            stmt.setInt(2, objTypeCode);
            if (isSchema) {
                stmt.setString(3, objSchema);
            } else {
                stmt.setNull(3, 12);
            }
            stmt.setString(4, item.getObjectName());
            if (addnlInfo != null) {
                stmt.setString(5, addnlInfo);
            } else {
                stmt.setNull(5, 12);
            }
            stmt.setInt(6, item.getItemAction());
            if (description != null) {
                stmt.setString(7, description);
            } else {
                stmt.setNull(7, 12);
            }
            if (clientSrcDB != null) {
                stmt.setString(8, clientSrcDB);
            } else {
                stmt.setNull(8, 12);
            }
            if (entMgrSrcDB != null) {
                stmt.setString(9, entMgrSrcDB);
            } else {
                stmt.setNull(9, 12);
            }
            if (glblSrcDB != null) {
                stmt.setString(10, glblSrcDB);
            } else {
                stmt.setNull(10, 12);
            }
            stmt.registerOutParameter(11, 2004);
            if (origXml) {
                stmt.registerOutParameter(12, 2004);
            }
            stmt.execute();
            if (defn != null) {
                Blob defnBlob = stmt.getBlob(11);
                this.writeDocToRepository(cmConn, defn, defnBlob);
            }
            if (origXml) {
                Blob origXmlBlob = stmt.getBlob(12);
                this.writeDocToRepository(cmConn, fullXmlDefn, origXmlBlob);
            }
            cmConn.commit();
        }
        catch (SQLException se) {
            try {
                if (adding && se.getErrorCode() == 20029) {
                    throw new ChangePlanAccessException(7, "Change item " + item.getItemDisplayName() + " already exists in change plan " + this.getPlanName(), se);
                }
                if (se.getErrorCode() == 20030) {
                    throw new ChangePlanAccessException(6, "Change item " + item.getItemDisplayName() + " does not exist in change plan " + this.getPlanName() + ", or user cannot modify the plan.", se);
                }
                throw se;
            }
            catch (Throwable throwable) {
                CMConnection.close(stmt);
                cmConn.setAutoCommit(wasAutoCommit);
                throw throwable;
            }
        }
        CMConnection.close(stmt);
        cmConn.setAutoCommit(wasAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocToRepository(CMConnection cmConn, XMLDocument defn, Blob defnBlob) throws SQLException, ChangePlanAccessException {
        try {
            OracleCallableStatement blobStmt;
            block9: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    defn.print((OutputStream)baos, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    defn.print((OutputStream)baos);
                }
                ByteArrayOutputStream compressedDefn = new ByteArrayOutputStream();
                DeflaterOutputStream z = new DeflaterOutputStream(compressedDefn);
                z.write(baos.toByteArray());
                z.close();
                byte[] defnBytes = compressedDefn.toByteArray();
                blobStmt = null;
                try {
                    RAW rawDefn;
                    blobStmt = (OracleCallableStatement)cmConn.prepareCall(s_appendBlobCall);
                    byte[] buf = defnBytes;
                    int defnLength = defnBytes.length;
                    if (defnLength > Short.MAX_VALUE) {
                        buf = new byte[Short.MAX_VALUE];
                        int bytesStart = 0;
                        while (bytesStart + Short.MAX_VALUE < defnLength) {
                            System.arraycopy(defnBytes, bytesStart, buf, 0, Short.MAX_VALUE);
                            rawDefn = new RAW(buf);
                            blobStmt.setBlob(1, defnBlob);
                            blobStmt.setInt(2, Short.MAX_VALUE);
                            blobStmt.setRAW(3, rawDefn);
                            blobStmt.execute();
                            blobStmt.clearParameters();
                            bytesStart += Short.MAX_VALUE;
                        }
                        buf = new byte[defnLength -= bytesStart];
                        if (defnLength > 0) {
                            System.arraycopy(defnBytes, bytesStart, buf, 0, defnLength);
                        }
                    }
                    if (defnLength <= 0) break block9;
                    rawDefn = new RAW(buf);
                    blobStmt.setBlob(1, defnBlob);
                    blobStmt.setInt(2, defnLength);
                    blobStmt.setRAW(3, rawDefn);
                    blobStmt.execute();
                }
                catch (Throwable throwable) {
                    CMConnection.close(blobStmt);
                    throw throwable;
                }
            }
            CMConnection.close((Statement)blobStmt);
        }
        catch (IOException ioe) {
            cmConn.rollback();
            throw new ChangePlanAccessException(10, "IOException trying to save document text:", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateScript(String script, int whichScript) throws SQLException {
        block13: {
            stmt = null;
            cmConn = this.m_cpAccess.getConnection();
            wasAutoCommit = cmConn.getAutoCommit();
            try {
                if (wasAutoCommit) {
                    cmConn.setAutoCommit(false);
                }
                ddl = null;
                switch (whichScript) {
                    case 1: {
                        ddl = "begin   sysman.mgmt_cm_cp.update_pre_script (?, ?); end;";
                        ** break;
                    }
                    case 2: {
                        ddl = "begin   sysman.mgmt_cm_cp.update_post_script (?, ?); end;";
                        ** break;
                    }
                }
            }
            catch (Throwable var14_14) {
                CMConnection.close(stmt);
                cmConn.setAutoCommit(wasAutoCommit);
                throw var14_14;
            }
            CMConnection.close(stmt);
            cmConn.setAutoCommit(wasAutoCommit);
            return;
lbl-1000:
            // 2 sources

            {
                stmt = cmConn.prepareCall(ddl);
                stmt.setInt(1, this.m_planID);
                stmt.registerOutParameter(2, 2005);
                stmt.execute();
                if (script == null) break block13;
                scriptClob = stmt.getClob(2);
                scriptChars = script.toCharArray();
                clobStmt = null;
                try {
                    clobStmt = (OracleCallableStatement)cmConn.prepareCall("begin   sysman.mgmt_cm_cp.append_to_clob (?, ?, ?); end;");
                    scriptFragment = null;
                    scriptLength = scriptChars.length;
                    charsStart = 0;
                    if (scriptLength > 32767) {
                        charsStart = 0;
                        while (charsStart + 32767 < scriptLength) {
                            scriptFragment = new String(scriptChars, charsStart, 32767);
                            clobStmt.setClob(1, scriptClob);
                            clobStmt.setInt(2, 32767);
                            clobStmt.setString(3, scriptFragment);
                            clobStmt.execute();
                            clobStmt.clearParameters();
                            charsStart += 32767;
                        }
                        scriptLength -= charsStart;
                    }
                    if (scriptLength > 0) {
                        scriptFragment = new String(scriptChars, charsStart, scriptLength);
                        clobStmt.setClob(1, scriptClob);
                        clobStmt.setInt(2, scriptLength);
                        clobStmt.setString(3, scriptFragment);
                        clobStmt.execute();
                    }
                }
                catch (Throwable var13_13) {
                    CMConnection.close(clobStmt);
                    throw var13_13;
                }
                CMConnection.close((Statement)clobStmt);
                cmConn.commit();
            }
        }
        CMConnection.close(stmt);
        cmConn.setAutoCommit(wasAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScript(int whichScript) throws SQLException {
        String script = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CMConnection cmConn = this.m_cpAccess.getConnection();
        try {
            stmt = cmConn.prepareStatement(whichScript == 1 ? s_getPreScriptQuery : s_getPostScriptQuery);
            stmt.setInt(1, this.m_planID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                script = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            CMConnection.close(stmt, rs);
            throw throwable;
        }
        CMConnection.close(stmt, rs);
        return script;
    }
}

