/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;

public class ChangeItemInfo {
    public static final int CP_NO_ACTION = 0;
    public static final int CP_ADD = 1;
    public static final int CP_MODIFY = 2;
    public static final int CP_DROP = 3;
    public static final int CP_MONITOR = 4;
    public static String CLUSTER = "CLUSTER";
    public static String DB_LINK = "DB_LINK";
    public static String FUNCTION = "FUNCTION";
    public static String INDEX = "INDEX";
    public static String MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    public static String MATERIALIZED_VIEW_LOG = "MATERIALIZED_VIEW_LOG";
    public static String PACKAGE = "PACKAGE";
    public static String PACKAGE_SPEC = "PACKAGE_SPEC";
    public static String PACKAGE_BODY = "PACKAGE_BODY";
    public static String PROCEDURE = "PROCEDURE";
    public static String PROFILE = "PROFILE";
    public static String ROLE = "ROLE";
    public static String ROLLBACK_SEGMENT = "ROLLBACK_SEGMENT";
    public static String SEQUENCE = "SEQUENCE";
    public static String SYNONYM = "SYNONYM";
    public static String TABLE = "TABLE";
    public static String TABLESPACE = "TABLESPACE";
    public static String TRIGGER = "TRIGGER";
    public static String TYPE = "TYPE";
    public static String USER = "USER";
    public static String VIEW = "VIEW";
    public static final int MAX_DESCRIPTION_LENGTH = 2000;
    private int m_itemAction = 0;
    private String m_objectType = null;
    private String m_objectName = null;
    private String m_objectSchema = null;
    private String m_description = null;
    private String m_clientSrcDB = null;
    private String m_entMgrSrcDB = null;
    private String m_globalSrcDB = null;

    public ChangeItemInfo() {
    }

    public ChangeItemInfo(int itemAction, String typeName, String objectName, String objectSchema, String description) throws ChangePlanAccessException {
        if (!(typeName.equals(TABLE) || typeName.equals(INDEX) || typeName.equals(VIEW) || typeName.equals(TRIGGER) || typeName.equals(SYNONYM) || typeName.equals(PACKAGE) || typeName.equals(PACKAGE_SPEC) || typeName.equals(PACKAGE_BODY) || typeName.equals(PROCEDURE) || typeName.equals(FUNCTION) || typeName.equals(SEQUENCE) || typeName.equals(DB_LINK) || typeName.equals(MATERIALIZED_VIEW) || typeName.equals(MATERIALIZED_VIEW_LOG) || typeName.equals(CLUSTER) || typeName.equals(TYPE) || typeName.equals(USER) || typeName.equals(ROLE) || typeName.equals(PROFILE) || typeName.equals(TABLESPACE) || typeName.equals(ROLLBACK_SEGMENT))) {
            throw new ChangePlanAccessException(9, "Invalid object type: " + typeName);
        }
        if (itemAction != 1 && itemAction != 2 && itemAction != 3 && itemAction != 4) {
            throw new ChangePlanAccessException(9, "Invalid change item action code: " + itemAction);
        }
        this.setItemAction(itemAction);
        this.setObjectType(typeName);
        this.setObjectName(objectName);
        this.setObjectSchema(objectSchema);
        this.setDescription(description);
    }

    public void setItemAction(int action) {
        this.m_itemAction = action;
    }

    public int getItemAction() {
        return this.m_itemAction;
    }

    public void setObjectType(String typeName) {
        this.m_objectType = typeName;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public int getObjectTypeCode() {
        return XMLAccessor.MDAPITypeToIntType(this.m_objectType);
    }

    public void setObjectName(String name) {
        this.m_objectName = name;
    }

    public String getObjectName() {
        return this.m_objectName;
    }

    public void setObjectSchema(String schema) {
        this.m_objectSchema = schema;
    }

    public String getObjectSchema() {
        return this.m_objectSchema;
    }

    public void setDescription(String description) throws ChangePlanAccessException {
        if (this.m_description != null && this.m_description.length() > 2000) {
            throw new ChangePlanAccessException(9, "Length of change item description exceeds 2000 characters.");
        }
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getItemDisplayName() {
        String dName = this.m_objectType + " " + (this.m_objectSchema == null ? "" : this.m_objectSchema + ".") + this.m_objectName;
        return dName;
    }

    public void setClientSourceDatabase(String db) {
        this.m_clientSrcDB = db;
    }

    public String getClientSourceDatabase() {
        return this.m_clientSrcDB;
    }

    public void setEntMgrSourceDatabase(String db) {
        this.m_entMgrSrcDB = db;
    }

    public String getEntMgrSourceDatabase() {
        return this.m_entMgrSrcDB;
    }

    public void setGlobalSourceDatabase(String db) {
        this.m_globalSrcDB = db;
    }

    public String getGlobalSourceDatabase() {
        return this.m_globalSrcDB;
    }

    public String toString() {
        String info = "  Action: " + this.getActionName(this.getItemAction()) + "\n  Type: " + this.m_objectType + (this.m_objectSchema == null ? "" : "\n  Schema: " + this.m_objectSchema) + "\n  Name: " + this.m_objectName + "\n  Description: " + this.m_description;
        return info;
    }

    String getActionName(int action) {
        String name = null;
        switch (action) {
            case 0: {
                name = "None";
                break;
            }
            case 1: {
                name = "Add";
                break;
            }
            case 2: {
                name = "Modify";
                break;
            }
            case 3: {
                name = "Drop";
                break;
            }
            case 4: {
                name = "Monitor";
            }
        }
        return name;
    }
}

