/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccess;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.xml.parser.v2.XMLDocument;

public class CPDemo2 {
    static String CP_OWNER = "SYSMAN";

    public static void main(String[] args) {
        String hps;
        String cString;
        if (args.length < 5) {
            CPDemo2.usage();
            System.exit(0);
        }
        if ((cString = CPDemo2.getURL(hps = args[0])) == null) {
            System.out.println("No URL generated, args[0]: " + args[0]);
            System.exit(0);
        }
        String user = args[1].toUpperCase();
        String pwd = args[2];
        String user2 = args[3].toUpperCase();
        String pwd2 = args[4];
        ChangePlanAccess cpAccess = new ChangePlanAccess();
        try {
            cpAccess.login(user, pwd, cString);
            System.out.println("Logged in as " + user);
            ChangePlan cp = cpAccess.getOneChangePlan("ChangePlan_Demo1", CP_OWNER);
            System.out.println("Opened Change Plan:");
            System.out.println(cp.toString());
            OracleDataSource ods = new OracleDataSource();
            ods.setURL(cString);
            ods.setUser("SYSTEM");
            ods.setPassword("MANAGER");
            OracleConnection conn = (OracleConnection)ods.getConnection();
            CMConnection cmConn = new CMConnection(conn);
            XMLAccessorSettings xacImpl = new XMLAccessorSettings();
            xacImpl.setXslRoot(System.getProperty("WEB_INF_ROOT"));
            XMLAccessor xa = null;
            XMLDocument tDoc1 = null;
            XMLDocument tDoc2 = null;
            ChangeItem ci = null;
            Statement dmlStmt = cmConn.createStatement();
            String dml = "CREATE UNIQUE INDEX CPDEMO.EMP_IDX ON CPDEMO.EMP(EMPNO)";
            System.out.println("Creating an index using:\n  " + dml);
            dmlStmt.execute(dml);
            xa = XMLAccessor.getXMLAccessorForType(1, xacImpl);
            xa.initFromDatabase(cmConn, "CPDEMO", "EMP_IDX", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(1, ChangeItemInfo.INDEX, "EMP_IDX", "CPDEMO", "This is an Add change item for CPDEMO.EMP_IDX", tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            System.out.println("Added Add-type change item for index CPDEMO.EMP_IDX to the change plan.");
            System.out.println("Creating a Modify-type change item for table CPDEMO.EMP:");
            System.out.println("  Capturing initial definition...");
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, "CPDEMO", "EMP", true);
            tDoc1 = xa.getDocument();
            dml = "ALTER TABLE CPDEMO.EMP ADD (MOST_RECENT_BONUS NUMBER)";
            System.out.println("  Adding a column using:\n   " + dml);
            dmlStmt.execute(dml);
            System.out.println("  Capturing revised definition...");
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, "CPDEMO", "EMP", true);
            tDoc2 = xa.getDocument();
            System.out.println("  Creating the change item...");
            ci = new ChangeItem(2, ChangeItemInfo.TABLE, "EMP", "CPDEMO", "This is a Modify change item", tDoc1, tDoc2, xacImpl);
            cp.addChangeItem(ci);
            System.out.println("Added Modify-type change item for table CPDEMO.EMP to change plan.");
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, "CPDEMO", "BONUS", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(3, ChangeItemInfo.TABLE, "BONUS", "CPDEMO", null, tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            System.out.println("Added Drop-type change item for table CPDEMO.BONUS to change plan.");
            System.out.println("End of plan edits by " + user);
            cpAccess.logout();
            System.out.println("-------------------------------");
            System.out.println("Additional plan edit from " + user2);
            cpAccess.login(user2, pwd2, cString);
            System.out.println("Logged in as " + user2);
            cp = cpAccess.getOneChangePlan("ChangePlan_Demo1", CP_OWNER);
            System.out.println("Opened Change Plan:");
            System.out.println(cp.toString());
            System.out.println("Updating the Modify-type change item:");
            System.out.println("  Retrieving the change item...");
            ChangeItemInfo itemInfo = new ChangeItemInfo(2, ChangeItemInfo.TABLE, "EMP", "CPDEMO", null);
            ChangeItem modCI = cp.getOneChangeItem(itemInfo);
            dml = "ALTER TABLE CPDEMO.EMP MODIFY (ENAME VARCHAR2(40))";
            System.out.println("  Changing column using:\n   " + dml);
            dmlStmt.execute(dml);
            dml = "ALTER TABLE CPDEMO.EMP NOLOGGING";
            System.out.println("  Setting NOLOGGING on the table using:\n   " + dml);
            dmlStmt.execute(dml);
            System.out.println("  Capturing revised definition...");
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, "CPDEMO", "EMP", true);
            tDoc2 = xa.getDocument();
            System.out.println("  Updating and storing change item...");
            modCI.updateDefinition(tDoc2, xacImpl);
            cp.updateChangeItem(modCI);
            System.out.println("Updated Modify-type change item for CPDEMO.EMP in change plan.");
            cpAccess.logout();
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException se) {
            System.out.println("Caught SQLException " + se.getErrorCode() + ": " + se.toString());
            se.printStackTrace();
            System.exit(0);
        }
        catch (ChangePlanAccessException cpe) {
            System.out.println("Caught ChangePlanAccessException, reason: " + cpe.getReason());
            if (cpe.getCause() != null) {
                cpe.getCause().printStackTrace(System.out);
            }
            cpe.printStackTrace(System.out);
            System.exit(0);
        }
        catch (XMLAccessorException xae) {
            System.out.println("Caught XMLAccessorException:");
            xae.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private static String getURL(String hps) {
        String url = null;
        if (hps != null) {
            int colon1 = hps.indexOf(":");
            int colon2 = hps.indexOf(":", colon1 + 1);
            int colon3 = hps.indexOf(":", colon2 + 1);
            if (colon1 > 0 && colon2 > colon1) {
                String host = hps.substring(0, colon1);
                String port = hps.substring(colon1 + 1, colon2);
                String sid = colon3 > colon2 ? hps.substring(colon2 + 1, colon3) : hps.substring(colon2 + 1);
                url = "jdbc:oracle:thin:@" + host + ":" + port + "/" + sid;
            }
        }
        return url;
    }

    private static String getUsername(String hps) {
        String username = null;
        int slashPos = hps.lastIndexOf("/");
        if (slashPos != -1) {
            int colPos = hps.lastIndexOf(":", slashPos);
            username = hps.substring(colPos + 1, slashPos);
        }
        return username;
    }

    private static String getPassword(String hps) {
        String pwd = null;
        int slashPos = hps.lastIndexOf("/");
        if (slashPos != -1) {
            pwd = hps.substring(slashPos + 1);
        }
        return pwd;
    }

    private static void usage() {
        System.out.println("Usage: CPDemo2 repos-host:port:sid username password username2 password2");
    }
}

