/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyOneDiffResult;
import oracle.xml.parser.v2.XMLDocument;

public class ApplyChangeItemResult
extends ChangeItemInfo {
    public static final int CI_NOT_PROCESSED = -1;
    public static final int CI_NO_CONFLICT = 0;
    public static final int CI_EXISTS_SAME = 1;
    public static final int CI_EXISTS_DIFFERENT = 2;
    public static final int CI_NOT_EXIST = 3;
    public static final int CI_DIFF_CONFLICTS = 4;
    private int m_resultCode = -1;
    private ApplyOneDiffResult[] m_diffResults = null;
    private XMLDocument m_diffDoc = null;
    private boolean m_itemWasAdded = false;

    public ApplyChangeItemResult(int itemAction, String typeName, String objectName, String objectSchema, String description) throws ChangePlanAccessException {
        super(itemAction, typeName, objectName, objectSchema, description);
    }

    public void setResult(int code) {
        this.m_resultCode = code;
    }

    public int getResult() {
        return this.m_resultCode;
    }

    public void setDiffResults(ApplyOneDiffResult[] results) {
        this.m_diffResults = results;
    }

    public ApplyOneDiffResult[] getDiffResults() {
        return this.m_diffResults;
    }

    public void setDifferencesDoc(XMLDocument diffDoc) {
        this.m_diffDoc = diffDoc;
    }

    public XMLDocument getDifferencesDoc() {
        return this.m_diffDoc;
    }

    public void setSynchObjectAdded(boolean added) {
        this.m_itemWasAdded = added;
    }

    public boolean getSynchObjectAdded() {
        return this.m_itemWasAdded;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fullDetails) {
        StringBuffer sb = new StringBuffer(super.toString()).append("\n  Result: ");
        if (fullDetails) {
            switch (this.m_resultCode) {
                case -1: {
                    sb.append("Not processed.");
                    break;
                }
                case 0: {
                    sb.append("No conflict detected.");
                    break;
                }
                case 1: {
                    sb.append("Target object exists and has the same definition.");
                    break;
                }
                case 2: {
                    sb.append("Target object exists and has a different definition.");
                    break;
                }
                case 3: {
                    sb.append("Target object does not exist.");
                    break;
                }
                case 4: {
                    sb.append("One or more differences conflicted with the target definition.");
                    break;
                }
                default: {
                    sb.append("Unknown result code: ").append(this.m_resultCode);
                    break;
                }
            }
        } else if (this.m_resultCode == -1) {
            sb.append("Not processed.");
        } else {
            sb.append("Processed.");
        }
        if (this.m_itemWasAdded) {
            sb.append("\n  The change item DID create a synch object.");
        } else {
            sb.append("\n  The change item DID NOT create a synch object.");
        }
        if (this.m_resultCode == 2 && this.m_diffDoc != null && fullDetails) {
            sb.append("\n  Differences document:\n");
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                this.m_diffDoc.print((OutputStream)bs);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            sb.append(bs);
        }
        if (this.m_resultCode == 4 && this.m_diffResults != null && this.m_diffResults.length > 0 && fullDetails) {
            sb.append("\n  Diff results: ");
            for (int i = 0; i < this.m_diffResults.length; ++i) {
                ApplyOneDiffResult odr = this.m_diffResults[i];
                sb.append("\n").append(odr);
                if (i >= this.m_diffResults.length - 1) continue;
                sb.append("\n  ----------");
            }
        }
        return sb.toString();
    }
}

