/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableModel;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;
import oracle.javatools.ui.table.GenericTable;

public abstract class PeekableGenericTable
extends GenericTable
implements Peekable {
    private boolean isPeeking = false;

    public PeekableGenericTable() {
    }

    public PeekableGenericTable(TableModel model) {
        super(model);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText(event);
    }

    public String getToolTipText() {
        if (this.isPeeking) {
            return null;
        }
        return super.getToolTipText();
    }

    @Override
    public Peek peek(Point p) {
        Peek peek;
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (this.getCellRect(row, col, false).contains(p) && (peek = this.createPeek(row, col)) != null) {
            peek.showPeek();
            if (this.getCellRenderer(row, col) instanceof JComponent) {
                ((JComponent)((Object)this.getCellRenderer(row, col))).setToolTipText(null);
            }
            this.isPeeking = true;
            peek.getGhostPointingPalette().addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    peek.getGhostPointingPalette().removeAncestorListener((AncestorListener)this);
                    PeekableGenericTable.this.isPeeking = false;
                }
            });
            return peek;
        }
        return null;
    }

    public abstract Peek createPeek(int var1, int var2);
}

