/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt.jdk14;

import ice.debug.Debug;
import ice.util.alg.Listeners;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class AWTMouseWheelListener
implements MouseWheelListener {
    private Scrollbar vbar = null;
    private Scrollbar hbar = null;

    private static void fireAdjustment(Object listenersSet, AdjustmentEvent event) {
        AdjustmentListener l;
        if (event == null) {
            Debug.bug();
        }
        int i = 0;
        while ((l = (AdjustmentListener)Listeners.get(listenersSet, i)) != null) {
            l.adjustmentValueChanged(event);
            ++i;
        }
    }

    public AWTMouseWheelListener(Scrollbar vbar, Scrollbar hbar) {
        this.vbar = vbar;
        this.hbar = hbar;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollAmount() != 0) {
            int direction = 0;
            Scrollbar toScroll = this.vbar;
            if (!(this.vbar != null && this.vbar.isVisible() || (toScroll = this.hbar) != null && toScroll.isVisible())) {
                return;
            }
            int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
            if (e.getScrollType() == 0) {
                this.scrollByUnits(toScroll, direction, e.getScrollAmount());
            } else if (e.getScrollType() == 1) {
                this.scrollByBlock(toScroll, direction);
            }
        }
    }

    protected void scrollByBlock(Scrollbar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement();
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        scrollbar.setValue(newValue);
        this.fireAdjustment(scrollbar, 5, newValue);
    }

    protected void scrollByUnits(Scrollbar scrollbar, int direction, int units) {
        int delta = units;
        delta = direction > 0 ? (delta *= scrollbar.getUnitIncrement()) : (delta *= -scrollbar.getUnitIncrement());
        int oldValue = scrollbar.getValue();
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
        this.fireAdjustment(scrollbar, 5, newValue);
    }

    protected void fireAdjustment(Scrollbar source, int type, int value) {
        Object listenerSet = null;
        AdjustmentListener[] listeners = source.getAdjustmentListeners();
        listenerSet = listeners.length == 1 ? listeners[0] : listeners;
        if (listeners != null) {
            AdjustmentEvent e = new AdjustmentEvent(source, 601, type, value);
            AWTMouseWheelListener.fireAdjustment(listenerSet, e);
        }
    }
}

