/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.util.Defs;

public class CharKit {
    public static int indexOf(int ch, char[] array, int begin, int end) {
        while (begin != end) {
            if (array[begin] == ch) {
                return begin;
            }
            ++begin;
        }
        return -1;
    }

    public static int skipWhileNot(String set, char[] array, int begin, int end) {
        while (begin != end && set.indexOf(array[begin]) < 0) {
            ++begin;
        }
        return begin;
    }

    public static int skipAny(String set, char[] array, int begin, int end) {
        while (begin != end && set.indexOf(array[begin]) >= 0) {
            ++begin;
        }
        return begin;
    }

    public static int trimStart(char[] array, int begin, int end) {
        while (begin != end && array[begin] <= ' ') {
            ++begin;
        }
        return begin;
    }

    public static int trimEnd(char[] array, int begin, int end) {
        int prev;
        while (begin != end && array[prev = end - 1] <= ' ') {
            end = prev;
        }
        return end;
    }

    public static int trimStart(String str, int begin, int end) {
        while (begin != end && str.charAt(begin) <= ' ') {
            ++begin;
        }
        return begin;
    }

    public static int trimEnd(String str, int begin, int end) {
        int prev;
        while (begin != end && str.charAt(prev = end - 1) <= ' ') {
            end = prev;
        }
        return end;
    }

    public static void asciiToLowerCase(char[] array, int begin, int end) {
        while (begin != end) {
            int test = array[begin] - 65;
            if (0 <= test && test <= 25) {
                array[begin] = (char)(test + 97);
            }
            ++begin;
        }
    }

    public static void asciiToUpperCase(char[] array, int begin, int end) {
        while (begin != end) {
            int test = array[begin] - 97;
            if (0 <= test && test <= 25) {
                array[begin] = (char)(test + 65);
            }
            ++begin;
        }
    }

    public static void replace(char from, char to, char[] array, int begin, int end) {
        while (begin != end) {
            if (array[begin] == from) {
                array[begin] = to;
            }
            ++begin;
        }
    }

    public static char[] replace(char from, char[] to, char[] array, int begin, int end) {
        int count = 0;
        for (int i = begin; i != end; ++i) {
            if (array[i] != from) continue;
            ++count;
        }
        if (count == 0) {
            return array;
        }
        char[] retval = new char[array.length + count * to.length];
        int i = begin;
        while (begin != end) {
            if (array[begin] == from) {
                int j = 0;
                while (j < to.length) {
                    retval[i] = to[j];
                    ++j;
                    ++i;
                }
                --i;
            } else {
                retval[i] = array[begin];
            }
            ++i;
            ++begin;
        }
        return retval;
    }

    public static boolean equals(String str, char[] array, int begin, int end) {
        block3: {
            int n = str.length();
            if (n == end - begin) {
                int i = 0;
                while (i != n) {
                    if (str.charAt(i) == array[begin]) {
                        ++i;
                        ++begin;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreAsciiCase(String str, char[] array, int begin, int end) {
        block4: {
            int n = str.length();
            if (n == end - begin) {
                while (n != 0) {
                    int c1 = str.charAt(--n);
                    int c2 = array[--end];
                    if (65 <= c1 && c1 <= 90) {
                        c1 += 32;
                    }
                    if (65 <= c2 && c2 <= 90) {
                        c2 += 32;
                    }
                    if (c1 == c2) continue;
                    break block4;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreAsciiCase(String str1, String str2) {
        block4: {
            int n = str1.length();
            if (n == str2.length()) {
                while (n != 0) {
                    int c1 = str1.charAt(--n);
                    int c2 = str2.charAt(n);
                    if (65 <= c1 && c1 <= 90) {
                        c1 += 32;
                    }
                    if (65 <= c2 && c2 <= 90) {
                        c2 += 32;
                    }
                    if (c1 == c2) continue;
                    break block4;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean startsWith(char[] array, int begin, int end, String prefix) {
        block3: {
            int n = prefix.length();
            if (n <= end - begin) {
                int i = 0;
                while (i != n) {
                    if (prefix.charAt(i) == array[begin]) {
                        ++i;
                        ++begin;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreAsciiCase(char[] array, int begin, int end, String prefix) {
        block5: {
            int n = prefix.length();
            if (n <= end - begin) {
                int i = 0;
                while (i != n) {
                    int c1 = array[begin];
                    int c2 = prefix.charAt(i);
                    if (65 <= c1 && c1 <= 90) {
                        c1 += 32;
                    }
                    if (65 <= c2 && c2 <= 90) {
                        c2 += 32;
                    }
                    if (c1 == c2) {
                        ++i;
                        ++begin;
                        continue;
                    }
                    break block5;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreAsciiCase(String str, String prefix) {
        block5: {
            int n = prefix.length();
            if (n <= str.length()) {
                for (int i = 0; i != n; ++i) {
                    int c1 = str.charAt(i);
                    int c2 = prefix.charAt(i);
                    if (65 <= c1 && c1 <= 90) {
                        c1 += 32;
                    }
                    if (65 <= c2 && c2 <= 90) {
                        c2 += 32;
                    }
                    if (c1 == c2) {
                        continue;
                    }
                    break block5;
                }
                return true;
            }
        }
        return false;
    }

    public static String toString(char[] array, int begin, int end) {
        int length = end - begin;
        return length != 0 ? new String(array, begin, length) : "";
    }

    public static String toLowerCase(String s) {
        int i;
        int n = s.length();
        for (i = 0; i != n; ++i) {
            int test = s.charAt(i);
            if (test > 127) {
                return s.toLowerCase();
            }
            if (0 <= (test -= 65) && test <= 25) break;
        }
        if (i == n) {
            return s;
        }
        char[] cc = new char[n];
        s.getChars(0, n, cc, 0);
        CharKit.asciiToLowerCase(cc, i, n);
        return new String(cc, 0, n);
    }

    public static long parseInt(char[] array, int begin, int end) {
        int digit;
        if (begin == end) {
            return -1L;
        }
        boolean lessThenZero = false;
        int min = -2147483647;
        int limit = -214748364;
        char c = array[begin];
        if (c == '-' || c == '+') {
            if (++begin == end) {
                return -1L;
            }
            if (c == '-') {
                lessThenZero = true;
                min = Integer.MIN_VALUE;
                limit = -214748364;
            }
            c = array[begin];
        }
        if (0 > (digit = c - 48) || digit > 9) {
            return -1L;
        }
        int number = -digit;
        while (++begin != end) {
            digit = array[begin] - 48;
            if (0 > digit || digit > 9) {
                return -1L;
            }
            int nr = number * 10;
            if (number < limit || nr < min + digit) {
                return -1L;
            }
            number = nr - digit;
        }
        if (!lessThenZero) {
            number = -number;
        }
        return 0xFFFFFFFFL & (long)number;
    }

    public static long parseInt(String s) {
        return CharKit.parseInt(s, 0, s.length());
    }

    public static long parseInt(String s, int begin, int end) {
        int digit;
        if (begin == end) {
            return -1L;
        }
        boolean lessThenZero = false;
        int min = -2147483647;
        int limit = -214748364;
        char c = s.charAt(begin);
        if (c == '-' || c == '+') {
            if (++begin == end) {
                return -1L;
            }
            if (c == '-') {
                lessThenZero = true;
                min = Integer.MIN_VALUE;
                limit = -214748364;
            }
            c = s.charAt(begin);
        }
        if (0 > (digit = c - 48) || digit > 9) {
            return -1L;
        }
        int number = -digit;
        while (++begin != end) {
            digit = s.charAt(begin) - 48;
            if (0 > digit || digit > 9) {
                return -1L;
            }
            int nr = number * 10;
            if (number < limit || nr < min + digit) {
                return -1L;
            }
            number = nr - digit;
        }
        if (!lessThenZero) {
            number = -number;
        }
        return 0xFFFFFFFFL & (long)number;
    }

    public static String[] split(int separator, String str) {
        return CharKit.split(separator, str, false);
    }

    public static String[] split(int separator, String str, boolean skipEmpty) {
        return CharKit.split_r(separator, str, skipEmpty, 0, 0);
    }

    private static String[] split_r(int separator, String str, boolean skipEmpty, int count, int pos) {
        int new_pos = str.indexOf(separator, pos);
        boolean lastRecursion = false;
        if (new_pos < 0) {
            new_pos = str.length();
            lastRecursion = true;
        }
        int new_count = count;
        if (new_pos != pos || !skipEmpty) {
            ++new_count;
        }
        String[] result = lastRecursion ? (new_count == 0 ? Defs.EMPTY_STRING_ARRAY : new String[new_count]) : CharKit.split_r(separator, str, skipEmpty, new_count, new_pos + 1);
        if (pos != new_pos) {
            result[count] = str.substring(pos, new_pos);
        } else if (!skipEmpty) {
            result[count] = "";
        }
        return result;
    }
}

