/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.BrowserWindow;
import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.WindowManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

final class SourceWindow
extends JFrame
implements ActionListener {
    private final WindowManager windowManager;
    private final Resources res;
    private JTextArea sourcePanel;
    private Font displayFont;
    private JMenuItem print;
    private JMenuItem selectAll;
    private JMenuItem copy;
    private static final double SIZE_FACTOR = 0.9;

    public SourceWindow(BrowserWindow window) {
        this.windowManager = window.windowManager;
        PropertiesManager properties = window.properties;
        this.res = properties.res;
        this.displayFont = properties.getFont("document.fixedfont", null);
        if (this.displayFont == null) {
            this.displayFont = new Font("Monospaced", 0, 12);
        }
        String title = this.res.str("sourcedialog.title");
        String urlTitle = window.urlTitle;
        if (urlTitle != null) {
            title = title + " - " + urlTitle;
        }
        this.setTitle(title);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        int width = properties.getInt("application.width");
        int height = properties.getInt("application.height");
        this.setSize((int)((double)width * 0.9), (int)((double)height * 0.9));
        JMenu sourceMenu = new JMenu(this.res.str("sourcedialog.menu1"));
        this.print = new JMenuItem(this.res.str("menu.print"));
        this.print.addActionListener(this);
        this.selectAll = new JMenuItem(this.res.str("menu.selectall"));
        this.selectAll.addActionListener(this);
        this.copy = new JMenuItem(this.res.str("menu.copy"));
        this.copy.addActionListener(this);
        sourceMenu.add(this.selectAll);
        sourceMenu.add(this.copy);
        JMenuBar sourceMenuBar = new JMenuBar();
        sourceMenuBar.add(sourceMenu);
        this.setJMenuBar(sourceMenuBar);
        this.sourcePanel = new JTextArea();
        this.sourcePanel.setEditable(false);
        this.sourcePanel.setFont(this.displayFont);
        JScrollPane scrollPane = new JScrollPane(this.sourcePanel);
        this.getContentPane().add(scrollPane);
        if (this.readSource(window)) {
            this.setVisible(true);
        } else {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.print) {
            this.windowManager.print(this.sourcePanel.getText());
        } else if (ev.getSource() == this.selectAll) {
            this.sourcePanel.selectAll();
        } else if (ev.getSource() == this.copy) {
            this.sourcePanel.copy();
        }
    }

    private boolean readSource(BrowserWindow window) {
        Reader r = null;
        try {
            r = window.getHTMLSource();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (r == null) {
            this.res.displayError("sourcedialog.invaliddoc");
            return false;
        }
        BufferedReader br = new BufferedReader(r);
        StringBuffer text = new StringBuffer("");
        try {
            String line;
            while ((line = br.readLine()) != null) {
                text.append(line + "\n");
            }
            br.close();
            r.close();
        }
        catch (IOException ex) {
            this.res.displayError("sourcedialog.read_error");
            return false;
        }
        this.sourcePanel.setText(text.toString());
        return true;
    }
}

