/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.ri.swing.StringResource;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Resources
extends StringResource {
    private static final String RES_PATH = "ice/ri/swing/res/";
    public static final String PROPERTY_SUFFIX = ".properties";
    public static final String LOCALE_DIR_NAME_PREFIX = "loc_";
    ClassLoader class_loader = this.getClass().getClassLoader();
    Locale locale;
    Properties user_strings;
    private static Resources res;
    private final JFrame baseFrame = new JFrame();

    public static Resources getInstance() {
        return res;
    }

    public static String makeResPath(String prefix, String base_name) {
        if (prefix != null) {
            if (!prefix.endsWith("/")) {
                Debug.bug();
            }
            if (prefix.startsWith("/")) {
                Debug.bug();
            }
        }
        if (base_name.length() != 0 && base_name.charAt(0) == '/') {
            return base_name.substring(1, base_name.length());
        }
        if (prefix == null) {
            return base_name;
        }
        return prefix + base_name;
    }

    public static InputStream getResourceAsStream(ClassLoader cl, String prefix, String resourcePath) {
        InputStream result;
        int colon = resourcePath.indexOf(58);
        if (colon >= 0 && resourcePath.lastIndexOf(colon - 1, 47) < 0) {
            try {
                return new URL(resourcePath).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        resourcePath = Resources.makeResPath(prefix, resourcePath);
        if (cl != null && (result = cl.getResourceAsStream(resourcePath)) != null) {
            return result;
        }
        return ClassLoader.getSystemResourceAsStream(resourcePath);
    }

    public static URL getResource(ClassLoader cl, String prefix, String resourcePath) {
        URL result;
        int colon = resourcePath.indexOf(58);
        if (colon >= 0 && resourcePath.lastIndexOf(colon - 1, 47) < 0) {
            try {
                return new URL(resourcePath);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        resourcePath = Resources.makeResPath(prefix, resourcePath);
        if (cl != null && (result = cl.getResource(resourcePath)) != null) {
            return result;
        }
        return ClassLoader.getSystemResource(resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLocaleProperties(ClassLoader cl, Locale locale, Properties default_properties, String path_prefix, String base_name) {
        if (!path_prefix.endsWith("/")) {
            Debug.bug();
        }
        int path_prefix_len = path_prefix.length();
        int locale_prefix_len = LOCALE_DIR_NAME_PREFIX.length();
        int prefix_len = path_prefix_len + locale_prefix_len;
        String locale_str = locale.toString();
        StringBuffer sb = new StringBuffer(prefix_len + locale_prefix_len + locale_str.length() + 1 + base_name.length());
        sb.append(path_prefix);
        int locale_cursor = -1;
        boolean last_time = false;
        Properties properties = default_properties;
        while (true) {
            sb.append(base_name);
            InputStream is = Resources.getResourceAsStream(cl, null, sb.toString());
            if (is != null) {
                try {
                    Properties p = properties == null ? new Properties() : new Properties(properties);
                    p.load(is);
                    properties = p;
                }
                catch (IOException e) {
                    if (Debug.ex) {
                        Debug.ex(e);
                    }
                }
                finally {
                    block18: {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (!Debug.ex) break block18;
                            Debug.ex(e);
                        }
                    }
                }
            }
            if (last_time) break;
            sb.setLength(path_prefix_len);
            sb.append(LOCALE_DIR_NAME_PREFIX);
            sb.append(locale_str);
            locale_cursor = locale_str.indexOf(95, locale_cursor + 1);
            if (locale_cursor >= 0) {
                sb.setLength(prefix_len + locale_cursor);
            } else {
                last_time = true;
            }
            sb.append('/');
        }
        return properties;
    }

    public static URL getLocaleURL(ClassLoader cl, Locale locale, String path_prefix, String base_name) {
        if (!path_prefix.endsWith("/")) {
            Debug.bug();
        }
        int path_prefix_len = path_prefix.length();
        int locale_prefix_len = LOCALE_DIR_NAME_PREFIX.length();
        int prefix_len = path_prefix_len + locale_prefix_len;
        String locale_str = locale.toString();
        int locale_part = locale_str.length();
        StringBuffer sb = new StringBuffer(prefix_len + locale_part + 1 + base_name.length());
        sb.append(path_prefix);
        sb.append(LOCALE_DIR_NAME_PREFIX);
        while (true) {
            sb.append(locale_str);
            sb.setLength(prefix_len + locale_part);
            sb.append('/');
            sb.append(base_name);
            URL url = Resources.getResource(cl, null, sb.toString());
            if (url != null) {
                return url;
            }
            if ((locale_part = locale_str.lastIndexOf(95, locale_part - 1)) < 0) break;
            sb.setLength(prefix_len);
        }
        sb.setLength(path_prefix_len);
        sb.append(base_name);
        return Resources.getResource(cl, null, sb.toString());
    }

    private static boolean prop_space(int c) {
        return c == 32 || c == 9 || c == 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load_properties(Properties prop, InputStream input_stream) throws IOException {
        char[] buffer = new char[200];
        InputStreamReader r = new InputStreamReader(input_stream);
        int cursor = 0;
        while (true) {
            int c;
            block26: {
                if ((c = ((Reader)r).read()) == 35 || c == 33) {
                    while ((c = ((Reader)r).read()) >= 0) {
                        if (c != 10 && c != 13) continue;
                        break block26;
                    }
                    return;
                }
                if (Resources.prop_space(c) || c == 13 || c == 10) continue;
            }
            while (c != 61 && c != 58 && !Resources.prop_space(c) && c != 10 && c >= 0) {
                if (cursor == buffer.length) {
                    char[] tmp = new char[cursor * 2];
                    System.arraycopy(buffer, 0, tmp, 0, cursor);
                    buffer = tmp;
                }
                buffer[cursor] = (char)c;
                ++cursor;
                c = ((Reader)r).read();
            }
            String key = new String(buffer, 0, cursor);
            while (Resources.prop_space(c)) {
                c = ((Reader)r).read();
            }
            if (c == 61 || c == 58) {
                c = ((Reader)r).read();
            }
            while (Resources.prop_space(c)) {
                c = ((Reader)r).read();
            }
            cursor = 0;
            block15: while (c >= 0 && c != 13 && c != 10) {
                boolean need_to_read = true;
                int code = c;
                if (c == 92) {
                    c = ((Reader)r).read();
                    switch (c) {
                        default: {
                            code = c;
                            break;
                        }
                        case -1: {
                            break block15;
                        }
                        case 92: {
                            code = 92;
                            break;
                        }
                        case 13: {
                            c = ((Reader)r).read();
                            if (c != 10 && !Resources.prop_space(c)) continue block15;
                        }
                        case 10: {
                            while (Resources.prop_space(c = ((Reader)r).read())) {
                            }
                            continue block15;
                        }
                        case 110: {
                            code = 10;
                            break;
                        }
                        case 116: {
                            code = 9;
                            break;
                        }
                        case 114: {
                            code = 13;
                            break;
                        }
                        case 117: {
                            int i;
                            code = 0;
                            for (i = 0; i != 4; ++i) {
                                c = ((Reader)r).read() - 48;
                                if (0 <= c || c <= 9) {
                                    code <<= 4;
                                    code |= c;
                                    continue;
                                }
                                if (0 <= (c -= 49) || c <= 5) {
                                    code <<= 4;
                                    code |= c + 10;
                                    continue;
                                }
                                if (0 <= (c += 32) || c <= 5) {
                                    code <<= 4;
                                    code |= c + 10;
                                    continue;
                                }
                                c += 65;
                                break;
                            }
                            if (i == 4) break;
                            need_to_read = false;
                        }
                    }
                }
                if (cursor == buffer.length) {
                    char[] tmp = new char[cursor * 2];
                    System.arraycopy(buffer, 0, tmp, 0, cursor);
                    buffer = tmp;
                }
                buffer[cursor] = (char)code;
                ++cursor;
                if (!need_to_read) continue;
                c = ((Reader)r).read();
            }
            String value = new String(buffer, 0, cursor);
            prop.put(key, value);
            if (c == -1) return;
        }
    }

    public Resources() {
        this.setLocale(Locale.getDefault());
        Toolkit t = this.getBaseFrame().getToolkit();
        Dimension d = t.getScreenSize();
        this.getBaseFrame().setBounds(0, 0, d.width, d.height);
        res = this;
    }

    public URL getResource(String prefix, String resourcePath) {
        return Resources.getResource(this.class_loader, prefix, resourcePath);
    }

    public InputStream getResourceAsStream(String prefix, String resourcePath) {
        return Resources.getResourceAsStream(this.class_loader, prefix, resourcePath);
    }

    public URL propertiesURL(String name) {
        return this.getResource(RES_PATH, name);
    }

    public InputStream propertiesStream(String name) {
        return this.getResourceAsStream(RES_PATH, name);
    }

    public URL imageURL(String name) {
        return this.getResource("ice/ri/swing/res/images/", name);
    }

    public Image image(Toolkit toolkit, String name) {
        return toolkit.getImage(this.imageURL(name));
    }

    public ImageIcon imageIcon(Toolkit toolkit, String name) {
        return new ImageIcon(this.image(toolkit, name));
    }

    public URL helpURL(String name) {
        return Resources.getLocaleURL(this.class_loader, this.locale, RES_PATH, "help/" + name);
    }

    public URL errorURL(String name) {
        return Resources.getLocaleURL(this.class_loader, this.locale, RES_PATH, name);
    }

    public void setLocale(Locale locale_arg) {
        this.locale = locale_arg;
        this.user_strings = Resources.getLocaleProperties(this.class_loader, locale_arg, null, RES_PATH, "strings.properties");
    }

    public String getPatternValue(String key) {
        String value;
        if (this.user_strings != null && (value = this.user_strings.getProperty(key)) != null) {
            return value;
        }
        return null;
    }

    public void displayError(String key) {
        this.displayError(key, true);
    }

    public void displayError(String key, Object arg) {
        this.displayError(key, arg, true);
    }

    public void displayError(String key, Object arg1, Object arg2) {
        this.displayError(key, arg1, arg2, true);
    }

    public void displayError(String key, boolean warning_title) {
        this.displayFormatedError(this.str(key), warning_title);
    }

    public void displayError(String key, Object arg, boolean warning_title) {
        this.displayFormatedError(this.str(key, arg), warning_title);
    }

    public void displayError(String key, Object arg1, Object arg2, boolean warning_title) {
        this.displayFormatedError(this.str(key, arg1, arg2), warning_title);
    }

    public void displayFormatedError(String message, boolean warning_title) {
        JOptionPane.showMessageDialog(this.getBaseFrame(), message, this.str(warning_title ? "title.warning" : "title.error"), 0);
    }

    public boolean displayYesOrNo(String message_key) {
        return this.displayFormatedYesOrNow(this.str(message_key));
    }

    public boolean displayYesOrNo(String message_key, String arg) {
        return this.displayFormatedYesOrNow(this.str(message_key, arg));
    }

    public boolean displayYesOrNo(String message_key, String arg1, String arg2) {
        return this.displayFormatedYesOrNow(this.str(message_key, arg1, arg2));
    }

    public boolean displayFormatedYesOrNow(String message) {
        int result = JOptionPane.showConfirmDialog(this.getBaseFrame(), message, this.str("title.confirmation"), 0);
        return result == 0;
    }

    public Toolkit getToolkit() {
        return this.getBaseFrame().getToolkit();
    }

    public JFrame getBaseFrame() {
        return this.baseFrame;
    }
}

