/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

final class MultiLabel
extends Component {
    private Dimension prefSize = new Dimension();
    private String[] lines = new String[0];
    private boolean drawBorder = false;
    private int maxChars = 0;

    public MultiLabel() {
    }

    public MultiLabel(String s, int maxChars) {
        this.maxChars = maxChars;
        this.setText(s, false);
    }

    public void setMaxChars(int m) {
        this.maxChars = m;
    }

    public void setText(String s, boolean drawBorder) {
        this.drawBorder = drawBorder;
        s = s.replace('\t', ' ');
        StringTokenizer st = new StringTokenizer(s, "\n\r", false);
        if (this.maxChars <= 0 || s.length() <= this.maxChars) {
            this.lines = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.lines[i++] = st.nextToken();
            }
        } else {
            Vector<String> v = new Vector<String>();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                while (t.length() > this.maxChars) {
                    v.addElement(t.substring(0, this.maxChars));
                    t = t.substring(this.maxChars);
                }
                v.addElement(t);
            }
            this.lines = new String[v.size()];
            v.copyInto(this.lines);
        }
    }

    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String[] tt = this.lines;
        if (tt == null) {
            return null;
        }
        for (int i = 0; i < tt.length; ++i) {
            int t = fm.stringWidth(tt[i]);
            if (t > w) {
                w = t;
            }
            h += fm.getHeight();
        }
        this.prefSize.width = w + 6;
        this.prefSize.height = h + 2;
        return this.prefSize;
    }

    public void paint(Graphics g) {
        String[] tt = this.lines;
        if (tt == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int y = fm.getAscent();
        int dy = fm.getHeight();
        int i = 0;
        while (i < tt.length) {
            g.drawString(tt[i], 3, y);
            ++i;
            y += dy;
        }
        if (this.drawBorder) {
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

