/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.search;

import ice.pilots.html4.DNode;
import ice.pilots.html4.Search;
import ice.pilots.html4.ThePilot;
import ice.ri.common.search.SearchStatusEventListener;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Node;

public class SearchHelper
implements PropertyChangeListener {
    public static int NO_MATCH_FOUND = 0;
    public static int END_OF_SEARCH = 1;
    public static int MATCH_FOUND = 2;
    public static int RESET_ALL = 3;
    public static int RESET_HIGHLIGHT = 4;
    private Vector statusChangeEventListeners;
    private Viewport topLevelViewport;
    private Viewport currentViewport;
    private Vector searchRecordList;
    private String searchText;
    private boolean isHighlighted;
    private boolean isWordSearch;
    private boolean isCaseSensitiveSearch;
    private boolean hasFoundOne;
    private boolean topLevelRenderingDone;
    private boolean resetting;

    public SearchHelper(Viewport viewport) {
        this.topLevelViewport = viewport;
        this.searchRecordList = new Vector();
    }

    public void init() {
        if (!this.searchRecordList.isEmpty()) {
            return;
        }
        this.buildSearchRecordList(this.topLevelViewport);
        if (!this.searchRecordList.isEmpty()) {
            SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(0);
            this.currentViewport = record.viewport;
        } else {
            this.currentViewport = this.topLevelViewport;
        }
        this.topLevelRenderingDone = true;
        this.resetting = false;
        this.topLevelViewport.addPropertyChangeListener(this);
    }

    public void dispose() {
        this.topLevelViewport.removePropertyChangeListener(this);
        if (this.statusChangeEventListeners != null) {
            this.statusChangeEventListeners.removeAllElements();
        }
        this.clearSearchRecordList();
        this.topLevelRenderingDone = true;
        this.resetting = false;
    }

    private void resetSearchList(Viewport viewport) {
        if (viewport == this.topLevelViewport) {
            this.clearSearchRecordList();
            this.buildSearchRecordList(this.topLevelViewport);
            if (!this.searchRecordList.isEmpty()) {
                SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(0);
                this.currentViewport = record.viewport;
            } else {
                this.currentViewport = this.topLevelViewport;
            }
        } else if (this.topLevelRenderingDone) {
            this.buildSearchRecordListOnBranch(viewport);
        } else {
            this.resetHighlight();
        }
    }

    public void findNext() {
        this.findNextMatch(true);
    }

    private void findNextMatch(boolean fireEvent) {
        int i;
        if (this.searchText == null || this.searchText.length() == 0) {
            return;
        }
        boolean found = false;
        int idx = this.getCurrentSearchRecordIndex();
        SearchRecord record = this.getSearchRecordByIndex(idx);
        Search search = record.search;
        if (search != null) {
            found = search.findNext();
        }
        if (found) {
            this.hasFoundOne = found;
            if (fireEvent) {
                this.fireSearchStatusMessageEvent(MATCH_FOUND, 0);
            }
        } else {
            for (i = idx + 1; i < this.searchRecordList.size() && !found; ++i) {
                record = this.getSearchRecordByIndex(i);
                if (record == null || (search = record.search) == null) continue;
                found = search.findNext();
                if (!found) {
                    found = search.findNext();
                }
                if (!found) continue;
                this.hasFoundOne = found;
                this.currentViewport = record.viewport;
                this.activateViewport(this.currentViewport);
                if (!fireEvent) continue;
                this.fireSearchStatusMessageEvent(MATCH_FOUND, 0);
            }
        }
        if (!found) {
            if (!this.hasFoundOne) {
                if (fireEvent) {
                    this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
                }
            } else {
                this.fireSearchStatusMessageEvent(END_OF_SEARCH, 0);
                for (i = 0; i < this.searchRecordList.size() && !found; ++i) {
                    record = this.getSearchRecordByIndex(i);
                    if (record == null || (search = record.search) == null) continue;
                    found = search.findNext();
                    if (!found) {
                        found = search.findNext();
                    }
                    if (!found) continue;
                    this.currentViewport = record.viewport;
                    this.activateViewport(this.currentViewport);
                }
            }
        }
    }

    public void findPrevious() {
        int i;
        if (this.searchText == null || this.searchText.length() == 0) {
            return;
        }
        boolean found = false;
        int idx = this.getCurrentSearchRecordIndex();
        SearchRecord record = this.getSearchRecordByIndex(idx);
        Search search = record.search;
        if (search != null) {
            found = search.findPrevious();
        }
        if (found) {
            this.hasFoundOne = found;
            this.fireSearchStatusMessageEvent(MATCH_FOUND, 0);
        } else {
            for (i = idx - 1; i >= 0 && !found; --i) {
                record = this.getSearchRecordByIndex(i);
                if (record == null || (search = record.search) == null) continue;
                found = search.findPrevious();
                if (!found) {
                    found = search.findPrevious();
                }
                if (!found) continue;
                this.hasFoundOne = found;
                this.currentViewport = record.viewport;
                this.activateViewport(this.currentViewport);
                this.fireSearchStatusMessageEvent(MATCH_FOUND, 0);
            }
        }
        if (!found) {
            if (!this.hasFoundOne) {
                this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
            } else {
                this.fireSearchStatusMessageEvent(END_OF_SEARCH, 0);
                for (i = this.searchRecordList.size() - 1; i >= 0 && !found; --i) {
                    record = this.getSearchRecordByIndex(i);
                    if (record == null || (search = record.search) == null) continue;
                    found = search.findPrevious();
                    if (!found) {
                        found = search.findPrevious();
                    }
                    if (!found) continue;
                    this.currentViewport = record.viewport;
                    this.activateViewport(this.currentViewport);
                }
            }
        }
    }

    public void setHighlighted(boolean b) {
        if (this.resetting) {
            return;
        }
        this.isHighlighted = b;
        Enumeration enumeration = this.searchRecordList.elements();
        if (enumeration != null) {
            this.hasFoundOne = false;
            int nMatches = 0;
            while (enumeration.hasMoreElements()) {
                SearchRecord record = (SearchRecord)enumeration.nextElement();
                Search search = record.search;
                if (search == null) {
                    search = this.createSearch(record);
                } else if (search.isHighlightSearches() != this.isHighlighted) {
                    search.setHightlightSearches(this.isHighlighted);
                }
                if (search == null) continue;
                int nFound = search.searchDocument(false);
                nMatches += nFound;
                if (!b || nFound <= 0 || this.hasFoundOne) continue;
                this.hasFoundOne = true;
            }
            if (b && this.searchText != null && this.searchText.length() != 0) {
                if (this.hasFoundOne) {
                    this.fireSearchStatusMessageEvent(MATCH_FOUND, nMatches);
                } else {
                    this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
                }
            }
        }
    }

    public boolean isHighlighed() {
        return this.isHighlighted;
    }

    public void setCaseSensitiveEnabled(boolean b) {
        if (this.resetting) {
            return;
        }
        this.isCaseSensitiveSearch = b;
        Enumeration enumeration = this.searchRecordList.elements();
        if (enumeration != null) {
            this.hasFoundOne = false;
            int nMatches = 0;
            Viewport activeViewport = this.getActiveViewport();
            while (enumeration.hasMoreElements()) {
                Search search;
                SearchRecord record = (SearchRecord)enumeration.nextElement();
                if (record.viewport == activeViewport) {
                    this.activateViewport(activeViewport);
                    this.currentViewport = activeViewport;
                }
                if ((search = record.search) == null) {
                    search = this.createSearch(record);
                } else if (search.getMatchCase() != this.isCaseSensitiveSearch) {
                    search.setMatchCase(this.isCaseSensitiveSearch);
                }
                if (search == null) continue;
                int nFound = search.searchDocument(true);
                nMatches += nFound;
                if (nFound <= 0 || this.hasFoundOne) continue;
                this.hasFoundOne = true;
            }
            if (this.searchText != null && this.searchText.length() != 0) {
                if (this.hasFoundOne) {
                    this.fireSearchStatusMessageEvent(MATCH_FOUND, nMatches);
                } else {
                    this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
                }
            }
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public boolean isCaseSensitiveEnabled() {
        return this.isCaseSensitiveSearch;
    }

    public void setWordSearchEnabled(boolean b) {
        if (this.resetting) {
            return;
        }
        this.isWordSearch = b;
        Enumeration enumeration = this.searchRecordList.elements();
        if (enumeration != null) {
            this.hasFoundOne = false;
            int nMatches = 0;
            Viewport activeViewport = this.getActiveViewport();
            while (enumeration.hasMoreElements()) {
                Search search;
                SearchRecord record = (SearchRecord)enumeration.nextElement();
                if (record.viewport == activeViewport) {
                    this.activateViewport(activeViewport);
                    this.currentViewport = activeViewport;
                }
                if ((search = record.search) == null) {
                    search = this.createSearch(record);
                } else if (search.getWholeWordSearch() != this.isWordSearch) {
                    search.setWholeWordSearch(this.isWordSearch);
                }
                if (search == null) continue;
                int nFound = search.searchDocument(true);
                nMatches += nFound;
                if (nFound <= 0 || this.hasFoundOne) continue;
                this.hasFoundOne = true;
            }
            if (this.searchText != null && this.searchText.length() != 0) {
                if (this.hasFoundOne) {
                    this.fireSearchStatusMessageEvent(MATCH_FOUND, nMatches);
                } else {
                    this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
                }
            }
        }
    }

    public boolean isWordSearchEnabled() {
        return this.isWordSearch;
    }

    public void setSearchText(String text) {
        if (this.searchText == null || !this.searchText.equals(text)) {
            this.searchText = text;
            Enumeration enumeration = this.searchRecordList.elements();
            if (enumeration != null) {
                this.hasFoundOne = false;
                int nMatches = 0;
                boolean matchFoundInActiveViewport = true;
                Viewport activeViewport = this.getActiveViewport();
                while (enumeration.hasMoreElements()) {
                    SearchRecord record = (SearchRecord)enumeration.nextElement();
                    Search search = record.search;
                    if (search == null) {
                        search = this.createSearch(record);
                    } else {
                        String preText = search.getSearchText();
                        if (this.searchText == null || preText == null || !preText.equals(this.searchText)) {
                            search.setSearchText(this.searchText);
                        }
                    }
                    if (search == null) continue;
                    int nFound = 0;
                    if (record.viewport == activeViewport) {
                        this.activateViewport(activeViewport);
                        this.currentViewport = activeViewport;
                        nFound = search.searchDocument(true);
                        matchFoundInActiveViewport = nFound > 0;
                    } else {
                        nFound = search.searchDocument(false);
                    }
                    nMatches += nFound;
                    if (nFound <= 0 || this.hasFoundOne) continue;
                    this.hasFoundOne = true;
                }
                if (!matchFoundInActiveViewport) {
                    this.findNextMatch(false);
                }
                if (this.searchText != null && this.searchText.length() != 0) {
                    if (this.hasFoundOne) {
                        this.fireSearchStatusMessageEvent(MATCH_FOUND, nMatches);
                    } else {
                        this.fireSearchStatusMessageEvent(NO_MATCH_FOUND, 0);
                    }
                }
            }
        }
    }

    private void resetAll() {
        this.resetting = true;
        this.isHighlighted = false;
        this.isWordSearch = false;
        this.hasFoundOne = false;
        this.isCaseSensitiveSearch = false;
        this.fireSearchResetEvent(RESET_ALL);
        this.resetting = false;
    }

    private void resetHighlight() {
        this.resetting = true;
        this.isHighlighted = false;
        this.fireSearchResetEvent(RESET_HIGHLIGHT);
        this.resetting = false;
    }

    private Search createSearch(SearchRecord record) {
        Search aSearch = null;
        Pilot p = record.viewport.getPilot();
        aSearch = ((ThePilot)p).getSearch();
        aSearch.setMatchCase(this.isCaseSensitiveSearch);
        aSearch.setWholeWordSearch(this.isWordSearch);
        aSearch.setHightlightSearches(this.isHighlighted);
        aSearch.setSearchText(this.searchText);
        record.search = aSearch;
        return aSearch;
    }

    private int getCurrentSearchRecordIndex() {
        int count = this.searchRecordList.size();
        for (int i = 0; i < count; ++i) {
            SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(i);
            if (record.viewport != this.currentViewport) continue;
            this.activateViewport(this.currentViewport);
            if (record.search == null) {
                Search aSearch = this.createSearch(record);
            }
            return i;
        }
        return 0;
    }

    private void activateViewport(Viewport viewport) {
        Pilot pilot = viewport.getPilot();
        pilot.viewportBecameActive();
    }

    private SearchRecord getSearchRecordByIndex(int index) {
        SearchRecord record = null;
        int count = this.searchRecordList.size();
        if (index >= 0 && index < count) {
            record = (SearchRecord)this.searchRecordList.elementAt(index);
            if (record.search == null) {
                Search aSearch = this.createSearch(record);
            }
        }
        return record;
    }

    public boolean isSearchReady() {
        return this.topLevelRenderingDone;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object newValue = e.getNewValue();
        if (name.equals("contentLoading")) {
            Viewport v;
            if (newValue.equals("begin") && (v = (Viewport)e.getSource()) == this.topLevelViewport) {
                this.topLevelRenderingDone = false;
                this.fireSearchEnabledEvent(false);
            }
        } else if (name.equals("contentRendering") && newValue.equals("finished")) {
            Viewport v = (Viewport)e.getSource();
            if (v == this.topLevelViewport) {
                this.topLevelRenderingDone = true;
            }
            this.resetSearchList(v);
            if (v == this.topLevelViewport) {
                this.resetAll();
                this.fireSearchEnabledEvent(true);
            }
        }
    }

    private Viewport getActiveViewport() {
        Pilot p = this.topLevelViewport.getPilot();
        Viewport currentActiveViewport = null;
        if (p instanceof ThePilot) {
            ThePilot pp = (ThePilot)p;
            currentActiveViewport = pp.getStorm().getActiveViewport();
        }
        Viewport activeViewport = null;
        boolean isCurrentViewportinList = false;
        int count = this.searchRecordList.size();
        if (currentActiveViewport != null) {
            for (int i = 0; i < count; ++i) {
                SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(i);
                if (record.viewport == currentActiveViewport) {
                    activeViewport = currentActiveViewport;
                }
                if (this.currentViewport == null || record.viewport != this.currentViewport) continue;
                isCurrentViewportinList = true;
            }
        }
        if (activeViewport == null && count > 0) {
            if (isCurrentViewportinList) {
                activeViewport = this.currentViewport;
            } else {
                SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(0);
                activeViewport = this.currentViewport = record.viewport;
            }
        }
        return activeViewport;
    }

    public synchronized void addSearchStatusEventListener(SearchStatusEventListener l) {
        if (this.statusChangeEventListeners == null) {
            this.statusChangeEventListeners = new Vector();
        }
        this.statusChangeEventListeners.addElement(l);
    }

    public synchronized void removeSearchStatusEventListener(SearchStatusEventListener l) {
        if (this.statusChangeEventListeners != null) {
            int count = this.statusChangeEventListeners.size();
            for (int i = 0; i < count; ++i) {
                if (this.statusChangeEventListeners.elementAt(i) != l) continue;
                this.statusChangeEventListeners.removeElementAt(i);
            }
        }
    }

    public synchronized void removeAllSearchStatusEventListeners() {
        if (this.statusChangeEventListeners != null && !this.statusChangeEventListeners.isEmpty()) {
            this.statusChangeEventListeners.removeAllElements();
        }
    }

    private void fireSearchStatusMessageEvent(int status, int number_of_matches) {
        if (this.statusChangeEventListeners != null && !this.statusChangeEventListeners.isEmpty()) {
            int count = this.statusChangeEventListeners.size();
            for (int i = 0; i < count; ++i) {
                SearchStatusEventListener l = (SearchStatusEventListener)this.statusChangeEventListeners.elementAt(i);
                l.setSearchStatusMessage(status, number_of_matches);
            }
        }
    }

    private void fireSearchEnabledEvent(boolean b) {
        if (this.statusChangeEventListeners != null && !this.statusChangeEventListeners.isEmpty()) {
            int count = this.statusChangeEventListeners.size();
            for (int i = 0; i < count; ++i) {
                SearchStatusEventListener l = (SearchStatusEventListener)this.statusChangeEventListeners.elementAt(i);
                l.setSearchEnabled(b);
            }
        }
    }

    private void fireSearchResetEvent(int signal) {
        if (this.statusChangeEventListeners != null && !this.statusChangeEventListeners.isEmpty()) {
            int count = this.statusChangeEventListeners.size();
            for (int i = 0; i < count; ++i) {
                SearchStatusEventListener l = (SearchStatusEventListener)this.statusChangeEventListeners.elementAt(i);
                l.reset(signal);
            }
        }
    }

    private boolean isFrameset(Viewport viewport) {
        ThePilot pp;
        Node n;
        boolean isFrameset = false;
        Pilot p = viewport.getPilot();
        if (p instanceof ThePilot && (n = (pp = (ThePilot)p).getDDocument().getDocumentDElement()) != null) {
            int nameId;
            for (n = n.getFirstChild(); n != null && (nameId = ((DNode)n).getNameId()) != 13; n = n.getNextSibling()) {
                if (nameId != 34) continue;
                isFrameset = true;
                break;
            }
        }
        return isFrameset;
    }

    private void buildSearchRecordList(Viewport viewport) {
        Pilot p;
        if (!this.isFrameset(viewport) && (p = viewport.getPilot()) != null && p instanceof ThePilot) {
            this.searchRecordList.addElement(new SearchRecord(viewport));
        }
        for (Viewport vv = viewport.getFirstChild(); vv != null; vv = vv.getNextSibling()) {
            this.buildSearchRecordList(vv);
        }
    }

    private void buildSearchRecordListOnBranch(Viewport viewport) {
        Pilot p;
        int recordIndex = -1;
        for (int i = 0; i < this.searchRecordList.size(); ++i) {
            Viewport parent;
            SearchRecord record = (SearchRecord)this.searchRecordList.elementAt(i);
            if (record.viewport == viewport) {
                record.disposeSearch();
                record.search = null;
                recordIndex = i;
                continue;
            }
            for (parent = record.viewport.getParent(); parent != null && parent != viewport; parent = parent.getParent()) {
            }
            if (parent != viewport) continue;
            record.disposeSearch();
            this.searchRecordList.removeElementAt(i);
            --i;
        }
        if (recordIndex == -1 && !this.isFrameset(viewport) && (p = viewport.getPilot()) != null && p instanceof ThePilot) {
            this.searchRecordList.addElement(new SearchRecord(viewport));
        }
    }

    private void clearSearchRecordList() {
        Enumeration enumeration = this.searchRecordList.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                SearchRecord record = (SearchRecord)enumeration.nextElement();
                record.disposeSearch();
            }
        }
        this.searchRecordList.removeAllElements();
    }

    private class SearchRecord {
        Viewport viewport;
        Search search;

        SearchRecord(Viewport viewport) {
            this.viewport = viewport;
        }

        void disposeSearch() {
            if (this.search != null) {
                this.search.dispose();
                this.search = null;
            }
        }
    }
}

