/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormTextArea
extends TextArea
implements EventListener,
ObjectPainter,
TextListener,
Movable {
    private DocView docView;
    private DTextAreaElement text;
    private ObjectBox box;
    private String startValue;

    FormTextArea(DocView docView, DElement e) {
        super(null, 0, 0, 1);
        this.docView = docView;
        e.addEventListener("blur", this, false);
        this.text = (DTextAreaElement)e;
        int rows = e.getAttributeAsInt("rows");
        int cols = e.getAttributeAsInt("cols");
        if (rows < 0) {
            rows = 3;
        }
        if (cols < 0) {
            cols = 20;
        }
        this.setRows(rows + 1);
        this.setColumns(cols + 1);
        String tmp = this.text.getValue();
        if (tmp != null) {
            this.setText(tmp);
        }
        this.checkAttributes(this.text);
        this.addTextListener(this);
        this.enableEvents(28L);
    }

    private void checkAttributes(DElement element) {
        this.setEditable(!this.text.getReadOnly());
        this.setEnabled(!this.text.getDisabled());
        String s = this.text.getValue();
        if (s != null && !s.equals(this.getText())) {
            this.setText(s);
            try {
                this.setCaretPosition(s.length());
            }
            catch (IllegalComponentStateException ex) {
                // empty catch block
            }
        }
        if (this.box != null) {
            int rows = element.getAttributeAsInt("rows");
            int cols = element.getAttributeAsInt("cols");
            if (rows < 0) {
                rows = 3;
            }
            if (cols < 0) {
                cols = 20;
            }
            if (cols != this.getColumns() || rows != this.getRows()) {
                this.setColumns(cols + 1);
                this.setRows(rows);
                this.invalidate();
                this.box.invalidate();
                this.box.reqReflow();
            }
        }
    }

    public void textValueChanged(TextEvent e) {
        this.text.setValue(this.getText());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes(elem);
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    void updateFont() {
        CSSAttribs css;
        Font f;
        if (this.box != null && !(f = (css = this.box.getCSSAttribs()).getFont()).equals(super.getFont())) {
            int currentCaretPosition = this.getCaretPosition();
            Container parent = this.getParent();
            parent.remove(this);
            super.setFont(f);
            parent.add(this);
            try {
                this.setCaretPosition(currentCaretPosition);
            }
            catch (IllegalComponentStateException ex) {
                // empty catch block
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        FormTextArea action = null;
        int id = e.getID();
        if (id == 401 || id == 402) {
            KeyEvent ke = (KeyEvent)e;
            int kc = ke.getKeyCode();
            if (kc == 38 || kc == 40 || kc == 39 || kc == 37) {
                action = this;
            } else if (kc == 9) {
                ke.consume();
            } else if (kc == 65 && id == 401 && ke.isControlDown()) {
                this.selectAll();
                ke.consume();
            }
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            FocusEvent fe;
            super.processEvent(e);
            if (id == 1004) {
                if (this.startValue == null) {
                    this.startValue = this.getText();
                }
            } else if (id == 1005 && !(fe = (FocusEvent)e).isTemporary()) {
                String tmp = this.getText();
                if (!tmp.equals(this.startValue)) {
                    this.text.dispatchChange();
                }
                this.startValue = null;
            }
        }
    }

    public void handleEvent(Event event) {
        DOMEvent de = (DOMEvent)event;
        if (de.getTypeId() == 22) {
            this.select(0, 0);
            return;
        }
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        String widthChar = Defs.sysProperty("ice.pilots.html4.colWidthChar");
        Dimension dim = super.getPreferredSize();
        if (widthChar == null || widthChar.length() != 1) {
            return dim;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            FontMetrics metrics = this.getFontMetrics(this.box.getCSSAttribs().getFont());
            int width = this.getColumns() * metrics.charWidth(widthChar.charAt(0));
            return new Dimension(width, dim.height);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width - this.docView.vbar.getSize().width;
    }
}

