/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormSelectList
extends List
implements Runnable,
DSelectElement.SelectPainter,
ItemListener,
Movable,
EventListener {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private boolean ignoreItemChange;
    boolean onMyWay = false;

    FormSelectList(DocView docView, DElement e, int numRows) {
        super(numRows);
        this.docView = docView;
        this.sel = (DSelectElement)e;
        if (this.sel.getMultiple()) {
            this.setMultipleMode(true);
        }
        this.copyOptionsToView();
        this.checkAttributes();
        this.addItemListener(this);
        this.enableEvents(28L);
    }

    private void copyOptionsToView() {
        int i;
        int n = this.getItemCount();
        DOptionElement opt = this.sel.firstDOption();
        for (i = 0; i < n && opt != null; ++i) {
            String s1 = this.getItem(i);
            String s2 = opt.getTextOrEmptyString();
            if (s1.length() != s2.length() || !s1.equals(s2)) break;
            opt = this.sel.nextDOption(opt);
        }
        if (i == n && opt == null) {
            return;
        }
        this.ignoreItemChange = true;
        this.removeAll();
        opt = this.sel.firstDOption();
        i = 0;
        while (opt != null) {
            this.add(opt.getTextOrEmptyString());
            if (opt.getSelected()) {
                this.select(i);
            }
            opt = this.sel.nextDOption(opt);
            ++i;
        }
        this.ignoreItemChange = false;
    }

    private void updateSelection() {
        this.ignoreItemChange = true;
        DOptionElement opt = this.sel.firstDOption();
        int i = 0;
        while (opt != null) {
            if (opt.getSelected()) {
                this.select(i);
            } else {
                this.deselect(i);
            }
            opt = this.sel.nextDOption(opt);
            ++i;
        }
        this.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.setEnabled(!this.sel.getDisabled());
    }

    public void itemStateChanged(ItemEvent e) {
        Object item;
        if (!this.ignoreItemChange && (item = e.getItem()) instanceof Integer) {
            int idx = (Integer)item;
            this.sel.setSelectedIndexByUser(idx);
        }
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void run() {
        this.onMyWay = false;
        this.copyOptionsToView();
    }

    public void onOptionStructChange() {
        if (!this.onMyWay) {
            this.onMyWay = true;
            this.docView.getPilot().getStorm().runOnEventThreadLater(this, 100L);
        }
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement opt, DAttr attr) {
        int i = this.sel.getOptionIndex(opt);
        if (i >= 0 && i < this.getItemCount()) {
            this.ignoreItemChange = true;
            String s = opt.getLabel();
            if (s != null && !this.getItem(i).equals(s)) {
                this.replaceItem(s, i);
                this.box.invalidate();
                this.box.reqReflow();
            }
            this.ignoreItemChange = false;
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
        if (box != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        super.doLayout();
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        KeyEvent ke;
        int keyCode;
        FormSelectList action = null;
        if (e instanceof KeyEvent && ((keyCode = (ke = (KeyEvent)e).getKeyCode()) == 38 || keyCode == 40)) {
            action = this;
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            super.processEvent(e);
        }
    }

    public void handleEvent(Event event) {
        if (((DOMEvent)event).getTypeId() == 22) {
            return;
        }
        DOMUIEvent de = (DOMUIEvent)event;
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    public void setFontHints(CSSAttribs css) {
        Font f = css.getFont();
        if (!f.equals(this.getFont())) {
            this.setFont(f);
        }
    }

    public void setFont(Font font) {
        Container _parent = this.getParent();
        _parent.remove(this);
        super.setFont(font);
        _parent.add(this);
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width - this.docView.vbar.getSize().width;
    }
}

