/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends TextField
implements EventListener,
ObjectPainter,
TextListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private int maxLength = 10000;
    private String startValue;

    FormInputText(DocView docView, DElement e) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.element.addEventListener("blur", this, false);
        this.checkAttributes();
        int sz = this.element.getAttributeAsInt("size");
        if (sz <= 0) {
            sz = 20;
        }
        this.setColumns(sz);
        this.setBackground(Color.white);
        this.enableEvents(28L);
        this.addTextListener(this);
    }

    private void checkAttributes() {
        String s;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int i = this.element.getMaxLength();
        if (i > 0) {
            this.maxLength = i;
        }
        if ((s = this.element.getValue()) != null && !s.equals(this.getText())) {
            this.setText(s);
            try {
                this.setCaretPosition(s.length());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    public void textValueChanged(TextEvent e) {
        String domString;
        String s = this.getText();
        if (s.length() > this.maxLength) {
            int cpos = this.getCaretPosition();
            if (cpos > this.maxLength) {
                cpos = this.maxLength;
            }
            s = s.substring(0, this.maxLength);
            this.setText(s);
            try {
                this.setCaretPosition(cpos);
            }
            catch (IllegalComponentStateException ex) {
                // empty catch block
            }
        }
        if (!s.equals(domString = this.element.getValue())) {
            this.element.setValue(s);
        }
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    void updateFont() {
        CSSAttribs css;
        Font f;
        if (this.box != null && !(f = (css = this.box.getCSSAttribs()).getFont()).equals(super.getFont())) {
            int currentCaretPosition = this.getCaretPosition();
            Container parent = this.getParent();
            parent.remove(this);
            super.setFont(f);
            parent.add(this);
            try {
                this.setCaretPosition(currentCaretPosition);
            }
            catch (IllegalComponentStateException ex) {
                // empty catch block
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        FormInputText action = null;
        int id = e.getID();
        if (id == 401 || id == 402) {
            KeyEvent ke = (KeyEvent)e;
            int kc = ke.getKeyCode();
            if (kc == 65 && id == 401 && ke.isControlDown()) {
                this.selectAll();
                ke.consume();
            }
            if (kc == 39 || kc == 37) {
                action = this;
            }
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            super.processEvent(e);
            if (1004 == id) {
                if (this.startValue == null) {
                    this.startValue = this.getText();
                }
            } else if (1005 == id && !((FocusEvent)e).isTemporary()) {
                String tmp = this.getText();
                if (!tmp.equals(this.startValue)) {
                    this.element.dispatchChange();
                }
                this.startValue = null;
            }
        }
    }

    public void handleEvent(Event event) {
        if (((DOMEvent)event).getTypeId() == 22) {
            this.select(0, 0);
            return;
        }
        DOMUIEvent de = (DOMUIEvent)event;
        int caret = this.getCaretPosition();
        int textLength = this.getText().length();
        if (caret == 0 && de.getKeyCode() == 37L) {
            return;
        }
        if (caret == textLength && de.getKeyCode() == 39L) {
            return;
        }
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        String widthChar = Defs.sysProperty("ice.pilots.html4.colWidthChar");
        Dimension dim = super.getPreferredSize();
        if (widthChar == null || widthChar.length() != 1) {
            return dim;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int width = this.getColumns() * metrics.charWidth(widthChar.charAt(0));
            return new Dimension(width, dim.height);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width - this.docView.vbar.getSize().width;
    }
}

