/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.util.alg.HashArray;

public class DRange {
    DNode commonAncestorContainer;
    DNode startContainer;
    DNode endContainer;
    int startOffset;
    int endOffset;
    private HashArray pathStart = new HashArray();
    private HashArray pathEnd = new HashArray();

    protected DRange() {
    }

    public void empty() {
        this.commonAncestorContainer = null;
        this.endContainer = null;
        this.startContainer = null;
        this.pathStart.clear();
        this.pathEnd.clear();
    }

    void setStart(DNode n, int offset) {
        this.startContainer = n;
        this.startOffset = offset;
        this.findCommon();
    }

    void setEnd(DNode n, int offset) {
        this.endContainer = n;
        this.endOffset = offset;
        this.findCommon();
    }

    void setRange(DNode s, int s_off, DNode e, int e_off) {
        this.startContainer = s;
        this.startOffset = s_off;
        this.endContainer = e;
        this.endOffset = e_off;
        this.findCommon();
    }

    DNode getCommonAncestor() {
        return this.commonAncestorContainer;
    }

    public String toString() {
        if (this.startContainer == null || this.endContainer == null || this.commonAncestorContainer == null) {
            return null;
        }
        if (this.startContainer == this.endContainer) {
            DNode n = this.startContainer;
            if (n instanceof DTextNode) {
                DTextNode tn = (DTextNode)n;
                return new String(tn.text, this.startOffset, this.endOffset - this.startOffset);
            }
            return null;
        }
        StringBuffer sel = new StringBuffer();
        DNode n = this.commonAncestorContainer.first;
        while (n != null && this.pathStart.get(n) == null) {
            n = n.next;
        }
        while (n != null) {
            if (this.isVisible(n)) {
                this.addToStringBuffer_r(n, sel);
            }
            if (this.pathEnd.get(n) != null) break;
            n = n.next;
        }
        if (sel.length() == 0) {
            return null;
        }
        return sel.toString();
    }

    private boolean isVisible(DNode dNode) {
        int id = dNode.getNameId();
        boolean isVisible = true;
        switch (id) {
            case 15: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 70: 
            case 71: 
            case 76: 
            case 82: 
            case 86: {
                isVisible = false;
            }
        }
        return isVisible;
    }

    private final void addToStringBuffer_r(DNode n, StringBuffer sel) {
        if (n == null) {
            return;
        }
        if (this.isBreak(n)) {
            sel.append("\n");
            return;
        }
        if (this.isPrependBlock(n)) {
            sel.append(this.getBlockPrependChars(n));
        }
        if (n instanceof DTextNode) {
            DTextNode tn = (DTextNode)n;
            if (this.isVisible(n)) {
                if (n == this.startContainer) {
                    sel.append(tn.text, this.startOffset, tn.getLength() - this.startOffset);
                } else if (n == this.endContainer) {
                    sel.append(tn.text, 0, this.endOffset);
                } else {
                    sel.append(tn.text);
                }
            }
            return;
        }
        DNode t = n.first;
        if (this.pathStart.get(n) != null) {
            while (t != null && this.pathStart.get(t) == null) {
                t = t.next;
            }
            while (t != null) {
                if (this.isVisible(t)) {
                    this.addToStringBuffer_r(t, sel);
                }
                t = t.next;
            }
        } else if (this.pathEnd.get(n) != null) {
            while (t != null) {
                if (this.isVisible(t)) {
                    this.addToStringBuffer_r(t, sel);
                }
                if (this.pathEnd.get(t) == null) {
                    t = t.next;
                    continue;
                }
                break;
            }
        } else {
            while (t != null) {
                if (this.isVisible(t)) {
                    this.addToStringBuffer_r(t, sel);
                }
                t = t.next;
            }
        }
        if (this.isPostpendBlock(n)) {
            sel.append(this.getBlockPostpendChars(n));
        }
    }

    private final void findCommon() {
        this.pathStart.clear();
        this.pathEnd.clear();
        this.commonAncestorContainer = null;
        DNode n = this.startContainer;
        while (n != null) {
            DNode t = this.endContainer;
            while (t != null && t != n) {
                t = t.parent;
            }
            if (t == n) {
                this.commonAncestorContainer = t;
                this.recordPaths();
                break;
            }
            n = n.parent;
        }
    }

    private final void recordPaths() {
        if (this.startContainer == null || this.endContainer == null || this.commonAncestorContainer == null) {
            return;
        }
        DNode n = this.startContainer;
        DNode startPrev = null;
        DNode endPrev = null;
        this.pathStart.put(n, (Object)n);
        while (n != this.commonAncestorContainer) {
            this.pathStart.put(n, (Object)n);
            startPrev = n;
            n = n.parent;
        }
        n = this.endContainer;
        this.pathEnd.put(n, (Object)n);
        while (n != this.commonAncestorContainer) {
            this.pathEnd.put(n, (Object)n);
            endPrev = n;
            n = n.parent;
        }
        if (startPrev != endPrev || this.startContainer == this.endContainer) {
            n = endPrev;
            while (n != null && n != startPrev) {
                n = n.next;
            }
            if (this.startContainer == this.endContainer && this.startOffset <= this.endOffset) {
                return;
            }
            if (n == startPrev) {
                n = this.startContainer;
                this.startContainer = this.endContainer;
                this.endContainer = n;
                int tmp = this.startOffset;
                this.startOffset = this.endOffset;
                this.endOffset = tmp;
                HashArray aa = this.pathStart;
                this.pathStart = this.pathEnd;
                this.pathEnd = aa;
            }
        }
    }

    public final DElement duplicateSelectedDomHierarchy() {
        if (this.commonAncestorContainer != null) {
            return (DElement)this.domRecordPaths(this.commonAncestorContainer);
        }
        return null;
    }

    private final DNode domRecordPaths(DNode commonAncestor) {
        DNode cloneParent = null;
        DNode realNode = commonAncestor;
        DNode cloneNode = null;
        cloneNode = (DNode)realNode.clone(false);
        this.checkNodeAndTrim(cloneNode, commonAncestor);
        DNode ancestorClone = cloneNode;
        while (realNode.parent != null && !(realNode.parent instanceof DDocument)) {
            cloneNode.parent = cloneParent = (DNode)realNode.parent.clone(false);
            cloneParent.appendDChild(cloneNode);
            realNode = realNode.parent;
            cloneNode = cloneNode.parent;
        }
        this.recordChildren_r(commonAncestor, ancestorClone);
        return cloneParent;
    }

    private void recordChildren_r(DNode realNode, DNode cloneNode) {
        DNode child = realNode.first;
        while (child != null) {
            if (this.isInside(child)) {
                DNode clone = (DNode)child.clone(false);
                this.checkNodeAndTrim(clone, child);
                cloneNode.appendDChild(clone);
                this.recordChildren_r(child, clone);
            }
            child = child.next;
        }
    }

    private void checkNodeAndTrim(DNode cloneNode, DNode child) {
        int selectionLength = 0;
        int spos = 0;
        if (cloneNode instanceof DTextNode) {
            DTextNode textClone = (DTextNode)cloneNode;
            boolean endFound = false;
            selectionLength = ((DTextNode)child).text.length;
            if (child == this.startContainer) {
                spos = this.startOffset;
                selectionLength -= spos;
                endFound = true;
            }
            if (child == this.endContainer) {
                if (this.endOffset > 0) {
                    selectionLength -= ((DTextNode)this.endContainer).text.length - this.endOffset;
                }
                endFound = true;
            }
            if (endFound) {
                char[] text = ((DTextNode)child).text;
                textClone.setData(String.copyValueOf(text, spos, selectionLength));
            }
        }
    }

    public boolean isInside(DNode n) {
        if (n == this.startContainer || n == this.endContainer) {
            return true;
        }
        while (n != null && n != this.commonAncestorContainer) {
            DNode testNode = n.prev;
            while (testNode != null) {
                if (this.pathEnd.get(testNode) != null) {
                    return false;
                }
                if (this.pathStart.get(testNode) != null) {
                    return true;
                }
                testNode = testNode.prev;
            }
            testNode = n.next;
            while (testNode != null) {
                if (this.pathStart.get(testNode) != null) {
                    return false;
                }
                if (this.pathEnd.get(testNode) != null) {
                    return true;
                }
                testNode = testNode.next;
            }
            n = n.parent;
        }
        return false;
    }

    public boolean isInside(DNode node, int chrIndex) {
        boolean returnVal = this.isInside(node);
        if (!returnVal) {
            return false;
        }
        if (node == this.startContainer && chrIndex < this.startOffset) {
            return false;
        }
        return node != this.endContainer || chrIndex + 1 <= this.endOffset;
    }

    private boolean isBreak(DNode dNode) {
        int id = dNode.getNameId();
        boolean isBreak = false;
        switch (id) {
            case 14: {
                isBreak = true;
            }
        }
        return isBreak;
    }

    private String getBlockPrependChars(DNode node) {
        int id = node.getNameId();
        StringBuffer returnVal = new StringBuffer("\n");
        switch (id) {
            case 64: {
                returnVal.append("\n");
                break;
            }
            case 22: {
                returnVal.append("    ");
                break;
            }
            case 81: 
            case 84: {
                returnVal.setLength(2);
                returnVal.setCharAt(0, ' ');
                returnVal.setCharAt(1, ' ');
            }
        }
        return returnVal.toString();
    }

    private String getBlockPostpendChars(DNode node) {
        StringBuffer returnVal = new StringBuffer("\n");
        int id = node.getNameId();
        switch (id) {
            case 81: 
            case 84: {
                returnVal.setLength(1);
                returnVal.setCharAt(0, ' ');
            }
        }
        return returnVal.toString();
    }

    private boolean isPrependBlock(DNode dNode) {
        int id = dNode.getNameId();
        boolean isBlock = false;
        switch (id) {
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 64: 
            case 66: {
                isBlock = true;
            }
        }
        return isBlock;
    }

    private boolean isPostpendBlock(DNode dNode) {
        int id = dNode.getNameId();
        boolean isBlock = false;
        switch (id) {
            case 26: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 66: 
            case 81: 
            case 84: 
            case 87: {
                isBlock = true;
            }
        }
        return isBlock;
    }

    public DNode getStartContainer() {
        return this.startContainer;
    }

    public DNode getEndContainer() {
        return this.endContainer;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }
}

