/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TransformerFactory;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.StormBase;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html.HTMLDocument;

public class DOM
extends DynamicObject
implements DOMImplementation,
Cloneable {
    StormData sdata;
    DDocument _masterDocument;
    private static final int Method_createCSSStyleSheet = -1;
    private static final int Method_createDocument = -2;
    private static final int Method_createDocumentType = -3;
    private static final int Method_createHTMLDocument = -4;
    private static final int Method_hasFeature = -5;

    public static void setInstance(StormBase storm, DOM dom) {
        StormData sdata = StormData.get(storm);
        if (dom == null || sdata.domImplementation != null) {
            throw new IllegalArgumentException();
        }
        dom.sdata = sdata;
        sdata.domImplementation = dom;
    }

    public static DOM getInstance(StormBase storm) {
        return DOM.getInstance(StormData.get(storm));
    }

    static DOM getInstance(StormData sdata) {
        if (sdata.domImplementation == null) {
            DOM dom = new DOM();
            dom.sdata = sdata;
            sdata.domImplementation = dom;
        }
        return sdata.domImplementation;
    }

    public static void setInstance(DOM d) {
        throw new RuntimeException("Upgrade your code to use DOM.setInstance(StormBase, DOM)");
    }

    public static DOM getInstance() {
        throw new RuntimeException("Upgrade your code to use DOM.getInstance(StormBase)");
    }

    public static TransformerFactory getTransformFactory(StormBase storm) {
        return DOM.getInstance().getTransformFactory();
    }

    TransformerFactory getTransformFactory() {
        return this.sdata.transformerFactory;
    }

    public static void setTransformFactory(StormBase storm, TransformerFactory tr) {
        StormData sdata = StormData.get(storm);
        if (tr == null || sdata.transformerFactory != null) {
            throw new IllegalArgumentException();
        }
        sdata.transformerFactory = tr;
    }

    public static TransformerFactory getTransformerFactory() {
        throw new RuntimeException("Upgrade your code to use DOM.getTransformerFactory(StormBase)");
    }

    public static void setTransformerFactory(TransformerFactory tr) {
        throw new RuntimeException("Upgrade your code to use DOM.setTransformerFactory(StormBase, factory)");
    }

    protected DOM() {
    }

    final StormData getStormData() {
        return this.sdata;
    }

    DOM createDocumentSlave(DDocument newMaster) {
        DOM dom = this.makeClone();
        dom._masterDocument = newMaster;
        return dom;
    }

    protected final DOM makeClone() {
        DOM instance;
        try {
            instance = (DOM)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            instance = null;
        }
        instance.afterClone();
        return instance;
    }

    protected void afterClone() {
        this._masterDocument = null;
    }

    protected DDocument getMasterDocument() {
        return this._masterDocument;
    }

    public DDocument parseEmbeddedDocumentFromString(String str) {
        StringReader reader = new StringReader(str);
        try {
            return this.parseEmbeddedDocumentFromReader(reader);
        }
        catch (IOException ex) {
            Debug.bug();
            return null;
        }
    }

    public DDocument parseEmbeddedDocumentFromReader(Reader reader) throws IOException {
        DDocument sheet = this.createDDocument(this._masterDocument.pilot, false);
        DOMBuilder builder = new DOMBuilder(sheet, null);
        Lex2 lexer = new Lex2(builder);
        lexer.setReader(reader);
        lexer.parse();
        return sheet;
    }

    public boolean hasFeature(String feature, String version) {
        int v = Integer.MAX_VALUE;
        if (version != null) {
            if (version.equals("1.0")) {
                v = 1;
            } else if (version.equals("2.0")) {
                v = 2;
            }
        }
        if (feature.equals("Core") ? v >= 2 : (feature.equals("Views") ? v >= 2 : (feature.equals("Events") ? v >= 2 : (feature.equals("StyleSheets") ? v >= 2 : (feature.equals("CSS") ? v >= 2 : feature.equals("HTML") && v >= 2))))) {
            return true;
        }
        return feature.equalsIgnoreCase("xml") ? v >= 1 : feature.equalsIgnoreCase("html") && v >= 1;
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException(DNode.DOM_LEVEL_3_ERROR);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId, String internalSubset) {
        return null;
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        DDocument d = this.createDDocument(this._masterDocument.pilot, false);
        d.defaultNamespace = namespaceURI != null ? this.sdata.names.getNamespace(namespaceURI) : 0;
        return d;
    }

    public HTMLDocument createHTMLDocument(String documentTitle) {
        ThePilot pilot = this._masterDocument != null ? this._masterDocument.pilot : null;
        DDocument d = this.createDDocument(pilot, true);
        DElement html = d.createElement(43);
        DElement title = d.createElement(86);
        DElement head = d.createElement(41);
        DElement body = d.createElement(13);
        if (documentTitle == null) {
            documentTitle = "";
        }
        title.appendDChild(d.createDTextNode(documentTitle));
        head.appendDChild(title);
        html.appendDChild(head);
        html.appendDChild(body);
        d.appendDChild(html);
        return d;
    }

    public CSSStyleSheet createCSSStyleSheet(String title, String media) {
        DStyleSheet ss = this.createDStyleSheet(3, null, null, null);
        if (title != null) {
            ss.setTitle(title);
        }
        return ss;
    }

    public DStyleSheet createDStyleSheet(int defaultNamespace, DNode ownerNode, DStyleSheet parentStyleSheet, DCSSRule ownerRule) {
        DStyleSheet ss = new DStyleSheet(defaultNamespace, ownerNode, parentStyleSheet, ownerRule);
        return ss;
    }

    public DDocument createDDocument(ThePilot pilot, boolean isHtml) {
        DDocument d = new DDocument(pilot, this);
        d.setHtmlMode(isHtml);
        return d;
    }

    public DStyleDeclaration createDStyleDeclaration(DCSSRule parentRule, DElement e) {
        return new DStyleDeclaration(this, parentRule, e);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return null;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DOM.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DOM.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DOM.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.createCSSStyleSheet(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -2: {
                return this.createDocument(env.toStr(args, 0), env.toStr(args, 1), (DocumentType)env.toNative(args, 2));
            }
            case -3: {
                return this.createDocumentType(env.toStr(args, 0), env.toStr(args, 1), env.toStr(args, 2), env.toStr(args, 3));
            }
            case -4: {
                return this.createHTMLDocument(env.toStr(args, 0));
            }
            case -5: {
                return env.wrapBoolean(this.hasFeature(env.toStr(args, 0), env.toStr(args, 1)));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 10: {
                guess = "hasFeature";
                id = -5;
                break;
            }
            case 14: {
                guess = "createDocument";
                id = -2;
                break;
            }
            case 18: {
                char c = s.charAt(6);
                if (c == 'D') {
                    guess = "createDocumentType";
                    id = -3;
                    break;
                }
                if (c != 'H') break;
                guess = "createHTMLDocument";
                id = -4;
                break;
            }
            case 19: {
                guess = "createCSSStyleSheet";
                id = -1;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

