/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLInputElement;

public class DInputElement
extends FormTypeElement
implements HTMLInputElement {
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PASSWORD = 1;
    private static final int TYPE_CHECKBOX = 2;
    private static final int TYPE_RADIO = 3;
    private static final int TYPE_SUBMIT = 4;
    private static final int TYPE_RESET = 5;
    private static final int TYPE_FILE = 6;
    private static final int TYPE_HIDDEN = 7;
    private static final int TYPE_IMAGE = 8;
    private static final int TYPE_BUTTON = 9;
    private final String[] types = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"};
    public static final int DEFAULT_MAX_LENGTH = 10000;
    public static final int DEFAULT_SIZE = 20;
    private int type = 9;
    private int in_click_x;
    private int in_click_y;
    private boolean checked = false;
    private boolean defaultChecked = false;
    private String defaultValue;
    private static final int Field_accept = 1;
    private static final int Field_accessKey = 2;
    private static final int Field_align = 3;
    private static final int Field_alt = 4;
    private static final int Field_checked = 5;
    private static final int Field_defaultValue = 6;
    private static final int Field_defaultChecked = 7;
    private static final int Field_disabled = 8;
    private static final int Field_form = 9;
    private static final int Field_maxLength = 10;
    private static final int Field_readOnly = 11;
    private static final int Field_size = 12;
    private static final int Field_src = 13;
    private static final int Field_tabIndex = 14;
    private static final int Field_type = 15;
    private static final int Field_useMap = 16;
    private static final int Field_value = 17;
    private static final int Method_blur = -1;
    private static final int Method_focus = -2;
    private static final int Method_select = -3;
    private static final int Method_click = -4;
    private static final int Method_submit = -5;

    protected DInputElement(DDocument doc, int id) {
        super(doc, id);
    }

    void setAttributes(int[] ids, String[] vals, int num) {
        super.setAttributes(ids, vals, num);
        String checkedAttr = this.getAttribute(19);
        if (checkedAttr != null) {
            this.setAttribute(19, checkedAttr.toUpperCase());
            this.checked = true;
        }
        this.defaultChecked = this.checked;
        this.setDefaultValue(this.getValue());
        this.updateType();
    }

    public void setAttribute(String name, String value) {
        this.setAttribute(this.attrNameToId(name), value);
    }

    protected void setAttribute(int attrNameId, String value) {
        super.setAttribute(attrNameId, value);
        if (attrNameId == 111) {
            this.updateType();
        }
    }

    protected void onDAttrValueChange(DAttr attr) {
        if (attr.nameId == 111) {
            this.updateType();
        }
        super.onDAttrValueChange(attr);
    }

    void updateType() {
        int parsed_type = 0;
        String type_str = this.getAttribute(111);
        if (type_str != null) {
            for (int i = 0; i != this.types.length; ++i) {
                if (!type_str.equalsIgnoreCase(this.types[i])) continue;
                parsed_type = i;
                break;
            }
        }
        this.type = parsed_type;
        this.setDAttr(111, this.types[this.type], false);
        if (this.type != 8) {
            this.removeDAttr(119, true);
            this.removeDAttr(45, true);
        }
    }

    public void dispatchChange() {
        if (this.doc == null) {
            return;
        }
        DOMEvent de = this.doc.createDOMEvent(18);
        de.target = this;
        this.doc.processEvent(de);
    }

    public boolean dispatchEvent(Event event) {
        DOMUIEvent de;
        if (event instanceof DOMUIEvent && (de = (DOMUIEvent)event).getTypeId() == 1) {
            this.dispatchInputClick(de);
            return de.isDefaultCancelled();
        }
        return super.dispatchEvent(event);
    }

    private void dispatchInputClick(DOMUIEvent click) {
        if (this.getDisabled()) {
            return;
        }
        final boolean[] runDefault = new boolean[1];
        boolean originalCheckboxState = false;
        DInputElement originalSelectedRadio = null;
        if (this.type == 2) {
            originalCheckboxState = this.getChecked();
            this.setChecked(!originalCheckboxState, false);
        } else if (this.type == 3 && (originalSelectedRadio = this.getSelectedRadio()) != this) {
            this.setChecked(true, false);
        }
        if (click.getAction() == null) {
            click.setAction(new EventListener(){

                public void handleEvent(Event domEvent) {
                    runDefault[0] = true;
                }
            });
            super.dispatchEvent(click);
        }
        if (!runDefault[0]) {
            if (this.type == 2) {
                this.setChecked(originalCheckboxState, false);
            } else if (this.type == 3) {
                if (originalSelectedRadio == null) {
                    this.setChecked(false, false);
                } else if (originalSelectedRadio != this) {
                    originalSelectedRadio.setChecked(true, false);
                }
            }
        } else {
            this.in_click_x = click.posX;
            this.in_click_y = click.posY;
            if (this.type == 2 || this.type == 3) {
                this.dispatchChange();
            } else {
                DFormElement form = this.getDForm();
                if (form != null) {
                    if (this.type == 4 || this.type == 8) {
                        if (this.type != 4 || !click.cancel) {
                            form.submitWithEvent(this);
                        }
                    } else if (this.type == 5) {
                        form.reset();
                    }
                }
            }
        }
    }

    DInputElement getSelectedRadio() {
        String myname = this.getNameForServer();
        DFormElement form = this.getDForm();
        if (form != null && myname != null) {
            HTMLCollection els = form.getElements();
            int i = 0;
            Node n = els.item(i);
            while (n != null) {
                if (n instanceof DInputElement) {
                    String name;
                    DInputElement di = (DInputElement)n;
                    if (di.type == 3 && (name = di.getNameForServer()) != null && name.equals(myname) && di.checked) {
                        return di;
                    }
                }
                n = els.item(++i);
            }
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultChecked = defaultChecked;
    }

    public String getAccept() {
        return null;
    }

    public void setAccept(String accept) {
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute(4, accessKey);
    }

    public String getAlt() {
        return this.getAttribute(8);
    }

    public void setAlt(String alt) {
        this.setAttribute(8, alt);
    }

    public boolean getChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, true);
    }

    private void setChecked(boolean checked, boolean sendChangeEvent) {
        if (checked == this.checked) {
            return;
        }
        if (this.type == 2) {
            this.checked = checked;
        } else if (this.type == 3) {
            if (checked) {
                String myname = this.getNameForServer();
                DFormElement form = this.getDForm();
                if (form != null && myname != null) {
                    HTMLCollection els = form.getElements();
                    int i = 0;
                    Node n = els.item(i++);
                    while (n != null) {
                        String dename;
                        DInputElement de;
                        if (n instanceof DInputElement && n != this && (de = (DInputElement)n).getType().equalsIgnoreCase("radio") && (dename = de.getNameForServer()) != null && dename.equals(myname)) {
                            de.setChecked(false);
                        }
                        n = els.item(i++);
                    }
                }
            }
            this.checked = checked;
        }
        this.setAttribute(19, checked ? "checked" : null);
        if ((this.type == 2 || this.type == 3 && checked) && sendChangeEvent) {
            this.dispatchChange();
        }
    }

    public boolean getDisabled() {
        String test = this.getAttribute(38);
        return test != null && test.indexOf("Undefined") <= -1;
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute(38, disabled ? "disabled" : null);
    }

    public int getMaxLength() {
        int result = 10000;
        String str = this.getAttribute(59);
        if (str != null) {
            result = CSSUtil.parseInt(str, result);
        }
        return result;
    }

    public void setMaxLength(int maxLength) {
        this.setAttribute(59, Integer.toString(maxLength));
    }

    public boolean getReadOnly() {
        String test = this.getAttribute(89);
        return test != null && test.indexOf("Undefined") <= -1;
    }

    public void setReadOnly(boolean readOnly) {
        this.setAttribute(89, readOnly ? "readonly" : null);
    }

    public String getSize() {
        return this.getAttribute(100);
    }

    public void setSize(String size) {
        this.setAttribute(100, size);
    }

    public String getSrc() {
        return this.getAttribute(102);
    }

    public void setSrc(String src) {
        this.setAttribute(102, src);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int tabIndex) {
    }

    public String getType() {
        return this.types[this.type];
    }

    public void setType(String type) {
    }

    public String getUseMap() {
        return null;
    }

    public void setUseMap(String useMap) {
    }

    public String getValue() {
        String v = this.getAttribute(114);
        if (v == null && (this.type == 0 || this.type == 1 || this.type == 7)) {
            v = "";
        }
        return v;
    }

    public void setValue(String value) {
        this.setAttribute(114, value);
    }

    public void dispatchSelection(int start, int end) {
        if (this.type != 0) {
            Debug.bug();
        }
        DOMEvent de = this.doc.createDOMEvent(17);
        de.target = this;
        this.doc.processEvent(de);
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    public void select() {
        this.doc.getDomView().processSelectCall(this);
    }

    public void click() {
        if (this.getDisabled()) {
            return;
        }
        this.doc.getDomView().processClickCall(this);
    }

    public String getAlign() {
        return null;
    }

    public void setAlign(String align) {
    }

    void recordData(FormSubmitData data, Object submitSource) {
        switch (this.type) {
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                if (this.getDisabled() || !this.checked) break;
                String _value = this.getValue();
                if (_value == null) {
                    _value = "on";
                }
                data.appendData(this.getNameForServer(), _value);
                break;
            }
            case 6: {
                if (this.getDisabled()) break;
                data.appendFileData(this.getNameForServer(), this.fixValue(this.getValue()));
                break;
            }
            case 7: {
                data.appendData(this.getNameForServer(), this.getValue());
                break;
            }
            case 8: {
                if (this.getDisabled() || submitSource != this) break;
                String name = this.getNameForServer();
                name = name == null ? "" : name + ".";
                data.appendData(name + "x", "" + this.in_click_x);
                data.appendData(name + "y", "" + this.in_click_y);
                break;
            }
            case 0: 
            case 1: {
                if (this.getDisabled()) break;
                data.appendData(this.getNameForServer(), this.getValue());
                break;
            }
            case 4: {
                if (this.getDisabled() || submitSource != this) break;
                data.appendData(this.getNameForServer(), this.getValue());
                break;
            }
        }
    }

    void reset() {
        if (this.type == 2 || this.type == 3) {
            this.setChecked(this.getDefaultChecked());
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DInputElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DInputElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DInputElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAccept();
            }
            case 2: {
                return this.getAccessKey();
            }
            case 3: {
                return this.getAlign();
            }
            case 4: {
                return this.getAlt();
            }
            case 5: {
                return env.wrapBoolean(this.getChecked());
            }
            case 6: {
                return this.getDefaultValue();
            }
            case 7: {
                return env.wrapBoolean(this.getDefaultChecked());
            }
            case 8: {
                return env.wrapBoolean(this.getDisabled());
            }
            case 9: {
                return this.getDForm();
            }
            case 10: {
                return env.wrapInt(this.getMaxLength());
            }
            case 11: {
                return env.wrapBoolean(this.getReadOnly());
            }
            case 12: {
                return this.getSize();
            }
            case 13: {
                return this.getSrc();
            }
            case 14: {
                return env.wrapInt(this.getTabIndex());
            }
            case 15: {
                return this.getType();
            }
            case 16: {
                return this.getUseMap();
            }
            case 17: {
                return this.getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setAccept(env.toStr(value));
                return 1;
            }
            case 2: {
                this.setAccessKey(env.toStr(value));
                return 1;
            }
            case 3: {
                this.setAlign(env.toStr(value));
                return 1;
            }
            case 4: {
                this.setAlt(env.toStr(value));
                return 1;
            }
            case 5: {
                this.setChecked(env.toBoolean(value));
                return 1;
            }
            case 6: {
                this.setDefaultValue(env.toStr(value));
                return 1;
            }
            case 7: {
                this.setDefaultChecked(env.toBoolean(value));
                return 1;
            }
            case 8: {
                this.setDisabled(env.toBoolean(value));
                return 1;
            }
            case 9: {
                break;
            }
            case 10: {
                this.setMaxLength(env.toInt(value));
                return 1;
            }
            case 11: {
                this.setReadOnly(env.toBoolean(value));
                return 1;
            }
            case 12: {
                this.setSize(env.toStr(value));
                return 1;
            }
            case 13: {
                this.setSrc(env.toStr(value));
                return 1;
            }
            case 14: {
                this.setTabIndex(env.toInt(value));
                return 1;
            }
            case 15: {
                this.setType(env.toStr(value));
                return 1;
            }
            case 16: {
                this.setUseMap(env.toStr(value));
                return 1;
            }
            case 17: {
                this.setValue(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.blur();
                break;
            }
            case -2: {
                this.focus();
                break;
            }
            case -3: {
                this.select();
                break;
            }
            case -4: {
                this.click();
                break;
            }
            case -5: {
                DFormElement form = this.getDForm();
                if (form == null) break;
                form.submit();
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'a') {
                    guess = "alt";
                    id = 4;
                    break;
                }
                if (c != 's') break;
                guess = "src";
                id = 13;
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        guess = "blur";
                        id = -1;
                        break block0;
                    }
                    case 'f': {
                        guess = "form";
                        id = 9;
                        break block0;
                    }
                    case 's': {
                        guess = "size";
                        id = 12;
                        break block0;
                    }
                    case 't': {
                        guess = "type";
                        id = 15;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'a': {
                        guess = "align";
                        id = 3;
                        break block0;
                    }
                    case 'c': {
                        guess = "click";
                        id = -4;
                        break block0;
                    }
                    case 'f': {
                        guess = "focus";
                        id = -2;
                        break block0;
                    }
                    case 'v': {
                        guess = "value";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = s.charAt(1);
                if (c == 'c') {
                    guess = "accept";
                    id = 1;
                    break;
                }
                if (c == 'e') {
                    guess = "select";
                    id = -3;
                    break;
                }
                if (c == 's') {
                    guess = "useMap";
                    id = 16;
                    break;
                }
                if (c != 'u') break;
                guess = "submit";
                id = -5;
                break;
            }
            case 7: {
                guess = "checked";
                id = 5;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "disabled";
                    id = 8;
                    break;
                }
                if (c == 'r') {
                    guess = "readOnly";
                    id = 11;
                    break;
                }
                if (c != 't') break;
                guess = "tabIndex";
                id = 14;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'a') {
                    guess = "accessKey";
                    id = 2;
                    break;
                }
                if (c != 'm') break;
                guess = "maxLength";
                id = 10;
                break;
            }
            case 12: {
                guess = "defaultValue";
                id = 6;
                break;
            }
            case 14: {
                guess = "defaultChecked";
                id = 7;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

