/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.applet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import java.util.Vector;

public class ErrorComponent
extends Component {
    private static Font font = new Font("Arial", 0, 12);
    private static FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
    private Vector lines;
    private String message;

    ErrorComponent(String aMessage) {
        if (aMessage == null) {
            throw new IllegalArgumentException("Error message cannot be null");
        }
        this.message = aMessage;
    }

    public void paint(Graphics g) {
        if (this.lines == null) {
            this.lines = new Vector(5, 5);
            Dimension size = this.getSize();
            StringBuffer line = new StringBuffer();
            String token = "";
            boolean newline = true;
            StringTokenizer st = new StringTokenizer(this.message, " ");
            while (st.hasMoreElements()) {
                token = st.nextToken() + " ";
                if (newline) {
                    line.append(token);
                    newline = false;
                    continue;
                }
                if (fm.stringWidth(line.toString() + token) < size.width - 10) {
                    line.append(token);
                    continue;
                }
                this.lines.addElement(line.toString().trim());
                line.setLength(0);
                line.append(token);
                newline = true;
            }
            if (line.length() > 0) {
                this.lines.addElement(line.toString());
            }
        }
        g.setFont(font);
        for (int idx = 0; idx < this.lines.size(); ++idx) {
            String line = (String)this.lines.elementAt(idx);
            int y = 20 + idx * fm.getHeight();
            g.drawString(line, 5, y);
        }
    }
}

