/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.DToA;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;

final class NativeNumber
extends IdScriptable {
    private static final int MAX_PRECISION = 100;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_toFixed = 5;
    private static final int Id_toExponential = 6;
    private static final int Id_toPrecision = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private static final double defaultValue = 0.0;
    private double doubleValue;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeNumber obj = new NativeNumber();
        obj.prototypeFlag = true;
        obj.addAsPrototype(7, cx, scope, sealed);
    }

    private NativeNumber() {
        this.doubleValue = 0.0;
    }

    private NativeNumber(double number) {
        this.doubleValue = number;
    }

    public String getClassName() {
        return "Number";
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        int attr = 7;
        ctor.defineProperty("NaN", this.wrap_double(ScriptRuntime.NaN), 7);
        ctor.defineProperty("POSITIVE_INFINITY", this.wrap_double(Double.POSITIVE_INFINITY), 7);
        ctor.defineProperty("NEGATIVE_INFINITY", this.wrap_double(Double.NEGATIVE_INFINITY), 7);
        ctor.defineProperty("MAX_VALUE", this.wrap_double(Double.MAX_VALUE), 7);
        ctor.defineProperty("MIN_VALUE", this.wrap_double(Double.MIN_VALUE), 7);
        super.fillConstructorProperties(cx, ctor, sealed);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return this.jsConstructor(args, thisObj == null);
                }
                case 2: {
                    return this.realThis(thisObj, f).js_toString(NativeNumber.toBase(args, 0));
                }
                case 3: {
                    return this.wrap_double(this.realThis((Scriptable)thisObj, (IdFunction)f).doubleValue);
                }
                case 4: {
                    return this.realThis(thisObj, f).js_toLocaleString(NativeNumber.toBase(args, 0));
                }
                case 5: {
                    return this.realThis(thisObj, f).js_toFixed(cx, args);
                }
                case 6: {
                    return this.realThis(thisObj, f).js_toExponential(cx, args);
                }
                case 7: {
                    return this.realThis(thisObj, f).js_toPrecision(cx, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeNumber realThis(Scriptable thisObj, IdFunction f) {
        while (!(thisObj instanceof NativeNumber)) {
            thisObj = this.nextInstanceCheck(thisObj, f, true);
        }
        return (NativeNumber)thisObj;
    }

    private static int toBase(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInt32(args[index]) : 10;
    }

    private Object jsConstructor(Object[] args, boolean inNewExpr) {
        double d;
        double d2 = d = args.length >= 1 ? ScriptRuntime.toNumber(args[0]) : 0.0;
        if (inNewExpr) {
            return new NativeNumber(d);
        }
        return this.wrap_double(d);
    }

    public String toString() {
        return this.js_toString(10);
    }

    private String js_toString(int base) {
        return ScriptRuntime.numberToString(this.doubleValue, base);
    }

    private String js_toLocaleString(int base) {
        return this.js_toString(base);
    }

    private String js_toFixed(Context cx, Object[] args) {
        return this.num_to(cx, args, 2, 2, -20, 100, 0);
    }

    private String js_toExponential(Context cx, Object[] args) {
        return this.num_to(cx, args, 1, 3, 0, 100, 1);
    }

    private String js_toPrecision(Context cx, Object[] args) {
        return this.num_to(cx, args, 0, 4, 1, 100, 0);
    }

    private String num_to(Context cx, Object[] args, int zeroArgMode, int oneArgMode, int precisionMin, int precisionMax, int precisionOffset) {
        int precision;
        if (args.length == 0) {
            precision = 0;
            oneArgMode = zeroArgMode;
        } else {
            precision = ScriptRuntime.toInt32(args[0]);
            if (precision < precisionMin || precision > precisionMax) {
                String msg = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(args[0]));
                throw NativeGlobal.constructError(cx, "RangeError", msg, this);
            }
        }
        StringBuffer result = new StringBuffer();
        DToA.JS_dtostr(result, oneArgMode, precision + precisionOffset, this.doubleValue);
        return result.toString();
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            switch (id) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "valueOf";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "toFixed";
                }
                case 6: {
                    return "toExponential";
                }
                case 7: {
                    return "toPrecision";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                char c = s.charAt(0);
                if (c == 't') {
                    X = "toFixed";
                    id = 5;
                    break;
                }
                if (c != 'v') break;
                X = "valueOf";
                id = 3;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c != 't') break;
                X = "toPrecision";
                id = 7;
                break;
            }
            case 13: {
                X = "toExponential";
                id = 6;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 4;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

