/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.classfile;

import ice.mozilla.classfile.ClassFileWriter;
import ice.mozilla.classfile.Utf8StringIndexPair;
import ice.mozilla.javascript.WrappedException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

class ConstantPool {
    private static final int ConstantPoolSize = 256;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private Hashtable itsUtf8Hash = new Hashtable();
    private Hashtable itsFieldRefHash = new Hashtable();
    private Hashtable itsMethodRefHash = new Hashtable();
    private Hashtable itsClassHash = new Hashtable();
    private int itsTop = 0;
    private int itsTopIndex = 1;
    private byte[] itsPool = new byte[256];

    ConstantPool() {
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort((short)this.itsTopIndex);
        out.write(this.itsPool, 0, this.itsTop);
    }

    int getWriteSize() {
        return 2 + this.itsTop;
    }

    short addConstant(int k) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 3;
        this.itsPool[this.itsTop++] = (byte)(k >> 24);
        this.itsPool[this.itsTop++] = (byte)(k >> 16);
        this.itsPool[this.itsTop++] = (byte)(k >> 8);
        this.itsPool[this.itsTop++] = (byte)k;
        return (short)this.itsTopIndex++;
    }

    short addConstant(long k) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 5;
        this.itsPool[this.itsTop++] = (byte)(k >> 56);
        this.itsPool[this.itsTop++] = (byte)(k >> 48);
        this.itsPool[this.itsTop++] = (byte)(k >> 40);
        this.itsPool[this.itsTop++] = (byte)(k >> 32);
        this.itsPool[this.itsTop++] = (byte)(k >> 24);
        this.itsPool[this.itsTop++] = (byte)(k >> 16);
        this.itsPool[this.itsTop++] = (byte)(k >> 8);
        this.itsPool[this.itsTop++] = (byte)k;
        short index = (short)this.itsTopIndex;
        this.itsTopIndex += 2;
        return index;
    }

    short addConstant(float k) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 4;
        int bits = Float.floatToIntBits(k);
        this.itsPool[this.itsTop++] = (byte)(bits >> 24);
        this.itsPool[this.itsTop++] = (byte)(bits >> 16);
        this.itsPool[this.itsTop++] = (byte)(bits >> 8);
        this.itsPool[this.itsTop++] = (byte)bits;
        return (short)this.itsTopIndex++;
    }

    short addConstant(double k) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 6;
        long bits = Double.doubleToLongBits(k);
        this.itsPool[this.itsTop++] = (byte)(bits >> 56);
        this.itsPool[this.itsTop++] = (byte)(bits >> 48);
        this.itsPool[this.itsTop++] = (byte)(bits >> 40);
        this.itsPool[this.itsTop++] = (byte)(bits >> 32);
        this.itsPool[this.itsTop++] = (byte)(bits >> 24);
        this.itsPool[this.itsTop++] = (byte)(bits >> 16);
        this.itsPool[this.itsTop++] = (byte)(bits >> 8);
        this.itsPool[this.itsTop++] = (byte)bits;
        short index = (short)this.itsTopIndex;
        this.itsTopIndex += 2;
        return index;
    }

    short addConstant(String k) {
        Utf8StringIndexPair theIndex = (Utf8StringIndexPair)this.itsUtf8Hash.get(k);
        if (theIndex == null) {
            this.addUtf8(k);
            theIndex = (Utf8StringIndexPair)this.itsUtf8Hash.get(k);
        }
        if (theIndex.itsStringIndex == -1) {
            theIndex.itsStringIndex = (short)this.itsTopIndex++;
            this.ensure(3);
            this.itsPool[this.itsTop++] = 8;
            this.itsPool[this.itsTop++] = (byte)(theIndex.itsUtf8Index >> 8);
            this.itsPool[this.itsTop++] = (byte)theIndex.itsUtf8Index;
        }
        return theIndex.itsStringIndex;
    }

    short addUtf8(String contents) {
        Utf8StringIndexPair theIndex = (Utf8StringIndexPair)this.itsUtf8Hash.get(contents);
        if (theIndex == null) {
            theIndex = new Utf8StringIndexPair((short)this.itsTopIndex++, -1);
            this.itsUtf8Hash.put(contents, theIndex);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeUTF(contents);
                byte[] theBytes = baos.toByteArray();
                this.ensure(1 + theBytes.length);
                this.itsPool[this.itsTop++] = 1;
                System.arraycopy(theBytes, 0, this.itsPool, this.itsTop, theBytes.length);
                this.itsTop += theBytes.length;
            }
            catch (IOException iox) {
                throw WrappedException.wrapException(iox);
            }
        }
        return theIndex.itsUtf8Index;
    }

    short addNameAndType(short nameIndex, short typeIndex) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 12;
        this.itsPool[this.itsTop++] = (byte)(nameIndex >> 8);
        this.itsPool[this.itsTop++] = (byte)nameIndex;
        this.itsPool[this.itsTop++] = (byte)(typeIndex >> 8);
        this.itsPool[this.itsTop++] = (byte)typeIndex;
        return (short)this.itsTopIndex++;
    }

    short addClass(short classIndex) {
        Short classIndexKey = new Short(classIndex);
        Short theIndex = (Short)this.itsClassHash.get(classIndexKey);
        if (theIndex == null) {
            this.ensure(3);
            this.itsPool[this.itsTop++] = 7;
            this.itsPool[this.itsTop++] = (byte)(classIndex >> 8);
            this.itsPool[this.itsTop++] = (byte)classIndex;
            theIndex = new Short((short)this.itsTopIndex++);
            this.itsClassHash.put(classIndexKey, theIndex);
        }
        return theIndex;
    }

    short addClass(String className) {
        short classIndex = this.addUtf8(ClassFileWriter.fullyQualifiedForm(className));
        return this.addClass(classIndex);
    }

    short addFieldRef(String className, String fieldName, String fieldType) {
        String fieldRefString = className + " " + fieldName + " " + fieldType;
        Short theIndex = (Short)this.itsFieldRefHash.get(fieldRefString);
        if (theIndex == null) {
            short nameIndex = this.addUtf8(fieldName);
            short typeIndex = this.addUtf8(fieldType);
            short ntIndex = this.addNameAndType(nameIndex, typeIndex);
            short classIndex = this.addClass(className);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 9;
            this.itsPool[this.itsTop++] = (byte)(classIndex >> 8);
            this.itsPool[this.itsTop++] = (byte)classIndex;
            this.itsPool[this.itsTop++] = (byte)(ntIndex >> 8);
            this.itsPool[this.itsTop++] = (byte)ntIndex;
            theIndex = new Short((short)this.itsTopIndex++);
            this.itsFieldRefHash.put(fieldRefString, theIndex);
        }
        return theIndex;
    }

    short addMethodRef(String className, String methodName, String fieldType) {
        String methodRefString = className + " " + methodName + " " + fieldType;
        Short theIndex = (Short)this.itsMethodRefHash.get(methodRefString);
        if (theIndex == null) {
            short nameIndex = this.addUtf8(methodName);
            short typeIndex = this.addUtf8(fieldType);
            short ntIndex = this.addNameAndType(nameIndex, typeIndex);
            short classIndex = this.addClass(className);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 10;
            this.itsPool[this.itsTop++] = (byte)(classIndex >> 8);
            this.itsPool[this.itsTop++] = (byte)classIndex;
            this.itsPool[this.itsTop++] = (byte)(ntIndex >> 8);
            this.itsPool[this.itsTop++] = (byte)ntIndex;
            theIndex = new Short((short)this.itsTopIndex++);
            this.itsMethodRefHash.put(methodRefString, theIndex);
        }
        return theIndex;
    }

    short addInterfaceMethodRef(String className, String methodName, String methodType) {
        short nameIndex = this.addUtf8(methodName);
        short typeIndex = this.addUtf8(methodType);
        short ntIndex = this.addNameAndType(nameIndex, typeIndex);
        short classIndex = this.addClass(className);
        this.ensure(5);
        this.itsPool[this.itsTop++] = 11;
        this.itsPool[this.itsTop++] = (byte)(classIndex >> 8);
        this.itsPool[this.itsTop++] = (byte)classIndex;
        this.itsPool[this.itsTop++] = (byte)(ntIndex >> 8);
        this.itsPool[this.itsTop++] = (byte)ntIndex;
        return (short)this.itsTopIndex++;
    }

    void ensure(int howMuch) {
        while (this.itsTop + howMuch >= this.itsPool.length) {
            byte[] oldPool = this.itsPool;
            this.itsPool = new byte[this.itsPool.length * 2];
            System.arraycopy(oldPool, 0, this.itsPool, 0, this.itsTop);
        }
    }
}

